10 CLS:CLEAR
20 ON ERROR GOTO 880
30 PRINT " Program TABLE. Compiles an impedance table of an antenna over"
40 PRINT " a range of frequencies, from data on an impedance .DAT file"
50 PRINT "      Copyright Peter Dodd G3LDO" :PRINT:PRINT
60 FILES "*.DAT"
70 PRINT " Enter .DAT file from the above list."
80 INPUT "Remember to add .DAT after the file name. ", NF$:CLS
90 PI = 3.1416:B = 50
100 DIM AA(9)
110 DIM CC(9)
120 DIM DD(9)
130 DIM EE(9)
140 DIM RR(9)
150 DIM XX(9)
160 DIM FY(9)
170 DIM P$(9)
180 OPEN "I", #1, NF$
190 INPUT #1, TITLE$
200 PRINT : PRINT TITLE$: PRINT
210 PRINT "   Input Parameters                   Results         +/-Errors"
220 PRINT "Freq     A     C      D      E        Res      jX     Res    jX"
230 PRINT "-----------------------------------------------------------------"
240 INPUT #1, M
250 MM = M
260 FOR Z = 1 TO MM
270 INPUT #1, FY(Z), AA(Z), CC(Z), DD(Z), EE(Z)
280 A = AA(Z)
290 C = CC(Z)
300 D = DD(Z)
310 E = EE(Z)
320 F = (B * B + C * C - A * A) / (2 * B * C)
330 IF F = 0 THEN G = PI / 2: GOTO 350
340 G = ATN(SQR(1 / (F * F) - 1)): IF F < 0 THEN G = PI - G
350 H = (C * C + D * D - E * E) / (2 * C * D)
360 IF H = 0 THEN J = PI / 2: GOTO 380
370 J = ATN(SQR(1 / (H * H) - 1)): IF H < 0 THEN J = PI - J
380 K = (A * A + B * B - C * C) / (2 * A * B)
390 IF K = 0 THEN L = PI / 2: GOTO 410
400 L = ATN(SQR(1 / (K * K) - 1)): IF K < 0 THEN L = PI - L
410 M = (D * D + E * E - C * C) / (2 * D * E)
420 IF M = 0 THEN N = PI / 2: GOTO 440
430 N = ATN(SQR(1 / (M * M) - 1)): IF M < 0 THEN N = PI - N
440 Q = ATN(B / D)
450 T = B / SIN(Q)
460 ZZ = (T * T + E * E - A * A) / (2 * T * E)
470 IF ZZ = 0 THEN P = PI / 2: GOTO 490
480 P = ATN(SQR(1 / (ZZ * ZZ) - 1)): IF ZZ < 0 THEN P = PI -P
490 S = P - Q
500 IF (L + Q) > (PI / 2) THEN S = (2 * PI) - (P + Q)
510 IF H > 0 THEN X1 = D - A * SIN(L) ELSE X1 = D + A * SIN(L)
520 X2 = E * M
530 X3 = E * COS(S)
540 R1 = A * K - B
550 R2 = E * SIN(N)
560 R3 = E * SIN(S)
570 X = (X1 + X2 + X3) / 3
580 R = (R1 + R2 + R3) / 3
590 V1 = ABS(X1 - X)
600 V2 = ABS(X2 - X)
610 V3 = ABS(X3 - X)
620 W1 = ABS(R1 - R)
630 W2 = ABS(R2 - R)
640 W3 = ABS(R3 - R)
650 IF V1 >= V2 THEN GOTO 670
660 IF V2 >= V3 THEN EX = V2: GOTO 690
670 IF V1 >= V3 THEN EX = V1: GOTO 690
680 EX = V3
690 IF W1 >= W2 THEN GOTO 720
700 IF W2 >= W3 THEN ER = W2: GOTO 740
710 ER = W3
720 IF W1 >= W3 THEN ER = W1: GOTO 740
730 ER = W3
740 IF X >= 0 THEN P$(MM) = "+": GOTO 760
750 P$(MM) = "-"
760 ZZ(Z) = INT(10 * ER + .5) / 10
770 RR(Z) = INT(10 * R + .5) / 10
780 XX(Z) = ABS(INT(10 * X + .5) / 10)
790 EJ(Z) = INT(10 * EX + .5) / 10
800 PRINT FY(Z); TAB(8); AA(Z); TAB(15); CC(Z); TAB(22); DD(Z); TAB(29); EE(Z); TAB(37); RR(Z); TAB(45); P$(MM); TAB(46); XX(Z); TAB(55); ZZ(Z); TAB(62); EJ(Z)
810 NEXT
820 CLOSE #1
830 PRINT : PRINT
840 INPUT "Goto Main Menu 1.  Repeat this program 2. "; AA
850 IF AA = 1 THEN CHAIN "MENU"
860 IF AA = 2 GOTO 10
870 END
880 CLS : PRINT "ERROR IN DATA OR INCORRECT FILE NAME" :RESUME 820
