#! /usr/bin/octave -qf
f = linspace(6.0, 8.0, 101);
fd = [6.0, 6.5, 7.0, 7.5, 8.0];
d = 60;  # length of line in feet
a = 0.0648 .* sqrt(f) .- 0.0048;    # alpha for 450 ohm line
v = 91;                             # 450 ohm open wire line
Zo = 450;                           # 450 ohm open wire line
#a = 0.3237 .* sqrt(f) .-0.02373;   # alpha for 50 ohm coax
#v = 85;                            # 50 ohm coax
#Zo = 50;                           # 50 ohm coax
Rd = [26.91, 38.10, 52.94, 72.47, 98.06];
Xd = [-254.8, -131.0, -10.78, 108.6, 229.2];
Rcoef = polyfit(fd, Rd, 2);
Xcoef = polyfit(fd, Xd, 1);
Rt = polyval(Rcoef, f);
Xt = polyval(Xcoef, f);
a = a ./ 1e2;  # convert dB per 100 feet to dB per foot
a = 0.1151 .* a;  # convert dB to nepers
c = 9.836e8;  # speed of light in feet per second
lambda = c ./ (1e6 .* f);  # wavelength of signal in vacuum
lambda = (v ./ 1e2) .* lambda; # adjust lambda for velocity
B = (2 .* pi) ./ lambda; # calculate Beta
Zt = Rt .+ j .* Xt;  # calculate complex terminating impedance
Zd = Zo .* tanh((a .+ j .* B) .* d .+ atanh(Zt ./ Zo));
plot(f, imag(Zd), f, Xt, f, 0 .* Xt, "-b");
title("INPUT IMPEDANCE");
xlabel("FREQUENCY IN MHz");
ylabel("REACTIVE COMPONENT OF IMPEDANCE");
text(6.2, -110, "ANTENNA")
text(6.4, -550, "60 FEET 450 OHM WINDOW LINE")
#text(7.4, 150, "ANTENNA")
#text(7.4, -120, "60 FEET RG-58")
grid;
pause;

