/*******************************************************************************
* File Name: QCLK.c  
* Version 1.50
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "cytypes.h"
#include "QCLK.h"


/*******************************************************************************
* Function Name: QCLK_Write
********************************************************************************
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  void 
*  
*******************************************************************************/
void QCLK_Write(uint8 value) 
{
    uint8 staticBits = QCLK_DR & ~QCLK_MASK;
    QCLK_DR = staticBits | ((value << QCLK_SHIFT) & QCLK_MASK);
}


/*******************************************************************************
* Function Name: QCLK_SetDriveMode
********************************************************************************
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to this drive mode.
*
* Return: 
*  void
*
*******************************************************************************/
void QCLK_SetDriveMode(uint8 mode) 
{
	CyPins_SetPinDriveMode(QCLK_0, mode);
}


/*******************************************************************************
* Function Name: QCLK_Read
********************************************************************************
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro QCLK_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 QCLK_Read(void) 
{
    return (QCLK_PS & QCLK_MASK) >> QCLK_SHIFT;
}


/*******************************************************************************
* Function Name: QCLK_ReadDataReg
********************************************************************************
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 QCLK_ReadDataReg(void) 
{
    return (QCLK_DR & QCLK_MASK) >> QCLK_SHIFT;
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(QCLK_INTSTAT) 

    /*******************************************************************************
    * Function Name: QCLK_ClearInterrupt
    ********************************************************************************
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  void 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 QCLK_ClearInterrupt(void) 
    {
        return (QCLK_INTSTAT & QCLK_MASK) >> QCLK_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */ 
