/*******************************************************************************
* File Name: QCLK.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_QCLK_H) /* Pins QCLK_H */
#define CY_PINS_QCLK_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "QCLK_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    QCLK_Write(uint8 value) ;
void    QCLK_SetDriveMode(uint8 mode) ;
uint8   QCLK_ReadDataReg(void) ;
uint8   QCLK_Read(void) ;
uint8   QCLK_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define QCLK_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define QCLK_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define QCLK_DM_RES_UP          PIN_DM_RES_UP
#define QCLK_DM_RES_DWN         PIN_DM_RES_DWN
#define QCLK_DM_OD_LO           PIN_DM_OD_LO
#define QCLK_DM_OD_HI           PIN_DM_OD_HI
#define QCLK_DM_STRONG          PIN_DM_STRONG
#define QCLK_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define QCLK_MASK               QCLK__MASK
#define QCLK_SHIFT              QCLK__SHIFT
#define QCLK_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define QCLK_PS                     (* (reg8 *) QCLK__PS)
/* Data Register */
#define QCLK_DR                     (* (reg8 *) QCLK__DR)
/* Port Number */
#define QCLK_PRT_NUM                (* (reg8 *) QCLK__PRT) 
/* Connect to Analog Globals */                                                  
#define QCLK_AG                     (* (reg8 *) QCLK__AG)                       
/* Analog MUX bux enable */
#define QCLK_AMUX                   (* (reg8 *) QCLK__AMUX) 
/* Bidirectional Enable */                                                        
#define QCLK_BIE                    (* (reg8 *) QCLK__BIE)
/* Bit-mask for Aliased Register Access */
#define QCLK_BIT_MASK               (* (reg8 *) QCLK__BIT_MASK)
/* Bypass Enable */
#define QCLK_BYP                    (* (reg8 *) QCLK__BYP)
/* Port wide control signals */                                                   
#define QCLK_CTL                    (* (reg8 *) QCLK__CTL)
/* Drive Modes */
#define QCLK_DM0                    (* (reg8 *) QCLK__DM0) 
#define QCLK_DM1                    (* (reg8 *) QCLK__DM1)
#define QCLK_DM2                    (* (reg8 *) QCLK__DM2) 
/* Input Buffer Disable Override */
#define QCLK_INP_DIS                (* (reg8 *) QCLK__INP_DIS)
/* LCD Common or Segment Drive */
#define QCLK_LCD_COM_SEG            (* (reg8 *) QCLK__LCD_COM_SEG)
/* Enable Segment LCD */
#define QCLK_LCD_EN                 (* (reg8 *) QCLK__LCD_EN)
/* Slew Rate Control */
#define QCLK_SLW                    (* (reg8 *) QCLK__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define QCLK_PRTDSI__CAPS_SEL       (* (reg8 *) QCLK__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define QCLK_PRTDSI__DBL_SYNC_IN    (* (reg8 *) QCLK__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define QCLK_PRTDSI__OE_SEL0        (* (reg8 *) QCLK__PRTDSI__OE_SEL0) 
#define QCLK_PRTDSI__OE_SEL1        (* (reg8 *) QCLK__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define QCLK_PRTDSI__OUT_SEL0       (* (reg8 *) QCLK__PRTDSI__OUT_SEL0) 
#define QCLK_PRTDSI__OUT_SEL1       (* (reg8 *) QCLK__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define QCLK_PRTDSI__SYNC_OUT       (* (reg8 *) QCLK__PRTDSI__SYNC_OUT) 


#if defined(QCLK__INTSTAT)  /* Interrupt Registers */

    #define QCLK_INTSTAT                (* (reg8 *) QCLK__INTSTAT)
    #define QCLK_SNAP                   (* (reg8 *) QCLK__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins QCLK_H */


/* [] END OF FILE */
