/*******************************************************************************
* File Name: TP1_IN.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_TP1_IN_H) /* Pins TP1_IN_H */
#define CY_PINS_TP1_IN_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "TP1_IN_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    TP1_IN_Write(uint8 value) ;
void    TP1_IN_SetDriveMode(uint8 mode) ;
uint8   TP1_IN_ReadDataReg(void) ;
uint8   TP1_IN_Read(void) ;
uint8   TP1_IN_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define TP1_IN_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define TP1_IN_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define TP1_IN_DM_RES_UP          PIN_DM_RES_UP
#define TP1_IN_DM_RES_DWN         PIN_DM_RES_DWN
#define TP1_IN_DM_OD_LO           PIN_DM_OD_LO
#define TP1_IN_DM_OD_HI           PIN_DM_OD_HI
#define TP1_IN_DM_STRONG          PIN_DM_STRONG
#define TP1_IN_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define TP1_IN_MASK               TP1_IN__MASK
#define TP1_IN_SHIFT              TP1_IN__SHIFT
#define TP1_IN_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define TP1_IN_PS                     (* (reg8 *) TP1_IN__PS)
/* Data Register */
#define TP1_IN_DR                     (* (reg8 *) TP1_IN__DR)
/* Port Number */
#define TP1_IN_PRT_NUM                (* (reg8 *) TP1_IN__PRT) 
/* Connect to Analog Globals */                                                  
#define TP1_IN_AG                     (* (reg8 *) TP1_IN__AG)                       
/* Analog MUX bux enable */
#define TP1_IN_AMUX                   (* (reg8 *) TP1_IN__AMUX) 
/* Bidirectional Enable */                                                        
#define TP1_IN_BIE                    (* (reg8 *) TP1_IN__BIE)
/* Bit-mask for Aliased Register Access */
#define TP1_IN_BIT_MASK               (* (reg8 *) TP1_IN__BIT_MASK)
/* Bypass Enable */
#define TP1_IN_BYP                    (* (reg8 *) TP1_IN__BYP)
/* Port wide control signals */                                                   
#define TP1_IN_CTL                    (* (reg8 *) TP1_IN__CTL)
/* Drive Modes */
#define TP1_IN_DM0                    (* (reg8 *) TP1_IN__DM0) 
#define TP1_IN_DM1                    (* (reg8 *) TP1_IN__DM1)
#define TP1_IN_DM2                    (* (reg8 *) TP1_IN__DM2) 
/* Input Buffer Disable Override */
#define TP1_IN_INP_DIS                (* (reg8 *) TP1_IN__INP_DIS)
/* LCD Common or Segment Drive */
#define TP1_IN_LCD_COM_SEG            (* (reg8 *) TP1_IN__LCD_COM_SEG)
/* Enable Segment LCD */
#define TP1_IN_LCD_EN                 (* (reg8 *) TP1_IN__LCD_EN)
/* Slew Rate Control */
#define TP1_IN_SLW                    (* (reg8 *) TP1_IN__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define TP1_IN_PRTDSI__CAPS_SEL       (* (reg8 *) TP1_IN__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define TP1_IN_PRTDSI__DBL_SYNC_IN    (* (reg8 *) TP1_IN__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define TP1_IN_PRTDSI__OE_SEL0        (* (reg8 *) TP1_IN__PRTDSI__OE_SEL0) 
#define TP1_IN_PRTDSI__OE_SEL1        (* (reg8 *) TP1_IN__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define TP1_IN_PRTDSI__OUT_SEL0       (* (reg8 *) TP1_IN__PRTDSI__OUT_SEL0) 
#define TP1_IN_PRTDSI__OUT_SEL1       (* (reg8 *) TP1_IN__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define TP1_IN_PRTDSI__SYNC_OUT       (* (reg8 *) TP1_IN__PRTDSI__SYNC_OUT) 


#if defined(TP1_IN__INTSTAT)  /* Interrupt Registers */

    #define TP1_IN_INTSTAT                (* (reg8 *) TP1_IN__INTSTAT)
    #define TP1_IN_SNAP                   (* (reg8 *) TP1_IN__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins TP1_IN_H */


/* [] END OF FILE */
