
//`#start header` -- edit after this line, do not edit this line
// ========================================
//
// Copyright SIMPLE CIRCUITS INC., 2010
// All Rights Reserved
// UNPUBLISHED, LICENSED SOFTWARE.
//
// CONFIDENTIAL AND PROPRIETARY INFORMATION
// WHICH IS THE PROPERTY OF Simple Circuits Inc.
//
// ========================================
`include "cypress.v"
//`#end` -- edit above this line, do not edit this line
// Generated on 05/20/2010 at 11:52
// Component: IQ_Generator
module IQ_Generator (
	iout,
	qout,
	clock
);
	output  iout;
	output  qout;
	input   clock;

//`#start body` -- edit after this line, do not edit this line


//----------------------------------------------------------------------------
//
//	SIMPLE SDR RECEIVER PSoC3 FIRMWARE for Hardware Rev -
//
//	Copyright 2011 Simple Circuits Inc.
//
//	06/03/2011	Original release.
//
//	IQ clock generator Verilog
//
//
//	Divides by 2*(divMax + 1).
//	divMax = 0 divides by 2 with output on iout only, no qout.
//	divMax = 1 divides by 4.
//	divMax = 2 divides by 6.
//	divMax = 15 divides by 32.
//
//----------------------------------------------------------------------------
	reg iout, qout;
	reg [3:0] divider;
	wire [7:0] divMax;			// divider max count value
	
	cy_psoc3_control #(.cy_init_value (8'b0), .cy_force_order(1))
	IQDividerMax (	.control(divMax) );

	always @(posedge clock)
	begin
		if (divider == divMax [3:0])
		begin
			divider <= 4'b0;
			iout <= ~iout;
		end
		else
		begin
			if (divider == {1'b0, divMax [3:1]})	// max count / 2
				qout <= iout;
			divider <= divider + 1;
		end
	end



//`#end` -- edit above this line, do not edit this line
endmodule
//`#start footer` -- edit after this line, do not edit this line
//`#end` -- edit above this line, do not edit this line
