/*******************************************************************************
* File Name: USBFS_1_episr.c
* Version 1.60
*
* Description:
*  Data endpoint Interrupt Service Routines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
********************************************************************************/

#include "USBFS_1.h"


/***************************************
* Custom Declratations
***************************************/
/* `#START CUSTOM_DECLARATIONS` Place your declaration here */

/* `#END` */


/***************************************
* External function references
***************************************/

void USBFS_1_InitComponent(uint8 device, uint8 mode);
void USBFS_1_ReInitComponent(void);


/***************************************
* External references
***************************************/

extern volatile T_USBFS_1_EP_CTL_BLOCK USBFS_1_EP[];
extern volatile uint8 USBFS_1_device;


#if(USBFS_1_EP1_ISR_REMOVE == 0u)

    /*******************************************************************************
    * Function Name: USBFS_1_EP_1_ISR
    ********************************************************************************
    *
    * Summary:
    *  Endpoint 1 Interrupt Service Routine
    *
    * Parameters:
    *  None.
    *
    * Return:
    *  None.
    *
    *******************************************************************************/
    CY_ISR(USBFS_1_EP_1_ISR)
    {
        /* `#START EP1_USER_CODE` Place your code here */

        /* `#END` */
    
        CY_GET_REG8(USBFS_1_SIE_EP1_CR0_PTR); /* Must read the mode reg */
        USBFS_1_EP[USBFS_1_EP1].epToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
        USBFS_1_EP[USBFS_1_EP1].apiEpState = USBFS_1_EVENT_PENDING;
        CY_SET_REG8(USBFS_1_SIE_EP_INT_SR_PTR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR_PTR) \
                                                                            & ~USBFS_1_SIE_EP_INT_EP1_MASK);
    
        /* PSoC3 ES1, ES2 RTC ISR PATCH  */
        #if(USBFS_1_PSOC3_ES2 && (USBFS_1_ep_1__ES2_PATCH))
            USBFS_1_ISR_PATCH();
        #endif /* End USBFS_1_PSOC3_ES2*/
    }

#endif   /* End USBFS_1_EP1_ISR_REMOVE */


#if(USBFS_1_EP2_ISR_REMOVE == 0u)

    /*******************************************************************************
    * Function Name: USBFS_1_EP_2_ISR
    ********************************************************************************
    *
    * Summary:
    *  Endpoint 2 Interrupt Service Routine
    *
    * Parameters:
    *  None.
    *
    * Return:
    *  None.
    *
    *******************************************************************************/
    CY_ISR(USBFS_1_EP_2_ISR)
    {
        /* `#START EP2_USER_CODE` Place your code here */

        /* `#END` */

        CY_GET_REG8(USBFS_1_SIE_EP2_CR0_PTR); /* Must read the mode reg */
        USBFS_1_EP[USBFS_1_EP2].epToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
        USBFS_1_EP[USBFS_1_EP2].apiEpState = USBFS_1_EVENT_PENDING;
        CY_SET_REG8(USBFS_1_SIE_EP_INT_SR_PTR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR_PTR) \
                                                                        & ~USBFS_1_SIE_EP_INT_EP2_MASK);

        /* PSoC3 ES1, ES2 RTC ISR PATCH  */
        #if(USBFS_1_PSOC3_ES2 && (USBFS_1_ep_2__ES2_PATCH))
            USBFS_1_ISR_PATCH();
        #endif /* End USBFS_1_PSOC3_ES2*/
    }

#endif   /* End USBFS_1_EP2_ISR_REMOVE */


#if(USBFS_1_EP3_ISR_REMOVE == 0u)

    /*******************************************************************************
    * Function Name: USBFS_1_EP_3_ISR
    ********************************************************************************
    *
    * Summary:
    *  Endpoint 3 Interrupt Service Routine
    *
    * Parameters:
    *  None.
    *
    * Return:
    *  None.
    *
    *******************************************************************************/
    CY_ISR(USBFS_1_EP_3_ISR)
    {
        /* `#START EP3_USER_CODE` Place your code here */

        /* `#END` */

        CY_GET_REG8(USBFS_1_SIE_EP3_CR0_PTR); /* Must read the mode reg */
        USBFS_1_EP[USBFS_1_EP3].epToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
        USBFS_1_EP[USBFS_1_EP3].apiEpState = USBFS_1_EVENT_PENDING;
        CY_SET_REG8(USBFS_1_SIE_EP_INT_SR_PTR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR_PTR) \
                                                                        & ~USBFS_1_SIE_EP_INT_EP3_MASK);

        /* PSoC3 ES1, ES2 RTC ISR PATCH  */
        #if(USBFS_1_PSOC3_ES2 && (USBFS_1_ep_3__ES2_PATCH))
            USBFS_1_ISR_PATCH();
        #endif /* End USBFS_1_PSOC3_ES2*/
    }

#endif   /* End USBFS_1_EP3_ISR_REMOVE */


#if(USBFS_1_EP4_ISR_REMOVE == 0u)

    /*******************************************************************************
    * Function Name: USBFS_1_EP_4_ISR
    ********************************************************************************
    *
    * Summary:
    *  Endpoint 4 Interrupt Service Routine
    *
    * Parameters:
    *  None.
    *
    * Return:
    *  None.
    *
    *******************************************************************************/
    CY_ISR(USBFS_1_EP_4_ISR)
    {
        /* `#START EP4_USER_CODE` Place your code here */

        /* `#END` */

        CY_GET_REG8(USBFS_1_SIE_EP4_CR0_PTR); /* Must read the mode reg */
        USBFS_1_EP[USBFS_1_EP4].epToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
        USBFS_1_EP[USBFS_1_EP4].apiEpState = USBFS_1_EVENT_PENDING;
        CY_SET_REG8(USBFS_1_SIE_EP_INT_SR_PTR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR_PTR) \
                                                                        & ~USBFS_1_SIE_EP_INT_EP4_MASK);

        /* PSoC3 ES1, ES2 RTC ISR PATCH  */
        #if(USBFS_1_PSOC3_ES2 && (USBFS_1_ep_4__ES2_PATCH))
            USBFS_1_ISR_PATCH();
        #endif /* End USBFS_1_PSOC3_ES2*/
    }

#endif   /* End USBFS_1_EP4_ISR_REMOVE */


#if(USBFS_1_EP5_ISR_REMOVE == 0u)

    /*******************************************************************************
    * Function Name: USBFS_1_EP_5_ISR
    ********************************************************************************
    *
    * Summary:
    *  Endpoint 5 Interrupt Service Routine
    *
    * Parameters:
    *  None.
    *
    * Return:
    *  None.
    *
    *******************************************************************************/
    CY_ISR(USBFS_1_EP_5_ISR)
    {
        /* `#START EP5_USER_CODE` Place your code here */

        /* `#END` */

        CY_GET_REG8(USBFS_1_SIE_EP5_CR0_PTR); /* Must read the mode reg */
        USBFS_1_EP[USBFS_1_EP5].epToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
        USBFS_1_EP[USBFS_1_EP5].apiEpState = USBFS_1_EVENT_PENDING;
        CY_SET_REG8(USBFS_1_SIE_EP_INT_SR_PTR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR_PTR) \
                                                                        & ~USBFS_1_SIE_EP_INT_EP5_MASK);

        /* PSoC3 ES1, ES2 RTC ISR PATCH  */
        #if(USBFS_1_PSOC3_ES2 && (USBFS_1_ep_5__ES2_PATCH))
            USBFS_1_ISR_PATCH();
        #endif /* End USBFS_1_PSOC3_ES2*/
    }
#endif   /* End USBFS_1_EP5_ISR_REMOVE */


#if(USBFS_1_EP6_ISR_REMOVE == 0u)

    /*******************************************************************************
    * Function Name: USBFS_1_EP_6_ISR
    ********************************************************************************
    *
    * Summary:
    *  Endpoint 6 Interrupt Service Routine
    *
    * Parameters:
    *  None.
    *
    * Return:
    *  None.
    *
    *******************************************************************************/
    CY_ISR(USBFS_1_EP_6_ISR)
    {
        /* `#START EP6_USER_CODE` Place your code here */

        /* `#END` */

        CY_GET_REG8(USBFS_1_SIE_EP6_CR0_PTR); /* Must read the mode reg */
        USBFS_1_EP[USBFS_1_EP6].epToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
        USBFS_1_EP[USBFS_1_EP6].apiEpState = USBFS_1_EVENT_PENDING;
        CY_SET_REG8(USBFS_1_SIE_EP_INT_SR_PTR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR_PTR) \
                                                                        & ~USBFS_1_SIE_EP_INT_EP6_MASK);

        /* PSoC3 ES1, ES2 RTC ISR PATCH  */
        #if(USBFS_1_PSOC3_ES2 && (USBFS_1_ep_6__ES2_PATCH))
            USBFS_1_ISR_PATCH();
        #endif /* End USBFS_1_PSOC3_ES2*/
    }

#endif   /* End USBFS_1_EP6_ISR_REMOVE */


#if(USBFS_1_EP7_ISR_REMOVE == 0u)

    /*******************************************************************************
    * Function Name: USBFS_1_EP_7_ISR
    ********************************************************************************
    *
    * Summary:
    *  Endpoint 7 Interrupt Service Routine
    *
    * Parameters:
    *  None.
    *
    * Return:
    *  None.
    *
    *******************************************************************************/
    CY_ISR(USBFS_1_EP_7_ISR)
    {
        /* `#START EP7_USER_CODE` Place your code here */

        /* `#END` */

        CY_GET_REG8(USBFS_1_SIE_EP7_CR0_PTR); /* Must read the mode reg */
        USBFS_1_EP[USBFS_1_EP7].epToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
        USBFS_1_EP[USBFS_1_EP7].apiEpState = USBFS_1_EVENT_PENDING;
        CY_SET_REG8(USBFS_1_SIE_EP_INT_SR_PTR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR_PTR) \
                                                                        & ~USBFS_1_SIE_EP_INT_EP7_MASK);

        /* PSoC3 ES1, ES2 RTC ISR PATCH  */
        #if(USBFS_1_PSOC3_ES2 && (USBFS_1_ep_7__ES2_PATCH))
            USBFS_1_ISR_PATCH();
        #endif /* End USBFS_1_PSOC3_ES2*/
    }

#endif   /* End USBFS_1_EP7_ISR_REMOVE */


#if(USBFS_1_EP8_ISR_REMOVE == 0u)

    /*******************************************************************************
    * Function Name: USBFS_1_EP_8_ISR
    ********************************************************************************
    *
    * Summary:
    *  Endpoint 8 Interrupt Service Routine
    *
    * Parameters:
    *  None.
    *
    * Return:
    *  None.
    *
    *******************************************************************************/
    CY_ISR(USBFS_1_EP_8_ISR)
    {
        /* `#START EP8_USER_CODE` Place your code here */

        /* `#END` */

        CY_GET_REG8(USBFS_1_SIE_EP8_CR0_PTR); /* Must read the mode reg */
        USBFS_1_EP[USBFS_1_EP8].epToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
        USBFS_1_EP[USBFS_1_EP8].apiEpState = USBFS_1_EVENT_PENDING;
        CY_SET_REG8(USBFS_1_SIE_EP_INT_SR_PTR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR_PTR) \
                                                                        & ~USBFS_1_SIE_EP_INT_EP8_MASK);

        /* PSoC3 ES1, ES2 RTC ISR PATCH  */
        #if(USBFS_1_PSOC3_ES2 && (USBFS_1_ep_8__ES2_PATCH))
            USBFS_1_ISR_PATCH();
        #endif /* End USBFS_1_PSOC3_ES2*/
    }

#endif   /* End USBFS_1_EP8_ISR_REMOVE */


/*******************************************************************************
* Function Name: USBFS_1_SOF_ISR
********************************************************************************
*
* Summary:
*  Start of Frame Interrupt Service Routine
*
* Parameters:
*  None.
*
* Return:
*  None.
*
*******************************************************************************/
CY_ISR(USBFS_1_SOF_ISR)
{
    /* `#START SOF_USER_CODE` Place your code here */

    /* `#END` */

    /* PSoC3 ES1, ES2 RTC ISR PATCH  */
    #if(USBFS_1_PSOC3_ES2 && (USBFS_1_sof_int__ES2_PATCH))
        USBFS_1_ISR_PATCH();
    #endif /* End USBFS_1_PSOC3_ES2*/
}


/*******************************************************************************
* Function Name: USBFS_1_BUS_RESET_ISR
********************************************************************************
*
* Summary:
*  USB Bus Reset Interrupt Service Routine.  Calls _Start with the same
*  parameters as the last USER call to _Start
*
* Parameters:
*  None.
*
* Return:
*  None.
*
*******************************************************************************/
CY_ISR(USBFS_1_BUS_RESET_ISR)
{
    /* `#START BUS_RESET_USER_CODE` Place your code here */

    /* `#END` */

    USBFS_1_ReInitComponent();

    /* PSoC3 ES1, ES2 RTC ISR PATCH  */
    #if(USBFS_1_PSOC3_ES2 && (USBFS_1_bus_reset__ES2_PATCH))
        USBFS_1_ISR_PATCH();
    #endif /* End USBFS_1_PSOC3_ES2*/
}


/* [] END OF FILE */
