/*******************************************************************************
* File Name: CAL_IN.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_CAL_IN_H) /* Pins CAL_IN_H */
#define CY_PINS_CAL_IN_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "CAL_IN_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    CAL_IN_Write(uint8 value) ;
void    CAL_IN_SetDriveMode(uint8 mode) ;
uint8   CAL_IN_ReadDataReg(void) ;
uint8   CAL_IN_Read(void) ;
uint8   CAL_IN_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define CAL_IN_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define CAL_IN_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define CAL_IN_DM_RES_UP          PIN_DM_RES_UP
#define CAL_IN_DM_RES_DWN         PIN_DM_RES_DWN
#define CAL_IN_DM_OD_LO           PIN_DM_OD_LO
#define CAL_IN_DM_OD_HI           PIN_DM_OD_HI
#define CAL_IN_DM_STRONG          PIN_DM_STRONG
#define CAL_IN_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define CAL_IN_MASK               CAL_IN__MASK
#define CAL_IN_SHIFT              CAL_IN__SHIFT
#define CAL_IN_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define CAL_IN_PS                     (* (reg8 *) CAL_IN__PS)
/* Data Register */
#define CAL_IN_DR                     (* (reg8 *) CAL_IN__DR)
/* Port Number */
#define CAL_IN_PRT_NUM                (* (reg8 *) CAL_IN__PRT) 
/* Connect to Analog Globals */                                                  
#define CAL_IN_AG                     (* (reg8 *) CAL_IN__AG)                       
/* Analog MUX bux enable */
#define CAL_IN_AMUX                   (* (reg8 *) CAL_IN__AMUX) 
/* Bidirectional Enable */                                                        
#define CAL_IN_BIE                    (* (reg8 *) CAL_IN__BIE)
/* Bit-mask for Aliased Register Access */
#define CAL_IN_BIT_MASK               (* (reg8 *) CAL_IN__BIT_MASK)
/* Bypass Enable */
#define CAL_IN_BYP                    (* (reg8 *) CAL_IN__BYP)
/* Port wide control signals */                                                   
#define CAL_IN_CTL                    (* (reg8 *) CAL_IN__CTL)
/* Drive Modes */
#define CAL_IN_DM0                    (* (reg8 *) CAL_IN__DM0) 
#define CAL_IN_DM1                    (* (reg8 *) CAL_IN__DM1)
#define CAL_IN_DM2                    (* (reg8 *) CAL_IN__DM2) 
/* Input Buffer Disable Override */
#define CAL_IN_INP_DIS                (* (reg8 *) CAL_IN__INP_DIS)
/* LCD Common or Segment Drive */
#define CAL_IN_LCD_COM_SEG            (* (reg8 *) CAL_IN__LCD_COM_SEG)
/* Enable Segment LCD */
#define CAL_IN_LCD_EN                 (* (reg8 *) CAL_IN__LCD_EN)
/* Slew Rate Control */
#define CAL_IN_SLW                    (* (reg8 *) CAL_IN__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define CAL_IN_PRTDSI__CAPS_SEL       (* (reg8 *) CAL_IN__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define CAL_IN_PRTDSI__DBL_SYNC_IN    (* (reg8 *) CAL_IN__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define CAL_IN_PRTDSI__OE_SEL0        (* (reg8 *) CAL_IN__PRTDSI__OE_SEL0) 
#define CAL_IN_PRTDSI__OE_SEL1        (* (reg8 *) CAL_IN__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define CAL_IN_PRTDSI__OUT_SEL0       (* (reg8 *) CAL_IN__PRTDSI__OUT_SEL0) 
#define CAL_IN_PRTDSI__OUT_SEL1       (* (reg8 *) CAL_IN__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define CAL_IN_PRTDSI__SYNC_OUT       (* (reg8 *) CAL_IN__PRTDSI__SYNC_OUT) 


#if defined(CAL_IN__INTSTAT)  /* Interrupt Registers */

    #define CAL_IN_INTSTAT                (* (reg8 *) CAL_IN__INTSTAT)
    #define CAL_IN_SNAP                   (* (reg8 *) CAL_IN__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins CAL_IN_H */


/* [] END OF FILE */
