/*******************************************************************************
* File Name: GRNLED.c  
* Version 1.50
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "cytypes.h"
#include "GRNLED.h"


/*******************************************************************************
* Function Name: GRNLED_Write
********************************************************************************
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  void 
*  
*******************************************************************************/
void GRNLED_Write(uint8 value) 
{
    uint8 staticBits = GRNLED_DR & ~GRNLED_MASK;
    GRNLED_DR = staticBits | ((value << GRNLED_SHIFT) & GRNLED_MASK);
}


/*******************************************************************************
* Function Name: GRNLED_SetDriveMode
********************************************************************************
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to this drive mode.
*
* Return: 
*  void
*
*******************************************************************************/
void GRNLED_SetDriveMode(uint8 mode) 
{
	CyPins_SetPinDriveMode(GRNLED_0, mode);
}


/*******************************************************************************
* Function Name: GRNLED_Read
********************************************************************************
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro GRNLED_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 GRNLED_Read(void) 
{
    return (GRNLED_PS & GRNLED_MASK) >> GRNLED_SHIFT;
}


/*******************************************************************************
* Function Name: GRNLED_ReadDataReg
********************************************************************************
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 GRNLED_ReadDataReg(void) 
{
    return (GRNLED_DR & GRNLED_MASK) >> GRNLED_SHIFT;
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(GRNLED_INTSTAT) 

    /*******************************************************************************
    * Function Name: GRNLED_ClearInterrupt
    ********************************************************************************
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  void 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 GRNLED_ClearInterrupt(void) 
    {
        return (GRNLED_INTSTAT & GRNLED_MASK) >> GRNLED_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */ 
