/*******************************************************************************
* File Name: IQCLK.h
* Version 1.50
*
*  Description:
*   Provides the function and constant definitions for the clock component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_CLOCK_IQCLK_H)
#define CY_CLOCK_IQCLK_H

#include <cytypes.h>
#include <cyfitter.h>


/***************************************
*        Function Prototypes
***************************************/

void IQCLK_Start(void) ;
void IQCLK_Stop(void) ;

#if(!(CYDEV_CHIP_FAMILY_USED == CYDEV_CHIP_FAMILY_PSOC3 && \
    CYDEV_CHIP_REVISION_USED == CYDEV_CHIP_REVISION_3A_ES2) && \
	!(CYDEV_CHIP_FAMILY_USED == CYDEV_CHIP_FAMILY_PSOC5 && \
	CYDEV_CHIP_REVISION_USED == CYDEV_CHIP_REVISION_5A_ES1))
void IQCLK_StopBlock(void) ;
#endif

void IQCLK_StandbyPower(uint8 state) ;
void IQCLK_SetDividerRegister(uint16 clkDivider, uint8 reset) ;
uint16 IQCLK_GetDividerRegister(void) ;
void IQCLK_SetModeRegister(uint8 modeBitMask) ;
void IQCLK_ClearModeRegister(uint8 modeBitMask) ;
uint8 IQCLK_GetModeRegister(void) ;
void IQCLK_SetSourceRegister(uint8 clkSource) ;
uint8 IQCLK_GetSourceRegister(void) ;
#if defined(IQCLK__CFG3)
void IQCLK_SetPhaseRegister(uint8 clkPhase) ;
uint8 IQCLK_GetPhaseRegister(void) ;
#endif

#define IQCLK_Enable()                       IQCLK_Start()
#define IQCLK_Disable()                      IQCLK_Stop()
#define IQCLK_SetDivider(clkDivider)         IQCLK_SetDividerRegister(clkDivider, 1)
#define IQCLK_SetDividerValue(clkDivider)    IQCLK_SetDividerRegister((clkDivider) - 1, 1)
#define IQCLK_SetMode(clkMode)               IQCLK_SetModeRegister(clkMode)
#define IQCLK_SetSource(clkSource)           IQCLK_SetSourceRegister(clkSource)
#if defined(IQCLK__CFG3)
#define IQCLK_SetPhase(clkPhase)             IQCLK_SetPhaseRegister(clkPhase)
#define IQCLK_SetPhaseValue(clkPhase)        IQCLK_SetPhaseRegister((clkPhase) + 1)
#endif


/***************************************
*           API Constants
***************************************/

/* Constants SetPhase(), clkPhase parameter. Only valid for PSoC 3 ES2 and earlier. See datasheet for details. */
#if CYDEV_CHIP_FAMILY_USED == CYDEV_CHIP_FAMILY_PSOC3 && \
   (CYDEV_CHIP_REVISION_USED == CYDEV_CHIP_REVISION_3A_ES1 || \
    CYDEV_CHIP_REVISION_USED == CYDEV_CHIP_REVISION_3A_ES2)
#define CYCLK_2_5NS             0x01 /* 2.5 ns delay. */
#define CYCLK_3_5NS             0x02 /* 3.5 ns delay. */
#define CYCLK_4_5NS             0x03 /* 4.5 ns delay. */
#define CYCLK_5_5NS             0x04 /* 5.5 ns delay. */
#define CYCLK_6_5NS             0x05 /* 6.5 ns delay. */
#define CYCLK_7_5NS             0x06 /* 7.5 ns delay. */
#define CYCLK_8_5NS             0x07 /* 8.5 ns delay. */
#define CYCLK_9_5NS             0x08 /* 9.5 ns delay. */
#define CYCLK_10_5NS            0x09 /* 10.5 ns delay. */
#define CYCLK_11_5NS            0x0A /* 11.5 ns delay. */
#define CYCLK_12_5NS            0x0B /* 12.5 ns delay. */
#endif


/***************************************
*             Registers
***************************************/

/* Register to enable or disable the clock */
#define IQCLK_CLKEN              (* (reg8 *) IQCLK__PM_ACT_CFG)
#define IQCLK_CLKEN_PTR          ((reg8 *) IQCLK__PM_ACT_CFG)

/* Register to enable or disable the clock */
#define IQCLK_CLKSTBY            (* (reg8 *) IQCLK__PM_STBY_CFG)
#define IQCLK_CLKSTBY_PTR        ((reg8 *) IQCLK__PM_STBY_CFG)

/* Clock LSB divider configuration register. */
#define IQCLK_DIV_LSB            (* (reg8 *) IQCLK__CFG0)
#define IQCLK_DIV_LSB_PTR        ((reg8 *) IQCLK__CFG0)
#define IQCLK_DIV_PTR            ((reg16 *) IQCLK__CFG0)

/* Clock MSB divider configuration register. */
#define IQCLK_DIV_MSB            (* (reg8 *) IQCLK__CFG1)
#define IQCLK_DIV_MSB_PTR        ((reg8 *) IQCLK__CFG1)

/* Mode and source configuration register */
#define IQCLK_MOD_SRC            (* (reg8 *) IQCLK__CFG2)
#define IQCLK_MOD_SRC_PTR        ((reg8 *) IQCLK__CFG2)

#if defined(IQCLK__CFG3)
/* Analog clock phase configuration register */
#define IQCLK_PHASE              (* (reg8 *) IQCLK__CFG3)
#define IQCLK_PHASE_PTR          ((reg8 *) IQCLK__CFG3)
#endif


/**************************************
*       Register Constants
**************************************/

/* Power manager register masks */
#define IQCLK_CLKEN_MASK         IQCLK__PM_ACT_MSK
#define IQCLK_CLKSTBY_MASK       IQCLK__PM_STBY_MSK

/* CFG2 field masks */
#define IQCLK_SRC_SEL_MSK        IQCLK__CFG2_SRC_SEL_MASK
#define IQCLK_MODE_MASK          (~(IQCLK_SRC_SEL_MSK))

#if defined(IQCLK__CFG3)
/* CFG3 phase mask */
#define IQCLK_PHASE_MASK         IQCLK__CFG3_PHASE_DLY_MASK
#endif

#endif /* CY_CLOCK_IQCLK_H */


/* [] END OF FILE */
