/*******************************************************************************
* File Name: TP_DEBUG.c  
* Version 1.50
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "cytypes.h"
#include "TP_DEBUG.h"


/*******************************************************************************
* Function Name: TP_DEBUG_Write
********************************************************************************
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  void 
*  
*******************************************************************************/
void TP_DEBUG_Write(uint8 value) 
{
    uint8 staticBits = TP_DEBUG_DR & ~TP_DEBUG_MASK;
    TP_DEBUG_DR = staticBits | ((value << TP_DEBUG_SHIFT) & TP_DEBUG_MASK);
}


/*******************************************************************************
* Function Name: TP_DEBUG_SetDriveMode
********************************************************************************
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to this drive mode.
*
* Return: 
*  void
*
*******************************************************************************/
void TP_DEBUG_SetDriveMode(uint8 mode) 
{
	CyPins_SetPinDriveMode(TP_DEBUG_0, mode);
}


/*******************************************************************************
* Function Name: TP_DEBUG_Read
********************************************************************************
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro TP_DEBUG_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 TP_DEBUG_Read(void) 
{
    return (TP_DEBUG_PS & TP_DEBUG_MASK) >> TP_DEBUG_SHIFT;
}


/*******************************************************************************
* Function Name: TP_DEBUG_ReadDataReg
********************************************************************************
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 TP_DEBUG_ReadDataReg(void) 
{
    return (TP_DEBUG_DR & TP_DEBUG_MASK) >> TP_DEBUG_SHIFT;
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(TP_DEBUG_INTSTAT) 

    /*******************************************************************************
    * Function Name: TP_DEBUG_ClearInterrupt
    ********************************************************************************
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  void 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 TP_DEBUG_ClearInterrupt(void) 
    {
        return (TP_DEBUG_INTSTAT & TP_DEBUG_MASK) >> TP_DEBUG_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */ 
