/*******************************************************************************
* File Name: UART_TXInternalInterrupt_intc.c  
* Version 1.0
*
*  Description:
*   API for controlling the state of an interrupt.
*
*
*  Note:
*
********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/


#include <CYDEVICE.H>
#include <UART_TXInternalInterrupt.H>


/*******************************************************************************
*  Place your includes, defines and code here 
********************************************************************************/
/* `#START UART_TXInternalInterrupt_intc` */

/* `#END` */


/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_Start
********************************************************************************
* Summary:
*  Set up the interrupt and enable it.
*
* Parameters:  
*   void.
*
*
* Return:
*   void.
*
*******************************************************************************/
void UART_TXInternalInterrupt_Start(void)
{
    /* For all we know the interrupt is active. */
    UART_TXInternalInterrupt_Disable();

    /* Set the ISR to point to the UART_TXInternalInterrupt Interrupt. */
    UART_TXInternalInterrupt_SetVector(UART_TXInternalInterrupt_Interrupt);

    /* Set the priority. */
    UART_TXInternalInterrupt_SetPriority(UART_TXInternalInterrupt_INTC_PRIOR_NUMBER);

    /* Enable it. */
    UART_TXInternalInterrupt_Enable();
}

/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_Stop
********************************************************************************
* Summary:
*   Disables and removes the interrupt.
*
* Parameters:  
*
*
* Return:
*   void.
*
*******************************************************************************/
void UART_TXInternalInterrupt_Stop(void)
{
    /* Disable this interrupt. */
    UART_TXInternalInterrupt_Disable();

    /* Set the ISR to point to the passive one. */
//    UART_TXInternalInterrupt_SetVector(CyDefaultInterrupt);
}

/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_Interrupt
********************************************************************************
* Summary:
*   The default Interrupt Service Routine for UART_TXInternalInterrupt.
*
*   Add custom code between the coments to keep the next version of this file
*   from over writting your code.
*
*
*
* Parameters:  
*
*
* Return:
*   void.
*
*******************************************************************************/
CY_ISR(UART_TXInternalInterrupt_Interrupt)
{
    /*  Place your Interrupt code here. */
    /* `#START UART_TXInternalInterrupt_Interrupt` */

    /* `#END` */
}


/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_SetVector
********************************************************************************
* Summary:
*   Change the ISR vector for the Interrupt.
*
*
* Parameters:
*   address: Address of the ISR to set in the interrupt vector table.
*
*
* Return:
*   void.
*
*
*******************************************************************************/
void UART_TXInternalInterrupt_SetVector(cyisraddress address)
{
    CY_SET_REG16(UART_TXInternalInterrupt_INTC_VECTOR, (uint16) address);
}

/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_GetVector
********************************************************************************
* Summary:
*   Gets the "address" of the current ISR vector for the Interrupt.
*
*
* Parameters:
*   void.
*
*
* Return:
*   Address of the ISR in the interrupt vector table.
*
*
*******************************************************************************/
cyisraddress UART_TXInternalInterrupt_GetVector(void)
{
    return (cyisraddress) CY_GET_REG16(UART_TXInternalInterrupt_INTC_VECTOR);
}

/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_SetPriority
********************************************************************************
* Summary:
*   Sets the Priority of the Interrupt.
*
*
* Parameters:
*   priority: Priority of the interrupt. 0 - 7, 0 being the highest.
*
*
* Return:
*   void.
*
*
*******************************************************************************/
void UART_TXInternalInterrupt_SetPriority(uint8 priority)
{
    *UART_TXInternalInterrupt_INTC_PRIOR = priority << 5;
}

/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_GetPriority
********************************************************************************
* Summary:
*   Gets the Priority of the Interrupt.
*
*
* Parameters:
*   void.
*
*
* Return:
*   Priority of the interrupt. 0 - 7, 0 being the highest.
*
*
*******************************************************************************/
uint8 UART_TXInternalInterrupt_GetPriority(void)
{
    uint8 priority;


    priority = *UART_TXInternalInterrupt_INTC_PRIOR >> 5;

    return priority;
}

/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_Enable
********************************************************************************
* Summary:
*   Enables the interrupt.
*
*
* Parameters:
*   void.
*
*
* Return:
*   void.
*
*
*******************************************************************************/
void UART_TXInternalInterrupt_Enable(void)
{
    /* Enable the general interrupt. */
    *UART_TXInternalInterrupt_INTC_SET_EN = UART_TXInternalInterrupt__INTC_MASK;
}

/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_GetState
********************************************************************************
* Summary:
*   Gets the state (enabled, disabled) of the Interrupt.
*
*
* Parameters:
*   void.
*
*
* Return:
*   1 if enabled, 0 if disabled.
*
*
*******************************************************************************/
uint8 UART_TXInternalInterrupt_GetState(void)
{
    /* Get the state of the general interrupt. */
    return (*UART_TXInternalInterrupt_INTC_SET_EN & UART_TXInternalInterrupt__INTC_MASK) ? 1:0;
}

/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_Disable
********************************************************************************
* Summary:
*   Disables the Interrupt.
*
*
* Parameters:
*   void.
*
*
* Return:
*   void.
*
*
*******************************************************************************/
void UART_TXInternalInterrupt_Disable(void)
{
    /* Disable the general interrupt. */
    *UART_TXInternalInterrupt_INTC_CLR_EN = UART_TXInternalInterrupt__INTC_MASK;
}

/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_SetPending
********************************************************************************
* Summary:
*   Causes the Interrupt to enter the pending state, a software method of
*   generating the interrupt.
*
*
* Parameters:
*   void.
*
*
* Return:
*   void.
*
*
*******************************************************************************/
void UART_TXInternalInterrupt_SetPending(void)
{
    *UART_TXInternalInterrupt_INTC_SET_PD = UART_TXInternalInterrupt__INTC_MASK;
}

/*******************************************************************************
* Function Name: UART_TXInternalInterrupt_ClearPending
********************************************************************************
* Summary:
*   Clears a pending interrupt.
*
* Parameters:
*   void.
*
*
* Return:
*   void.
*
*
*******************************************************************************/
void UART_TXInternalInterrupt_ClearPending(void)
{
    *UART_TXInternalInterrupt_INTC_CLR_PD = UART_TXInternalInterrupt__INTC_MASK;
}


















































