/* MXCOM.H -- header file for use with MX-COM MX709 codec board
 *
 * Used with Turbo C V2.0
 *
 * Copyright 1990, American Radio Relay League, Inc. */

/* Hardware definitions */

#define MX_A	MXBASE
#define MX_B	MXBASE+1
#define MX_DEC	MXBASE+2
#define MX_STAT	MXBASE
#define MX_PWR	MXBASE+1
#define MX_ENC	MXBASE+2

/* Software definitions for mxcom.lib */

#define IDLE 	0
#define CHANA 	1
#define CHANB	2
#define DECODER	0
#define ENCODER	1
#define THROUGH	1
#define LOW		0
#define HIGH	1

struct mxbuf
{
	char *dat;
	unsigned n;
};

extern unsigned mxecnt;		/* Encoder byte count */
extern unsigned mxdcnt;		/* Decoder byte count */
extern unsigned mxeover;	/* Encoder overspill count */
extern unsigned mxdover;	/* Decoder overspill count */

void mxcard(unsigned base, char irq);
void mxinit(char dsource, char esource, char aout, char bout, char rate,
	char pagesize, char sens);
void mxreset(void);
void mx_encode(struct mxbuf *buf1, struct mxbuf *buf2, char *eobflag);
void mx_decode(struct mxbuf *buf1, struct mxbuf *buf2, char *eobflag);
void mxstop(char side);

extern unsigned int MXBASE;
