/* MX-COM MX709 CODEC board test program (interrupt version) */

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <bios.h>
#include <ctype.h>
#include <dos.h>

#include "mxcom.h"

#define IRQ		5

char *
prompt(char *pmt)
{
	static char reply[120];

	printf("%s", pmt);
	gets(reply);
	return reply;
}

static int over = 0;
static char *buf;
static unsigned n;
static int cnt;
static long intc;

void interrupt
service()
{
	unsigned char stat;

	intc++;
	stat = inportb(MX_STAT);
	if (cnt < n && (stat & 0x12))
		outportb(MX_DEC, buf[cnt++]);
	if (stat & 0x10)
		over++;
	stat = inportb(MX_STAT);
	if (stat & 9)
		inportb(MX_ENC);
	if (stat & 0x24)
		inportb(MX_PWR);
	outportb(0x20, 0x20);
}

int
main()
{
	char *p;
	FILE *fil;
	int i, pgm;
	void interrupt (*oldv)();

	while (1)
	{
		p = prompt("File to play: ");
		if ((fil = fopen(p, "rb")) == NULL)
		{
			perror(p);
			continue;
		}
		if (fseek(fil, 0L, SEEK_END))
		{
			perror(p);
			continue;
		}
		n = (int) ftell(fil) - sizeof pgm;
		if ((buf = malloc(n)) == NULL)
		{
			puts("Insufficient memory");
			fclose(fil);
			continue;
		}
		fseek(fil, 0L, SEEK_SET);
		fread(&pgm, sizeof i, 1, fil);
		if (pgm == -1)
		{
			puts("CODEC programming bits not available");
			pgm = 0;
		}
		if (fread(buf, 1, n, fil) != n)
		{
			perror(p);
			free(buf);
			fclose(fil);
			continue;
		}
		fclose(fil);
		printf("%u bytes loaded.\n", n);
		while (1)
		{
			puts("Hit any key to play, ESC to reload...");
			if ((bioskey(0) & 0xff) == 0x1b)
				break;
			outportb(MX_A, pgm+3);
			outportb(MX_B, 0x38);
			cnt = 0;
			over = 0;
			inportb(MX_STAT);
			oldv = getvect(IRQ+8);
			setvect(IRQ+8, service);
			disable();
			outportb(0x21, inportb(0x21) & ~(1 << IRQ));
			outportb(0x20, 0x20);
			enable();
			outportb(MX_ENC, buf[cnt++]);
			while (cnt < n && (bioskey(1) & 0xff) != 0x1b)
				;
			disable();
			outportb(0x21, inportb(0x21) | (1 << IRQ));
			enable();
			setvect(IRQ+8, oldv);
			if (bioskey(1) != 0)
				bioskey(0);
			printf("%ld interrupts, %d decode overspills\n", intc, over);
		}
	}
}