/* MX-COM MX709 CODEC board test program */

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <bios.h>
#include <ctype.h>
#include <dos.h>

#include "mxcom.h"

char *
prompt(char *pmt)
{
	static char reply[120];

	printf("%s", pmt);
	gets(reply);
	return reply;
}

void
usage(void)
{
	puts("MXTEST -- Tests KE3Z MXCOM CODEC card");
	puts("Usage mxtest [-v]");
	puts("      -v = use vox");
	exit(0);
}

int
main(int argc, char *argv[])
{
	char *buf, *p;
	int i, stat, pgm;
	unsigned n;
	FILE *fil;
	int over;
	char vox = 0;

	for (i = 1; i < argc; i++)
	{
		if (argv[i][0] != '-')
			usage();
		switch (toupper(argv[i][1]))
		{
		case 'V':
			vox = 1;
			break;
		default:
			usage();
		}
	}
	while (1)
	{
		p = prompt("CODEC Programming bits (0-7) or P to measure power: ");
		if (*p == 'P' || *p == 'p')
		{
			i = atoi(prompt("Page size (0-7): ")) & 7;
			outportb(MX_B, i | 8);
			over = 0;
			while (1)
			{
				if ((i = bioskey(1)) != 0)
					if ((i & 0xff) == 0x1b)
						break;
				if ((i = (inportb(MX_STAT) & 0x24)) != 0)
				{
					if (i & 0x20)
						over++;
					i = inportb(MX_PWR);
					printf("(%02X)", i);
				}
			}
			bioskey(0);
			printf("\n%d page overspills\n", over);
			continue;
		}
		i = atoi(p) & 7;
		pgm = (i << 5) | (i << 2);
		n = atoi(prompt("# samples: "));
		if (n == 0)
		{
			p = prompt("File to load: ");
			if (*p == 0)
				continue;
			if ((fil = fopen(p, "rb")) == NULL)
			{
				perror(p);
				continue;
			}
			if (fseek(fil, 0L, SEEK_END))
			{
				perror(p);
				continue;
			}
			n = (int) ftell(fil) - sizeof pgm;
			if ((buf = malloc(n)) == NULL)
			{
				puts("Insufficient memory");
				fclose(fil);
				continue;
			}
			fseek(fil, 0L, SEEK_SET);
			fread(&i, sizeof i, 1, fil);
			if (i != -1)
				pgm = i;
			if (fread(buf, 1, n, fil) != n)
			{
				perror(p);
				fclose(fil);
				continue;
			}
			printf("%u bytes loaded, CODEC programming=%d\n", n, pgm >> 5);
			fclose(fil);
		} else if ((buf = malloc(n)) == NULL)
		{
			puts("Insufficient memory");
			continue;
		} else
		{
			outportb(MX_B, 0x3a);
			outportb(MX_A, pgm + 2);
			if (vox)
			{
				while ((inportb(MX_PWR) & 0xf) < 3)
					if ((bioskey(1) & 0xff) == 0x1b)
					{
						bioskey(0);
						outportb(MX_B, 0);
						free(buf);
						continue;
					}
			} else
			{
				puts("Press any key to start recording...");
				if ((bioskey(0) & 0xff) == 0x1b)
				{
					outportb(MX_B, 0);
					free(buf);
					continue;
				}
			}
			puts("Recording.");
			p = buf;
			*p++ = inportb(MX_ENC);
			i = n - 1;
			while (i > 0)
			{
				stat = inportb(MX_STAT);
				if (stat & 8)
				{
					printf("Encode overspill after %d bytes\n", n-i);
					break;
				} else if (stat & 1)
				{
					*p++ = inportb(MX_ENC);
					i--;
				}
			}
			if (stat & 8)
			{
				free(buf);
				continue;
			}
			printf("%u bytes received\n", n);
		}
		while (1)
		{
			puts("Hit any key to play back, S to save, ESC to record...");
			if ((i = (bioskey(0) & 0xff)) == 0x1b)
				break;
			if (i == 'S' || i == 's')
			{
				p = prompt("File name: ");
				if (*p == 0)
					continue;
				if ((fil = fopen(p, "wb")) == NULL)
				{
					perror(p);
					continue;
				}
				fwrite(&pgm, sizeof pgm, 1, fil);
				if (fwrite(buf, 1, n, fil) != n)
					perror(p);
				fclose(fil);
				continue;
			}
			outportb(MX_A, pgm + 2);
			outportb(MX_B, 0x38);
			p = buf;
			over = 0;
			outportb(MX_DEC, *p++);
			i = n - 1;
			while (i > 0)
			{
				stat = inportb(MX_STAT);
				if (stat & 0x12)
				{
					if (stat & 0x10)
						over++;
					outportb(MX_DEC, *p++);
					i--;
				}
			}
			outportb(MX_B, 0);
			printf("%d decode overspills\n", over);
		}
		free(buf);
		outportb(MX_A, 0);
		outportb(MX_B, 0);
	}
}