{----------------------------------------------------------------------------}
{            PSA HF modem software for the Nov 1994 QEX article	             }
{             "An Adaptive HF DSP Modem for 100 and 200 Baud"                }
{                 (c) 1994, Johan Forrer, KC7WW                              }
{		       26553 Priceview Drive				     }
{                      Monroe, OR 97456			                     }
{                   							     }
{----------------------------------------------------------------------------}
{									     }
{                        Assembly instructions:  			     }
{                                                   			     }
{                         >SpAsm21 modem.dsp				     }
{									     }
{----------------------------------------------------------------------------}
{									     }
{                   Some useful PSA hardware addresses			     }
{									     }
{----------------------------------------------------------------------------}

.const PSS_data_reg	=0x3000;
.const PSS_control_reg	=0x3008;
.const PSS_status_reg	=0x3008;
.const PSS_dma_reg	=0x3010;
.const ram_bank_reg	=0x3018;
.const ext_mem_latch	=0x3020;
.const PSS_PIO_reg	=0x31C8;

.const addr_1848	=0x3440;
.const data_1848	=0x3448;
.const stat_1848	=0x3450;
.const pio_1848		=0x3458;
.const IRQ_status	=0x31C0;
.const dmal_1848	=0x3060;
.const dmar_1848	=0x3068;
.const enable_1848	=0x3070;

.const system_control	=0x3FFF;
.const wait_state_ctl	=0x3FFE;
.const timer_period	=0x3FFD;
.const timer_counter	=0x3FFC;
.const timer_prescale	=0x3FFB;

{----------------------------------------------------------------------------}
{									     }
{                     User's application storage		             }
{									     }
{----------------------------------------------------------------------------}

.const bpf_out		=0x3800;		{ Input BPF output           }
.const data_out		=0x3801;  		{ Data  LPF output           }
.const mark_out		=0x3802;		{ Mark  BPF output           }
.const space_out	=0x3803;		{ Space BPF output           }

.const mps 		=0x3804;		{ sine's sign 		     }
.const tph		=0x3805;		{ phase accumulator          }
.const wkph		=0x3806;		{ phase accumulator (temp)   }
.const sinx		=0x3807;		{ result of table lookup     }
.const sigout		=0x3808;		{ D/A value for output       }
.const databit		=0x3809;		{ Tone generator state       } 
.const timing_val	=0x380A;		{ Timer constant             }
.const dither		=0x380B;		{ use timer dither or not    }
.const modem_select     =0x380C;		{ select 100/200 modem       }

{----------------------------------------------------------------------------}
{									     }
{                     User's circular buffer storage		             }
{									     }
{----------------------------------------------------------------------------}
{                       9- 16 requires a " 16=0x0010" boundary               }
{               length 17- 32 requires a " 32=0x0020" boundary               }
{                      33- 64 requires a " 64=0x0040" boundary               }
{                      65-128 requires a "128=0x0080" boundary               }
{----------------------------------------------------------------------------}
 
.const DATALP		=0x3820;	{ 3820 -> 383F Data low pass         }
.const FILTER		=0x3840;	{ 3880 -> 38CF Filter delay line     } 
.const BPFI		=0x3920;	{ 3920 -> 393F Input bandpass 	     }


{=================  USER DSP APPLICATION CODE  ==============================}
{------------------ Interrupt service routine -------------------------------}
0x0100  sound_prt:
	ena sec_reg;			{ use alternate registers            }
	
{ The way we have the audio jack connected, only the left channel will       }
{ carry a signal. Input data is save in a circular buffer.                   }

	ax1=dm(sigout);			{ pick up AFSK out/input signal      }
	dm(dmal_1848)=ax1;
	dm(dmar_1848)=ax1;		{ this also resets interrupt         }

	ar=dm(dmal_1848);		{ using only left input channel      }
	dm(i1,m1)=ar;
	ar=dm(dmar_1848);		{ read right input but discard it    }

{------------------ Check which modem is in effect --------------------------}

	ax0=dm(modem_select);
	ay0=0x0000;			{ 0000 ==> 100 baud                  }
	ar=ax0 xor ay0;
	if eq jump filt100;

{------------------- 200 baud modem -----------------------------------------}
	call bpf_in2;			{ do input bandpass                  }
	ar=dm(bpf_out);
	dm(i2,m1)=ar;

	call mark_filter2;		{ do 200 baud mark                   }
	call space_filter2;		{ do 200 baud space                  }

	ax0=dm(mark_out);		{ subtract channels                  }
	ay0=dm(space_out);
	ar=ax0 - ay0;
	dm(i3,m1)=ar;
	call data_lp2;			{ do 200 baud data low pass          }
	jump modulate;

{------------------- 100 baud modem -----------------------------------------}
filt100:						 
	call bpf_in1;			{ do input bandpass                  }
	ar=dm(bpf_out);
	dm(i2,m1)=ar;

	call mark_filter1;		{ do 100 baud mark                   }
	call space_filter1;		{ do 100 baud space                  }

	ax0=dm(mark_out);		{ subtract channels                  }
	ay0=dm(space_out);
	ar=ax0 - ay0;
	dm(i3,m1)=ar;
	call data_lp1;			{ do 100 baud data low pass          }

{-------------- Check whether AFSK is needed --------------------------------}
modulate:	
	ax0=dm(databit);
	ay0=0x0000;			{ 0000 ==> no AFSK                   }
	ar=ax0 xor ay0;
	if eq jump no_afsk;

	call afsk;			{ do AFSK synthesis                  }
					{ NOTE: output is scaled >> 4        }
	jump rti_exit;
no_afsk:
	ar=dm(bpf_out);
	dm(sigout)=ar;
	dm(tph)=ay0;			{ zero out the phase initially       }

rti_exit:
	dis sec_reg;			{ restore normal registers           }
	rti;

{----------------------------------------------------------------------------}
{              Input bandpass filter for 200 baud	      		     }
{                         Fs=5512.5                                          }
{               Fcl=2030, Fch=2390     (BWpb=360)		             }
{              Fstl=1805,  Fsth=2615   (BWsb=810)   			     }
{									     }
{              FINITE IMPULSE RESPONSE (FIR)				     }					     
{            LINEAR PHASE DIGITAL FILTER DESIGN				     }					     
{                REMEZ EXCHANGE ALGORITHM	                             }
{	                                                                     }
{             FILTER LENGTH =  32, delay = 2.9ms	                     }                
{	                                                                     }
{              ***** IMPULSE RESPONSE *****	                             }
{         H( 1) =    -278.439 = H( 32)	     				     }
{         H( 2) =    -149.066 = H( 31)	     				     }
{         H( 3) =     157.169 = H( 30)	     				     }
{         H( 4) =     -54.794 = H( 29)	     				     }
{         H( 5) =    -115.210 = H( 28)	     				     }
{         H( 6) =     103.357 = H( 27)	     				     }
{         H( 7) =     373.048 = H( 26)	     				     }
{         H( 8) =   -1314.999 = H( 25)	     				     }
{         H( 9) =    2242.769 = H( 24)	     				     }
{         H(10) =   -2358.994 = H( 23)	     				     }
{         H(11) =    1064.553 = H( 22)	     				     }
{         H(12) =    1491.543 = H( 21)	     				     }
{         H(13) =   -4262.201 = H( 20)	     				     }
{         H(14) =    5769.721 = H( 19)	     				     }
{         H(15) =   -4966.988 = H( 18)	     				     }
{         H(16) =    1957.288 = H( 17)	     				     }
{	                                     				     }
{                       BAND  1       BAND  2       BAND  3     	     }
{ LOWER BAND EDGE      .0000000      .3682540      .4743760     	     }
{ UPPER BAND EDGE      .3274376      .4335600      .5000000     	     }
{ DESIRED VALUE        .0000000     1.0000000      .0000000     	     }
{ WEIGHTING          10.0000000     1.0000000    10.0000000     	     }
{ DEVIATION            .0208284      .2082838      .0208284     	     }
{ DEVIATION IN DB   -33.6268900     1.6433790   -33.6268900     	     }
{----------------------------------------------------------------------------}
dc:  0xFEEA00; { -278.438995 }
     0xFF6B00; { -149.065994 }
     0x009D00; {  157.169006 }
     0xFFC900; {  -54.793999 }
     0xFF8D00; { -115.209999 }
     0x006700; {  103.357002 }
     0x017500; {  373.048004 }
     0xFADD00; {-1314.999023 }
     0x08C300; { 2242.769043 }
     0xF6C900; {-2358.993896 }
     0x042900; { 1064.552979 }
     0x05D400; { 1491.542969 }
     0xEF5A00; {-4262.201172 }
     0x168A00; { 5769.721191 }
     0xEC9900; {-4966.987793 }
     0x07A500; { 1957.287964 }
     0x07A500; { 1957.287964 }
     0xEC9900; {-4966.987793 }
     0x168A00; { 5769.721191 }
     0xEF5A00; {-4262.201172 }
     0x05D400; { 1491.542969 }
     0x042900; { 1064.552979 }
     0xF6C900; {-2358.993896 }
     0x08C300; { 2242.769043 }
     0xFADD00; {-1314.999023 }
     0x017500; {  373.048004 }
     0x006700; {  103.357002 }
     0xFF8D00; { -115.209999 }
     0xFFC900; {  -54.793999 }
     0x009D00; {  157.169006 }
     0xFF6B00; { -149.065994 }
     0xFEEA00; { -278.438995 }
{----------------------------------------------------------------------------}
bpf_in2:	  
	i4=dc;				{ point to coefficients              }
	mr=0, mx0=dm(i1,m1), my0=pm(i4,m5);
	cntr=31;			{ length - 1                         }
	do sopbp until ce;
sopbp:	mr=mr+mx0*my0(ss), mx0=dm(i1,m1), my0=pm(i4,m5);
	mr=mr+mx0*my0(rnd);
	if mv sat mr;
	dm(bpf_out)=mr1;		{ save input BPF result              }
	rts;

{----------------------------------------------------------------------------}
{             2110 Hz Mark bandpass filter for 200 baud                      } 
{                         Fs=5512.5                                          }
{               Fcl=2030, Fch=2190     (BWpb=160)		             }
{              Fstl=1805,  Fsth=2415   (BWsb=610)   			     }
{ 									     }
{              FINITE IMPULSE RESPONSE (FIR)				     }
{            LINEAR PHASE DIGITAL FILTER DESIGN				     }
{                REMEZ EXCHANGE ALGORITHM				     }
{									     }
{                     BANDPASS FILTER					     }
{									     }
{             FILTER LENGTH =  32, delay = 2.9ms			     }
{									     }
{              ***** IMPULSE RESPONSE *****				     }
{         H( 1) =     325.335 = H( 32)					     }
{         H( 2) =    -420.936 = H( 31)					     }
{         H( 3) =     354.788 = H( 30)					     }
{         H( 4) =     205.330 = H( 29)					     }
{         H( 5) =   -1001.936 = H( 28)					     }
{         H( 6) =    1462.444 = H( 27)					     }
{         H( 7) =   -1159.848 = H( 26)					     }
{         H( 8) =     -20.884 = H( 25)					     }
{         H( 9) =    1661.597 = H( 24)					     }
{         H(10) =   -2765.895 = H( 23)					     }
{         H(11) =    2415.138 = H( 22)					     }
{         H(12) =    -555.952 = H( 21)					     }
{         H(13) =   -1903.418 = H( 20)					     }
{         H(14) =    3603.038 = H( 19)					     }
{         H(15) =   -3471.036 = H( 18)					     }
{         H(16) =    1428.150 = H( 17)					     }
{									     }
{                       BAND  1       BAND  2       BAND  3		     }
{ LOWER BAND EDGE      .0000000      .3682540      .4380950		     }
{ UPPER BAND EDGE      .3274376      .3972789      .5000000		     }
{ DESIRED VALUE        .0000000     1.0000000      .0000000		     }
{ WEIGHTING          10.0000000     1.0000000    10.0000000		     }
{ DEVIATION            .0095166      .0951655      .0095166		     }
{ DEVIATION IN DB   -40.4304100      .7895952   -40.4304100		     }
{----------------------------------------------------------------------------}
hc:  0x014500; {  325.334991 } 
     0xFE5B00; { -420.936005 } 
     0x016300; {  354.787994 } 
     0x00CD00; {  205.330002 } 
     0xFC1600; {-1001.935974 } 
     0x05B600; { 1462.443970 } 
     0xFB7800; {-1159.848022 } 
     0xFFEB00; {  -20.884001 } 
     0x067E00; { 1661.597046 } 
     0xF53200; {-2765.895020 } 
     0x096F00; { 2415.137939 } 
     0xFDD400; { -555.952026 } 
     0xF89100; {-1903.417969 } 
     0x0E1300; { 3603.038086 } 
     0xF27100; {-3471.035889 } 
     0x059400; { 1428.150024 } 
     0x059400; { 1428.150024 } 
     0xF27100; {-3471.035889 } 
     0x0E1300; { 3603.038086 } 
     0xF89100; {-1903.417969 } 
     0xFDD400; { -555.952026 } 
     0x096F00; { 2415.137939 } 
     0xF53200; {-2765.895020 } 
     0x067E00; { 1661.597046 } 
     0xFFEB00; {  -20.884001 } 
     0xFB7800; {-1159.848022 } 
     0x05B600; { 1462.443970 } 
     0xFC1600; {-1001.935974 }
     0x00CD00; {  205.330002 }
     0x016300; {  354.787994 }
     0xFE5B00; { -420.936005 }
     0x014500; {  325.334991 }
{----------------------------------------------------------------------------}
mark_filter2:								     
	i4=hc;				{ point to coefficients              }	     
	l2=32;				{ This filter length                 }
	mr=0, mx0=dm(i2,m1), my0=pm(i4,m5);				     
	cntr=31;			{ length - 1                         }			     
	do sopm until ce;						     
sopm:	mr=mr+mx0*my0(ss), mx0=dm(i2,m1), my0=pm(i4,m5);		     
	mr=mr+mx0*my0(rnd);						     
	if mv sat mr;
	ar = abs mr1;			{ envelope detection                 }
	dm(mark_out)=ar;		{ save mark result                   }		     
	rts;								     

{----------------------------------------------------------------------------}
{             2310 Hz Mark bandpass filter for 200 baud                      } 
{                         Fs=5512.5                                          }
{               Fcl=2230,   Fch=2390   (BWpb=160)		             }
{              Fstl=2005,  Fsth=2615   (BWsb=610)   			     }
{ 									     }
{              FINITE IMPULSE RESPONSE (FIR)				     }
{            LINEAR PHASE DIGITAL FILTER DESIGN				     }
{                REMEZ EXCHANGE ALGORITHM				     }
{									     }
{                     BANDPASS FILTER					     }
{									     }
{             FILTER LENGTH =  32, delay = 2.9ms			     }
{									     }
{              ***** IMPULSE RESPONSE *****				     }
{         H( 1) =    -397.911 = H( 32)					     }
{         H( 2) =     461.562 = H( 31)					     }
{         H( 3) =    -461.312 = H( 30)					     }
{         H( 4) =     187.683 = H( 29)					     }
{         H( 5) =     381.682 = H( 28)					     }
{         H( 6) =   -1125.509 = H( 27)					     }
{         H( 7) =    1787.245 = H( 26)					     }
{         H( 8) =   -2051.599 = H( 25)					     }
{         H( 9) =    1673.964 = H( 24)					     }
{         H(10) =    -608.627 = H( 23)					     }
{         H(11) =    -926.055 = H( 22)					     }
{         H(12) =    2486.161 = H( 21)					     }
{         H(13) =   -3543.459 = H( 20)					     }
{         H(14) =    3681.655 = H( 19)					     }
{         H(15) =   -2768.423 = H( 18)					     }
{         H(16) =    1027.235 = H( 17)					     }
{									     }
{                       BAND  1       BAND  2       BAND  3		     }
{ LOWER BAND EDGE      .0000000      .4045350      .4743760		     }
{ UPPER BAND EDGE      .3637188      .4335600      .5000000		     }
{ DESIRED VALUE        .0000000     1.0000000      .0000000		     }
{ WEIGHTING          10.0000000     1.0000000    10.0000000		     }
{ DEVIATION            .0119457      .1194566      .0119457		     }
{ DEVIATION IN DB   -38.4558000      .9801453   -38.4558000		     }
{----------------------------------------------------------------------------}
jc:  0xFE7200; { -397.911011 } 
     0x01CE00; {  461.562012 } 
     0xFE3300; { -461.312012 } 
     0x00BC00; {  187.682999 } 
     0x017E00; {  381.682007 } 
     0xFB9A00; {-1125.509033 } 
     0x06FB00; { 1787.244995 } 
     0xF7FC00; {-2051.599121 } 
     0x068A00; { 1673.963989 } 
     0xFD9F00; { -608.627014 } 
     0xFC6200; { -926.054993 } 
     0x09B600; { 2486.160889 } 
     0xF22900; {-3543.458984 } 
     0x0E6200; { 3681.655029 } 
     0xF53000; {-2768.423096 } 
     0x040300; { 1027.234985 } 
     0x040300; { 1027.234985 } 
     0xF53000; {-2768.423096 } 
     0x0E6200; { 3681.655029 } 
     0xF22900; {-3543.458984 } 
     0x09B600; { 2486.160889 } 
     0xFC6200; { -926.054993 } 
     0xFD9F00; { -608.627014 } 
     0x068A00; { 1673.963989 } 
     0xF7FC00; {-2051.599121 } 
     0x06FB00; { 1787.244995 } 
     0xFB9A00; {-1125.509033 } 
     0x017E00; {  381.682007 }
     0x00BC00; {  187.682999 }
     0xFE3300; { -461.312012 }
     0x01CE00; {  461.562012 }
     0xFE7200; { -397.911011 }
{----------------------------------------------------------------------------}
space_filter2:								     
	i4=jc;				{ point to coefficients              }	     
	l2=32;				{ filter length                      }
	mr=0, mx0=dm(i2,m1), my0=pm(i4,m5);				     
	cntr=31;			{ length - 1                         }			     
	do sops until ce;						     
sops:	mr=mr+mx0*my0(ss), mx0=dm(i2,m1), my0=pm(i4,m5);		     
	mr=mr+mx0*my0(rnd);						     
	if mv sat mr;
	ar = abs mr1;			{ envelope detection                 }
	dm(space_out)=ar;		{ save space result                  }		     
	rts;								     

{----------------------------------------------------------------------------}
{              Data output lowpass filter			             }
{----------------------------------------------------------------------------}
{ Type of filter is LOW PASS FILTER					     }
{ Filter length is 31 samples						     }
{ Sampling frequency is     5512.500 Hz					     }
{ Filter cut-off frequency is      200.000 Hz				     }
{ Type of window function is KAISER-BESSEL WINDOW			     }
{ Attenuation parameter of window is 60.000 dB				     }
{ Coefficient word length is 16 bits					     }
{									     }
{ Filter coefficients:							     }
{									     }
{   i          h[i]        hqf[i]        hqi[i]		     		     }
{		                                                             }
{   0   -0.00011866   -0.00012207            -4		     		     }
{   1   -0.00005377   -0.00006104            -2		     		     }
{   2    0.00037365    0.00036621            12		     		     }
{   3    0.00143962    0.00143433            47		     		     }
{   4    0.00345224    0.00344849           113		     		     }
{   5    0.00670193    0.00671387           220		     		     }
{   6    0.01140058    0.01141357           374		     		     }
{   7    0.01762031    0.01760864           577		     		     }
{   8    0.02524469    0.02523804           827		     		     }
{   9    0.03394446    0.03393555          1112		     		     }
{  10    0.04318654    0.04318237          1415		     		     }
{  11    0.05227925    0.05227661          1713		     		     }
{  12    0.06044954    0.06045532          1981		     		     }
{  13    0.06694148    0.06695557          2194		     		     }
{  14    0.07112005    0.07110596          2330		     		     }
{  15    0.07256236    0.07257080          2378		     		     }
{  16    0.07112005    0.07110596          2330		     		     }
{  17    0.06694148    0.06695557          2194		     		     }
{  18    0.06044954    0.06045532          1981		     		     }
{  19    0.05227925    0.05227661          1713		     		     }
{  20    0.04318654    0.04318237          1415		     		     }
{  21    0.03394446    0.03393555          1112		     		     }
{  22    0.02524469    0.02523804           827		     		     }
{  23    0.01762031    0.01760864           577		     		     }
{  24    0.01140058    0.01141357           374		     		     }
{  25    0.00670193    0.00671387           220		     		     }
{  26    0.00345224    0.00344849           113		     		     }
{  27    0.00143962    0.00143433            47		     		     }
{  28    0.00037365    0.00036621            12		     		     }
{  29   -0.00005377   -0.00006104            -2		     		     }
{  30   -0.00011866   -0.00012207            -4		     		     }
{----------------------------------------------------------------------------}
kc:	0xFFFC00; {   -4.000000 }				     
	0xFFFE00; {   -2.000000 }				     
	0x000C00; {   12.000000 }				     
	0x002F00; {   47.000000 }				     
	0x007100; {  113.000000 }
	0x00DC00; {  220.000000 }
	0x017600; {  374.000000 }
	0x024100; {  577.000000 }
	0x033B00; {  827.000000 }
	0x045800; { 1112.000000 }
	0x058700; { 1415.000000 }
	0x06B100; { 1713.000000 }
	0x07BD00; { 1981.000000 }
	0x089200; { 2194.000000 }
	0x091A00; { 2330.000000 }
	0x094A00; { 2378.000000 }
	0x091A00; { 2330.000000 }
	0x089200; { 2194.000000 }
	0x07BD00; { 1981.000000 }
	0x06B100; { 1713.000000 }
	0x058700; { 1415.000000 }
	0x045800; { 1112.000000 }
	0x033B00; {  827.000000 }
	0x024100; {  577.000000 }
	0x017600; {  374.000000 }
	0x00DC00; {  220.000000 }
	0x007100; {  113.000000 }
	0x002F00; {   47.000000 }
	0x000C00; {   12.000000 }
	0xFFFE00; {   -2.000000 }
	0xFFFC00; {   -4.000000 }
{----------------------------------------------------------------------------}
data_lp2:	  
	i4=kc;				{ point to coefficients              }
	l3=31;				{ filter length                      }
	mr=0, mx0=dm(i3,m1), my0=pm(i4,m5);
	cntr=30;			{ length - 1                         }
	do sopd2 until ce;
sopd2:	mr=mr+mx0*my0(ss), mx0=dm(i3,m1), my0=pm(i4,m5);
	mr=mr+mx0*my0(rnd);
	if mv sat mr;
	dm(data_out)=mr1;		{ save result                        }
	rts;
{----------------------------------------------------------------------------}
{            Input bandpass filter for 100 baud				     }
{                       Fs=5512.5                                            }
{              Fcl=2075,   Fch=2345  (BWpb=270)		                     }
{            Fstpl=1850, Fstph=2570  (BWsb=720)			             }
{									     }
{              FINITE IMPULSE RESPONSE (FIR)				     }
{            LINEAR PHASE DIGITAL FILTER DESIGN				     }
{                REMEZ EXCHANGE ALGORITHM				     }
{									     }
{                     BANDPASS FILTER					     }
{									     }
{            FILTER LENGTH =  32, delay = 2.9ms				     }
{									     }
{              ***** IMPULSE RESPONSE *****				     }
{         H( 1) =    -187.176 = H( 32)	     				     }
{         H( 2) =     -97.714 = H( 31)	     				     }
{         H( 3) =    -170.816 = H( 30)	     				     }
{         H( 4) =     446.096 = H( 29)	     				     }
{         H( 5) =    -556.451 = H( 28)	     				     }
{         H( 6) =     260.679 = H( 27)	     				     }
{         H( 7) =     556.888 = H( 26)	     				     }
{         H( 8) =   -1673.540 = H( 25)	     				     }
{         H( 9) =    2514.301 = H( 24)	     				     }
{         H(10) =   -2408.182 = H( 23)	     				     }
{         H(11) =    1018.579 = H( 22)	     				     }
{         H(12) =    1327.451 = H( 21)	     				     }
{         H(13) =   -3664.771 = H( 20)	     				     }
{         H(14) =    4826.718 = H( 19)	     				     }
{         H(15) =   -4082.166 = H( 18)	     				     }
{         H(16) =    1594.695 = H( 17)	     				     }
{	                                                                     }
{                       BAND  1       BAND  2       BAND  3	     	     }
{ LOWER BAND EDGE      .0000000      .3764000      .4662000	     	     }
{ UPPER BAND EDGE      .3356000      .4254000      .5000000	     	     }
{ DESIRED VALUE        .0000000     1.0000000      .0000000	     	     }
{ WEIGHTING          10.0000000     1.0000000    10.0000000	     	     }
{ DEVIATION            .0180309      .1803087      .0180309	     	     }
{ DEVIATION IN DB   -34.8796700     1.4399120   -34.8796700	     	     }
{----------------------------------------------------------------------------}
dc1:   0xFF4500; { -187.175995 }	
       0xFF9E00; {  -97.713997 }	
       0xFF5500; { -170.815994 }	
       0x01BE00; {  446.096008 }	
       0xFDD400; { -556.450989 }	
       0x010500; {  260.678986 }	
       0x022D00; {  556.888000 }	
       0xF97600; {-1673.540039 }	
       0x09D200; { 2514.301025 }	
       0xF69800; {-2408.181885 }	
       0x03FB00; { 1018.578979 }	
       0x052F00; { 1327.451050 }	
       0xF1AF00; {-3664.770996 }	
       0x12DB00; { 4826.717773 }	
       0xF00E00; {-4082.166016 }	
       0x063B00; { 1594.694946 }	
       0x063B00; { 1594.694946 }	
       0xF00E00; {-4082.166016 }	
       0x12DB00; { 4826.717773 }	
       0xF1AF00; {-3664.770996 }	
       0x052F00; { 1327.451050 }	
       0x03FB00; { 1018.578979 }	
       0xF69800; {-2408.181885 }
       0x09D200; { 2514.301025 }
       0xF97600; {-1673.540039 }
       0x022D00; {  556.888000 }
       0x010500; {  260.678986 }
       0xFDD400; { -556.450989 }
       0x01BE00; {  446.096008 }
       0xFF5500; { -170.815994 }
       0xFF9E00; {  -97.713997 }
       0xFF4500; { -187.175995 }
{----------------------------------------------------------------------------}
bpf_in1:	  
	i4=dc1;				{ point to coefficients              }
	mr=0, mx0=dm(i1,m1), my0=pm(i4,m5);
	cntr=31;			{ length - 1                         }
	do sopbp1 until ce;
sopbp1:	mr=mr+mx0*my0(ss), mx0=dm(i1,m1), my0=pm(i4,m5);
	mr=mr+mx0*my0(rnd);
	if mv sat mr;
	dm(bpf_out)=mr1;		{ save input BPF result              }
	rts;

{----------------------------------------------------------------------------}
{            100 Baud Mark bandpass filter at 2125 Hz		             }
{                       Fs=5512.5                                            }
{              Fcl=2075,   Fch=2175  (BWpb=100)		                     }
{            Fstpl=1850, Fstph=2400  (BWsb=550)			             }
{									     }
{              FINITE IMPULSE RESPONSE (FIR)				     }
{            LINEAR PHASE DIGITAL FILTER DESIGN				     }
{                REMEZ EXCHANGE ALGORITHM				     }
{									     }
{                     BANDPASS FILTER					     }
{									     }
{ FILTER LENGTH =  54, however the algorithm will truncate the filter to     }
{ the same length as the 200 baud filter.				     }
{									     }
{              ***** IMPULSE RESPONSE *****				     }
{         H( 1) =     -50.828 = H( 54)	     				     }
{         H( 2) =     -50.360 = H( 53)	     				     }
{         H( 3) =      64.410 = H( 52)	     				     }
{         H( 4) =     -58.060 = H( 51)	     				     }
{         H( 5) =      26.085 = H( 50)	     				     }
{         H( 6) =        .257 = H( 49)	     				     }
{         H( 7) =      17.374 = H( 48)	     				     }
{         H( 8) =     -74.849 = H( 47)	     				     }
{         H( 9) =     102.469 = H( 46)	     				     }
{         H(10) =      -6.040 = H( 45)	     				     }
{         H(11) =    -239.639 = H( 44)	     				     }
{         H(12) =     516.173 = H( 43)	     				     }
{         H(13) =    -588.654 = H( 42)	     				     }
{         H(14) =     256.211 = H( 41)	     				     }
{         H(15) =     456.089 = H( 40)	     				     }
{         H(16) =   -1213.837 = H( 39)	     				     }
{         H(17) =    1506.112 = H( 38)	     				     }
{         H(18) =    -961.908 = H( 37)	     				     }
{         H(19) =    -338.876 = H( 36)	     				     }
{         H(20) =    1792.896 = H( 35)	     				     }
{         H(21) =   -2549.883 = H( 34)	     				     }
{         H(22) =    2018.073 = H( 33)	     				     }
{         H(23) =    -288.953 = H( 32)	     				     }
{         H(24) =   -1814.791 = H( 31)	     				     }
{         H(25) =    3154.414 = H( 30)	     				     }
{         H(26) =   -2931.318 = H( 29)	     				     }
{         H(27) =    1185.978 = H( 28)	     				     }
{	     				     				     }
{                       BAND  1       BAND  2       BAND  3	     	     }
{ LOWER BAND EDGE      .0000000      .3764000      .4354000	     	     }
{ UPPER BAND EDGE      .3356000      .3946000      .5000000	     	     }
{ DESIRED VALUE        .0000000     1.0000000      .0000000	     	     }
{ WEIGHTING          10.0000000     1.0000000    10.0000000	     	     }
{ DEVIATION            .0043615      .0436148      .0043615	     	     }
{ DEVIATION IN DB   -47.2073200      .3708049   -47.2073200	     	     }
{----------------------------------------------------------------------------}
      0xFFCD00; { -50.827999 }
      0xFFCE00; { -50.360001 }
      0x004000; {  64.410004 }
      0xFFC600; { -58.060001 }
      0x001A00; {  26.084999 }
      0x000000; {   0.257000 }
      0x001100; {  17.374001 }
      0xFFB500; { -74.848999 }
      0x006600; { 102.469002 }
      0xFFFA00; {  -6.040000 }
      0xFF1000; {-239.639008 }
{---- above 11 coefficients are not used ----}
hc1_11: 0x020400; { 516.172974 }
      0xFDB300; { -588.653992 }
      0x010000; {  256.210999 }
      0x01C800; {  456.088989 }
      0xFB4200; {-1213.837036 }
      0x05E200; { 1506.112061 }
      0xFC3E00; { -961.908020 }
      0xFEAD00; { -338.876007 }
      0x070100; { 1792.895996 }
      0xF60A00; {-2549.883057 }
      0x07E200; { 2018.072998 }
      0xFEDF00; { -288.953003 }
      0xF8E900; {-1814.791016 }
      0x0C5200; { 3154.414062 }
      0xF48D00; {-2931.318115 }
      0x04A200; { 1185.978027 }
      0x04A200; { 1185.978027 }
      0xF48D00; {-2931.318115 }
      0x0C5200; { 3154.414062 }
      0xF8E900; {-1814.791016 }
      0xFEDF00; { -288.953003 }
      0x07E200; { 2018.072998 }
      0xF60A00; {-2549.883057 }
      0x070100; { 1792.895996 }
      0xFEAD00; { -338.876007 }
      0xFC3E00; { -961.908020 }
      0x05E200; { 1506.112061 }
      0xFB4200; {-1213.837036 }
      0x01C800; {  456.088989 }
      0x010000; {  256.210999 }
      0xFDB300; { -588.653992 }
      0x020400; {  516.172974 }
      0xFF1000; { -239.639008 }
      0xFFFA00; {   -6.040000 }
      0x006600; {  102.469002 }
      0xFFB500; {  -74.848999 }
      0x001100; {   17.374001 }
      0x000000; {    0.257000 }
      0x001A00; {   26.084999 }
      0xFFC600; {  -58.060001 }
      0x004000; {   64.410004 }
      0xFFCE00; {  -50.360001 }
      0xFFCD00; {  -50.827999 }
{----------------------------------------------------------------------------}
mark_filter1:								     
	i4=hc1_11;			{ point to coefficients              }	     
	l2=32;				{ This filter length -note truncated-}
	mr=0, mx0=dm(i2,m1), my0=pm(i4,m5);				     
	cntr=31;			{ length - 1                         }			     
	do sopm1 until ce;						     
sopm1:	mr=mr+mx0*my0(ss), mx0=dm(i2,m1), my0=pm(i4,m5);		     
	mr=mr+mx0*my0(rnd);						     
	if mv sat mr;
	ar = abs mr1;			{ envelope detection                 }
	dm(mark_out)=ar;		{ save mark result                   }		     
	rts;								     
{----------------------------------------------------------------------------}
{            100 Baud Space bandpass filter at 2295 Hz		             }
{                       Fs=5512.5                                            }
{              Fcl=2245,   Fch=2345  (BWpb=100)		                     }
{            Fstpl=2020, Fstph=2570  (BWsb=550)			             }
{									     }
{              FINITE IMPULSE RESPONSE (FIR)				     }
{            LINEAR PHASE DIGITAL FILTER DESIGN				     }
{                REMEZ EXCHANGE ALGORITHM				     }
{									     }
{                     BANDPASS FILTER					     }
{									     }
{ FILTER LENGTH =  54, however the algorithm will truncate the filter to     }
{ the same length as the 200 baud filter.				     }
{									     }
{              ***** IMPULSE RESPONSE *****				     }
{         H( 1) =     -93.030 = H( 54)	     				     }
{         H( 2) =      46.098 = H( 53)	     				     }
{         H( 3) =     -25.463 = H( 52)	     				     }
{         H( 4) =      -8.725 = H( 51)	     				     }
{         H( 5) =      35.308 = H( 50)	     				     }
{         H( 6) =     -33.737 = H( 49)	     				     }
{         H( 7) =       1.010 = H( 48)	     				     }
{         H( 8) =      37.589 = H( 47)	     				     }
{         H( 9) =     -34.152 = H( 46)	     				     }
{         H(10) =     -58.028 = H( 45)	     				     }
{         H(11) =     250.826 = H( 44)	     				     }
{         H(12) =    -493.509 = H( 43)	     				     }
{         H(13) =     673.650 = H( 42)	     				     }
{         H(14) =    -652.255 = H( 41)	     				     }
{         H(15) =     328.284 = H( 40)	     				     }
{         H(16) =     294.866 = H( 39)	     				     }
{         H(17) =   -1073.991 = H( 38)	     				     }
{         H(18) =    1748.364 = H( 37)	     				     }
{         H(19) =   -2022.781 = H( 36)	     				     }
{         H(20) =    1685.986 = H( 35)	     				     }
{         H(21) =    -717.446 = H( 34)	     				     }
{         H(22) =    -667.943 = H( 33)	     				     }
{         H(23) =    2065.687 = H( 32)	     				     }
{         H(24) =   -3011.409 = H( 31)	     				     }
{         H(25) =    3149.152 = H( 30)	     				     }
{         H(26) =   -2372.752 = H( 29)	     				     }
{         H(27) =     880.908 = H( 28)	     				     }
{	     					                             }
{                       BAND  1       BAND  2       BAND  3	     	     }
{ LOWER BAND EDGE      .0000000      .4073000      .4662000	     	     }
{ UPPER BAND EDGE      .3664000      .4254000      .5000000	     	     }
{ DESIRED VALUE        .0000000     1.0000000      .0000000	     	     }
{ WEIGHTING          10.0000000     1.0000000    10.0000000	     	     }
{ DEVIATION            .0041196      .0411962      .0041196	     	     }
{ DEVIATION IN DB   -47.7028500      .3506519   -47.7028500	     	     }
{----------------------------------------------------------------------------}
      0xFFA300; {  -93.029999 }
      0x002E00; {   46.098000 }
      0xFFE700; {  -25.462999 }
      0xFFF700; {   -8.725000 }
      0x002300; {   35.307999 }
      0xFFDE00; {  -33.737000 }
      0x000100; {    1.010000 }
      0x002600; {   37.589001 }
      0xFFDE00; {  -34.152000 }
      0xFFC600; {  -58.028000 }
      0x00FB00; {  250.826004 }
{---- above 11 coefficients are not used ----}
jc1:  0xFE1200; { -493.509003 }
      0x02A200; {  673.650024 }
      0xFD7400; { -652.255005 }
      0x014800; {  328.283997 }
      0x012700; {  294.865997 }
      0xFBCE00; {-1073.990967 }
      0x06D400; { 1748.364014 }
      0xF81900; {-2022.781006 }
      0x069600; { 1685.985962 }
      0xFD3300; { -717.445984 }
      0xFD6400; { -667.942993 }
      0x081200; { 2065.687012 }
      0xF43D00; {-3011.408936 }
      0x0C4D00; { 3149.152100 }
      0xF6BB00; {-2372.751953 }
      0x037100; {  880.908020 }
      0x037100; {  880.908020 }
      0xF6BB00; {-2372.751953 }
      0x0C4D00; { 3149.152100 }
      0xF43D00; {-3011.408936 }
      0x081200; { 2065.687012 }
      0xFD6400; { -667.942993 }
      0xFD3300; { -717.445984 }
      0x069600; { 1685.985962 }
      0xF81900; {-2022.781006 }
      0x06D400; { 1748.364014 }
      0xFBCE00; {-1073.990967 }
      0x012700; {  294.865997 }
      0x014800; {  328.283997 }
      0xFD7400; { -652.255005 }
      0x02A200; {  673.650024 }
      0xFE1200; { -493.509003 }
      0x00FB00; {  250.826004 }
      0xFFC600; {  -58.028000 }
      0xFFDE00; {  -34.152000 }
      0x002600; {   37.589001 }
      0x000100; {    1.010000 }
      0xFFDE00; {  -33.737000 }
      0x002300; {   35.307999 }
      0xFFF700; {   -8.725000 }
      0xFFE700; {  -25.462999 }
      0x002E00; {   46.098000 }
      0xFFA300; {  -93.029999 }
{----------------------------------------------------------------------------}
space_filter1:								     
	i4=jc1;				{ point to coefficients              }	     
	l2=32;				{ This filter length                 }
	mr=0, mx0=dm(i2,m1), my0=pm(i4,m5);				     
	cntr=31;			{ length - 1                         }			     
	do sops1 until ce;						     
sops1:	mr=mr+mx0*my0(ss), mx0=dm(i2,m1), my0=pm(i4,m5);		     
	mr=mr+mx0*my0(rnd);						     
	if mv sat mr;
	ar = abs mr1;			{ envelope detection                 }
	dm(space_out)=ar;		{ save space result                  }		     
	rts;								     
{----------------------------------------------------------------------------}
{              Data output lowpass filter			             }
{----------------------------------------------------------------------------}
{ Type of filter is LOW PASS FILTER					     }
{ Filter length is 31 samples						     }
{ Sampling frequency is     5512.500 Hz					     }
{ Filter cut-off frequency is      100.000 Hz				     }
{ Type of window function is KAISER-BESSEL WINDOW			     }
{ Attenuation parameter of window is 60.000 dB				     }
{ Coefficient word length is 16 bits					     }
{									     }
{ Filter coefficients:							     }
{									     }
{   i          h[i]        hqf[i]        hqi[i]				     }
{									     }
{   0    0.00042848    0.00042725            14				     }
{   1    0.00107848    0.00106812            35				     }
{   2    0.00210083    0.00210571            69				     }
{   3    0.00356985    0.00357056           117				     }
{   4    0.00553730    0.00552368           181				     }
{   5    0.00802108    0.00802612           263				     }
{   6    0.01099609    0.01098633           360				     }
{   7    0.01438892    0.01437378           471				     }
{   8    0.01807746    0.01806641           592				     }
{   9    0.02189613    0.02188110           717				     }
{  10    0.02564664    0.02563477           840				     }
{  11    0.02911341    0.02911377           954				     }
{  12    0.03208216    0.03207397          1051				     }
{  13    0.03435966    0.03436279          1126				     }
{  14    0.03579227    0.03579712          1173				     }
{  15    0.03628118    0.03628540          1189				     }
{  16    0.03579227    0.03579712          1173				     }
{  17    0.03435966    0.03436279          1126				     }
{  18    0.03208216    0.03207397          1051				     }
{  19    0.02911341    0.02911377           954				     }
{  20    0.02564664    0.02563477           840				     }
{  21    0.02189613    0.02188110           717				     }
{  22    0.01807746    0.01806641           592				     }
{  23    0.01438892    0.01437378           471				     }
{  24    0.01099609    0.01098633           360				     }
{  25    0.00802108    0.00802612           263				     }
{  26    0.00553730    0.00552368           181				     }
{  27    0.00356985    0.00357056           117				     }
{  28    0.00210083    0.00210571            69				     }
{  29    0.00107848    0.00106812            35				     }
{  30    0.00042848    0.00042725            14				     }
{----------------------------------------------------------------------------}
kc1:	0x000E00; {   14.000000 }					     
	0x002300; {   35.000000 }					     
	0x004500; {   69.000000 }					     
	0x007500; {  117.000000 }				     
	0x00B500; {  181.000000 }
	0x010700; {  263.000000 }
	0x016800; {  360.000000 }
	0x01D700; {  471.000000 }
	0x025000; {  592.000000 }
	0x02CD00; {  717.000000 }
	0x034800; {  840.000000 }
	0x03BA00; {  954.000000 }
	0x041B00; { 1051.000000 }
	0x046600; { 1126.000000 }
	0x049500; { 1173.000000 }
	0x04A500; { 1189.000000 }
	0x049500; { 1173.000000 }
	0x046600; { 1126.000000 }
	0x041B00; { 1051.000000 }
	0x03BA00; {  954.000000 }
	0x034800; {  840.000000 }
	0x02CD00; {  717.000000 }
	0x025000; {  592.000000 }
	0x01D700; {  471.000000 }
	0x016800; {  360.000000 }
	0x010700; {  263.000000 }
	0x00B500; {  181.000000 }
	0x007500; {  117.000000 }
	0x004500; {   69.000000 }
	0x002300; {   35.000000 }
	0x000E00; {   14.000000 }
{----------------------------------------------------------------------------}
data_lp1:	  
	i4=kc1;				{ point to coefficients              }
	mr=0, mx0=dm(i3,m1), my0=pm(i4,m5);
	cntr=30;			{ length - 1                         }
	do sopd2_1 until ce;
sopd2_1:	
 	mr=mr+mx0*my0(ss), mx0=dm(i3,m1), my0=pm(i4,m5);
	mr=mr+mx0*my0(rnd);
	if mv sat mr;
	dm(data_out)=mr1;		{ save result                        }
	rts;

{-------------------------- AFSK modulator ----------------------------------}
afsk:
	ena M_MODE;
	
     	ar = 1;
     	dm(mps)=ar;   	{ Restore sine and cosine quadrant multipliers       }
	ar = dm(tph);

tones: 	
	dm(wkph)=ar;		{ store a working copy                       }
	si=ar;
	sr = lshift si by -12 HI;	

	ay0=1;
	ar=sr1-ay0;		{ subtract 1 from high word                  }
     	if lt jump getem;  	{ is it in a quadrant bigger than first?     }

	    			{ yes its quadrant 2/3/4                     }
	ar=ar-ay0;		{ subtract 1 from high word                  }

	if ge jump thfr; 	{ is it in a quadrant greater than 2?        }

	ax0=0x2000;		{ no, so load PI                             }
	ay0=dm(wkph);
	ar=ax0 - ay0;		{ subtract phase so that it maps back to 1st }
	dm(wkph)=ar;		{ store                                      }
     	jump getem;		{ go read tables                             }

thfr: 	ar= -1;			{ -1 multiplier for bottom half	             }
     	dm(mps)=ar;  		{ store	                                     }

	ay0=0x2000;		{ map angle back to upper half               }
	ar=dm(wkph);
	ar=ar - ay0;
     	jump tones;    		{ and do it again                            }

{---------------------- Table lookup ----------------------------------------}
getem: 	
	si=dm(wkph);		  { take 1st quadrant equiv for sine and     }
	sr = lshift si by -6 HI;  { extract coarse part of phase address     }	

	i5 = sines; 		{ compute coarse value for index register    }
	ar=i5;
	ay0=sr1;
	ar=ar+ay0;
	i5=ar;
	ar=pm(i5,m5);		{ read the value                             }

	my1=dm(mps);		{ multiply by sign                           }
	mr=ar*my1(ss);
	dm(sinx)=mr0;		{ save result                                }

{------------------ Update cumulative phase angle ---------------------------}
{                  When data_bit 0000 ==> no afsk being generated            }
{                                 0001==> mark                               }
{                                 0002==> space                              }
{----------------------------------------------------------------------------}
	ay0=0x0001;		{ MARK?                                      }
	ax0=dm(databit);
	ar=ax0 xor ay0;
	if eq jump set_mark;
		 		
	ay0=6821;		{  Space = (2295/5512.5)/2*32768  = 6821     }
	jump tone_out;

set_mark:
	ay0=6316;		{  Mark  = (2125/5512.5)/2*32768  = 6316     }

tone_out:
	si=dm(sinx);
	sr = ashift si by -4 HI; { scale signal level for output             }	
	dm(sigout)=sr1;
	
	ar=dm(tph); 		{ update phase accumulator                   }
	ar=ar+ay0;
	ay0=0x3FFF;
	ar=ar and ay0;
	dm(tph)=ar;

afsk_fin:
	dis M_MODE;
	rts;
{---------------- Sine table in steps of PI/64 radians to PI/2---------------}
sines:	0x000000; {     0.000000 }
	0x032400; {   804.000000 }
	0x064700; {  1607.000000 }
	0x096A00; {  2410.000000 }
	0x0C8B00; {  3211.000000 }
	0x0FAB00; {  4011.000000 }
	0x12C700; {  4807.000000 }
	0x15E100; {  5601.000000 }
	0x18F800; {  6392.000000 }
	0x1C0B00; {  7179.000000 }
	0x1F1900; {  7961.000000 }
	0x222300; {  8739.000000 }
	0x252700; {  9511.000000 }
	0x282600; { 10278.000000 }
	0x2B1E00; { 11038.000000 }
	0x2E1000; { 11792.000000 }
	0x30FB00; { 12539.000000 }
	0x33DE00; { 13278.000000 }
	0x36B900; { 14009.000000 }
	0x398C00; { 14732.000000 }
	0x3C5600; { 15446.000000 }
	0x3F1600; { 16150.000000 }
	0x41CD00; { 16845.000000 }
	0x447A00; { 17530.000000 }
	0x471C00; { 18204.000000 }
	0x49B300; { 18867.000000 }
	0x4C3F00; { 19519.000000 }
	0x4EBF00; { 20159.000000 }
	0x513300; { 20787.000000 }
	0x539A00; { 21402.000000 }
	0x55F400; { 22004.000000 }
	0x584200; { 22594.000000 }
	0x5A8100; { 23169.000000 }
	0x5CB300; { 23731.000000 }
	0x5ED600; { 24278.000000 }
	0x60EB00; { 24811.000000 }
	0x62F100; { 25329.000000 }
	0x64E700; { 25831.000000 }
	0x66CE00; { 26318.000000 }
	0x68A500; { 26789.000000 }
	0x6A6C00; { 27244.000000 }
	0x6C2300; { 27683.000000 }
	0x6DC900; { 28105.000000 }
	0x6F5E00; { 28510.000000 }
	0x70E100; { 28897.000000 }
	0x725400; { 29268.000000 }
	0x73B500; { 29621.000000 }
	0x750300; { 29955.000000 }
	0x764000; { 30272.000000 }
	0x776B00; { 30571.000000 }
	0x788300; { 30851.000000 }
	0x798900; { 31113.000000 }
	0x7A7C00; { 31356.000000 }
	0x7B5C00; { 31580.000000 }
	0x7C2900; { 31785.000000 }
	0x7CE200; { 31970.000000 }
	0x7D8900; { 32137.000000 }
	0x7E1C00; { 32284.000000 }
	0x7E9C00; { 32412.000000 }
	0x7F0800; { 32520.000000 }
	0x7F6100; { 32609.000000 }
	0x7FA600; { 32678.000000 }
	0x7FD700; { 32727.000000 }
	0x7FF500; { 32757.000000 }
	0x7FFF00; { 32767.000000  PI/2 }

	nop;	    				{ Just for good measure      }
	nop;
{========================= END OF USER'S DSP CODE ===========================}
