{----------------------------------------------------------------------------}
{                    RTE for adaptive HF DSP modems                          }
{									     }
{             "An Adaptive HF DSP Modem for 100 and 200 Baud"                }
{                              QEX, Nov 1994.		                     }
{									     }
{                    (c) Johan Forrer, KC7WW				     }
{		         26553 Priceview Drive                               }
{                         Monroe, OR 97456				     }
{----------------------------------------------------------------------------}
{									     }
{                    Compilation instructions:                               }
{                         >spasm21 RTE.dsp	      		             }
{                         >cload   RTE				             }
{									     }
{----------------------------------------------------------------------------}
				{ Monitor version number                     }
                                { returned when monitor is initialized       }
.CONST version = 0x0100;        { msb byte represents integer value          }
                                { lsb byte represents a decimal value        }
                                { from .01 to .99                            }
{									     }
{----------------------------------------------------------------------------}
{      Command Interpreter functions		                             }
{----------------------------------------------------------------------------}
{	CODE     Function						     }
{----------------------------------------------------------------------------}
{	0x00b0 - Start timer						     }
{	0x00b1 - End timer						     }
{	0x00b4 - Start 1848 CODEC					     }
{	0x00b5 - End   1848 CODEC					     }
{	0x00ba - Update timing value					     }
{	0x00bb - Update speaker level					     }
{	0x00bc - Update line in level					     }
{	0x00bd - Update databit state					     }
{	0x00be - Update modem_select					     }
{	0x00d0 - Read  Dm location					     }
{	0x00d1 - Write Dm location					     }
{	0x00d2 - Read  Pm location					     }
{	0x00d3 - Write Pm location					     }
{	0x00d4 - Send back "PSA-MON" string				     }
{									     }
{----------------------------------------------------------------------------}
{									     }
{             The following are useful addresses		             }
{									     }
{----------------------------------------------------------------------------}
.const PSS_data_reg	=0x3000;					     
.const PSS_control_reg	=0x3008;					     
.const PSS_status_reg	=0x3008;
.const PSS_dma_reg	=0x3010;
.const ram_bank_reg	=0x3018;
.const ext_mem_latch	=0x3020;

.const addr_1848	=0x3440;
.const data_1848	=0x3448;
.const stat_1848	=0x3450;
.const pio_1848		=0x3458;
.const IRQ_status	=0x31C0;
.const dmal_1848	=0x3060;
.const dmar_1848	=0x3068;
.const enable_1848	=0x3070;

.const system_control	=0x3FFF;
.const wait_state_ctl	=0x3FFE;
.const timer_period	=0x3FFD;
.const timer_counter	=0x3FFC;
.const timer_prescale	=0x3FFB;


{----------------------------------------------------------------------------}
{------------- Misc data variables used in modem ----------------------------}
{									     }
{              Note: delay lines use circular addressing                     }
{                      9- 16 requires a " 16=0x0010" boundary                }
{              length 17- 32 requires a " 32=0x0020" boundary                }
{                     33- 64 requires a " 64=0x0040" boundary                }
{                     65-128 requires a "128=0x0080" boundary                }
{                    129-256 requires a "256=0x0100" boundary                }
{----------------------------------------------------------------------------}
.const DATALP		=0x3820;	{ 3820 -> 383F Data low pass         }
.const FILTER		=0x3880;	{ 3880 -> 38CF Filter delay line     } 
.const BPFI		=0x3920;	{ 3920 -> 393F Input bandpass 	     }

.const bpf_out		=0x3800;
.const data_out		=0x3801;
.const mark_out		=0x3802;
.const space_out	=0x3803;

.const mps 		=0x3804;
.const tph		=0x3805;
.const wkph		=0x3806;
.const sinx		=0x3807;
.const sigout		=0x3808;
.const databit		=0x3809;
.const timing_val	=0x380A;
.const dither		=0x380B;
.const modem_select     =0x380C;

{----------------------------------------------------------------------------}
{ Here we define the start address of our DSP application that 	             }
{ actually forms part of AD1848 ISR                                          } 
{----------------------------------------------------------------------------}
.const sound_port	=0x0100;	{ ISR is at 0100		     }
{----------------------------------------------------------------------------}

{--------------------INTERRUPT VECTORS---------------------------------------}
	jump main_; nop; nop; nop;      { 0000 restart interrupt             }
	jump sound_port; nop; nop; nop;	{ 0004 IRQ2 interrupt                }
	rti; nop; nop; nop;             { 0008 SPORT0 transmit interrupt     }
	rti; nop; nop; nop;             { 000C SPORT0 receive interrupt      }
	rti; nop; nop; nop;             { 0010 IRQ1 or SPORT1 tx interrupt   }
	rti; nop; nop; nop;             { 0014 pc_irq_vec. (IRQ0)/SPORT1 rx  }
	jump timer_int;nop;nop;nop;	{ 0018 Timer interrupt               }

{==============BEGINNING OF RTE INITIALIZATION CODE==========================}
main_:
	ax0 = dm(PSS_data_reg); { dummy read to clear out last boot byte     }
	ax1 = version;          { send version number to PC                  }
	call put_word_;

	ax0 = 0x0007; 		{ no nesting of interrupts                   }
	ICNTL=ax0;		{ all interupts EDGE sensitive               }

	ax0 = 0x3E80;		{ for 1ms ticks Timer period                 }
	dm(timer_period) = ax0;	{ --will be reprogrammed later--	     }
	ax0 = 0x0000;
	dm(timer_prescale) = ax0; { Timer prescale                           }

	l0=0;l1=0;l2=0;l3=0;    { all length (modulo) registers              }
	l4=0;l5=0;l6=0;l7=0;    { should be set to 0                         }

	m0=0;m1=1;m2=0;m3=-1;   { modify registers set ( DAG1 set)           }
	m4=0;m5=1;m6=0;m7=-1;   { to various constants ( DAG2 set)           }

{	ax0=0x2000;		  ---- FOR Cardinal                          }
	ax0=0x3000;		{ ---- FOR Orchid SoundWave 32               }

	dm(wait_state_ctl)=ax0; { set 2 wait states- Sound port              }
				{ zero wait states for everything else       }
	ax0=dm(system_control); { read the system control register           }
	ay0=0xfff8;
	ar=ax0 and ay0;         { make program mem 0 wait state              }
	dm(system_control)=ar;

	ax0 = 0x2000;		{ set SPWE (bit 13) in IRQ enable register   }
	dm(IRQ_status)=ax0;	{ to allow DMA interrupts                    }

	ar=0;
	dm(databit)=ar;		{ AFSK synthesis off                         }
	dm(dither)=ar;		{ dither off                                 }
	dm(modem_select)=ar;	{ use 100 baud modem                         }

{============== BEGINNING OF RTE IDLE LOOP ==================================}
{------ Call & Answer, Asynchronous Command Interpreter ---------------------}
loop_:
	call get_word_;

	ay0=0x00D0;		{ Dm read                                    }
	ar=ax0 xor ay0;
	if eq jump data_read_;

	ay0=0x00D1;		{ Dm write                                   }
	ar=ax0 xor ay0;
	if eq jump data_write_;

	ay0=0x00D2;		{ Pm read                                    } 
	ar=ax0 xor ay0;		
	if eq jump program_read_;

	ay0=0x00D3;		{ Pm write                                   }
	ar=ax0 xor ay0;
	if eq jump program_write_;

	ay0=0x00D4;		{ Send back PSA-MON string                   }
	ar=ax0 xor ay0;
	if eq jump prog_id_write_; 

	ay0=0x00B4;		{ Start 1848 CODEC                           }
	ar=ax0 xor ay0;
	if eq jump start_sound; 

	ay0=0x00B5;		{ Terminate 1848 CODEC                       }
	ar=ax0 xor ay0;
	if eq jump end_sound; 

	ay0=0x00B0;		{ Start timer                                }
	ar=ax0 xor ay0;
	if eq jump start_timer; 

	ay0=0x00B1;		{ Stop timer                                 }
	ar=ax0 xor ay0;
	if eq jump stop_timer; 

	ay0=0x00BA;	        { Update timer value                         }
	ar=ax0 xor ay0;	      
	if eq jump set_timer; 

	ay0=0x00BB;	        { Update speaker output level                }
	ar=ax0 xor ay0;	      
	if eq jump set_o_lvl; 

	ay0=0x00BC;	        { Update line in level                       }
	ar=ax0 xor ay0;	      
	if eq jump set_i_lvl; 

	ay0=0x00FF;	        { Update modem_select                        }
	ar=ax0 and ay0;		{ first mask off MSB                         }	      

	ay0=0x00BE;	        { Update modem_select                        }
	ar=ar xor ay0;	      
	if eq jump set_modem; 

	ay0=0x00FF;	        { Update databit state                       }
	ar=ax0 and ay0;		{ first mask off MSB                         }	      

	ay0=0x00BD;	        { Update databit state                       }
	ar=ar xor ay0;	      
	if eq jump set_databit; 

	jump loop_;

{--------------------------- Timer ISR --------------------------------------}
{          Also sends new data to PC using an interrupt                      }
timer_int:
	ena sec_reg; 		{ use secondary registers                    }
	ax0=0x1000;
	ay0=dm(data_out);	{ write data out as well                     }
	dm(PSS_data_reg) = ay0;
	dm(PSS_control_reg)=ax0;

	ax0=dm(dither);		{ bypass if no dither                        }
	ar=ax0+0;
	if EQ jump tim_2;

{----------------- Clock dithering ------------------------------------------}
	ax0=dm(timer_period);
	ay0=dm(timing_val);
	ar=ax0-ay0;
	if EQ jump tim_1;
	dm(timer_period)=ay0;
	jump tim_2;
tim_1:
	ar=ay0+1;
	dm(timer_period)=ar;
tim_2:
	dis sec_reg;		{ restore normal registers                   }
	rti;

{-- DSP Basic I/O Routines --------------------------------------------------}
data_read_:
	call get_word_;
	i6 = ax0;
	ax1 = dm(i6,m6);  	{ m6=0                                       }
	call put_word_;
	jump loop_;

data_write_:
	call get_word_;
	i6 = ax0;
	call get_word_;
	dm(i6,m6)=ax0;
	jump loop_;

program_read_:
	call get_word_;
	i6 = ax0;
	ax1 = pm(i6,m6);
	call put_word_;
	ax1 = px;
	call put_word_;
	jump loop_;

program_write_:
	call get_word_;
	i6 = ax0;
	call get_word_;
	px = ax0;
	call get_word_;
	pm(i6,m6)=ax0;
	jump loop_;

get_word_:
	ay0=0x4000;
	ax0=dm(PSS_status_reg);

gwloop:
	ar=ax0 and ay0;
	ax0=dm(PSS_status_reg);
	if eq jump gwloop;
	ax0=dm(PSS_data_reg);
	rts;

put_word_:
	ax0=dm(PSS_status_reg);
	ay0=0x8000;
	ar=ax0 and ay0;
	if eq jump put_word_;
	dm(PSS_data_reg) = ax1;
	rts;

{==================== Async Commands ========================================}
prog_id_write_:
	ax1=0x0050;		{ P }
	call put_word_;
	ax1=0x0053;		{ S }
	call put_word_;
	ax1=0x0041;		{ A }
	call put_word_;
	ax1=0x002D;             { - }
	call put_word_;
	ax1=0x004D;             { M }
	call put_word_;
	ax1=0x004F;             { O }
	call put_word_;
	ax1=0x004E;             { N }
	call put_word_;
	ax1=0x0000;
	call put_word_;
	jump loop_;

{--- 1848 CODEC -------------------------------------------------------------}
start_sound:
	ax0=0xFFFF;
	dm(enable_1848)=ax0;	{ Let DSP access 1848                        }

	i1=BPFI;		{ Pointers and lengths                       }
	l1=32;				
	i2=FILTER;		{ Bandpass filters                           }
	l2=32;
	i3=DATALP;		{ Data low pass filter                       }
	l3=31;

	ax0 = 0x0021; 		{ enable IRQ2 interrupts - for DSP "DMA"     }	 	
	IMASK = ax0;		{ enable TIMER interrupts too                }

	jump loop_;
	
end_sound:
	ax0 = 0x0000; 		{ disable IRQ2 interrupts                    }	 	
	IMASK = ax0;

	ax0=0x0000;		{ get ready to return to the PC              }
	dm(enable_1848)=ax0;	{ Let PC  access 1848                        }

	jump loop_;

{------ Stop/Start TIMER ----------------------------------------------------}
start_timer:	
	ENA TIMER;
	jump	loop_;
stop_timer:
	DIS TIMER;
	jump	loop_;
set_timer:
	call get_word_;
	dm(timer_period)=ax0;
	dm(timing_val)  =ax0;	{ new timing value                           }
	call get_word_;		{ dither parameter                           }
	dm(dither)=ax0;
	jump	loop_;

{------ Sound Card Audio levels ---------------------------------------------}
{------ Speaker output ------------------------------------------------------}
set_o_lvl:
	 			{ Reminder that 8-bit data is just left      }
	call get_word_;
	ar=0x0600;		{ DAC level is regs 6/7                      }
	dm(addr_1848)=ar;
	dm(data_1848)=ax0;	{ new level                                  }

	ar=0x0700;
	dm(addr_1848)=ar;
	dm(data_1848)=ax0;
	jump	loop_;

{------ Audio input level ---------------------------------------------------}
set_i_lvl:
	 			{ Reminder that 8-bit data is just left      }
	call get_word_;
	ar=0x0000;		{ DAC level is regs 0/1                      }
	dm(addr_1848)=ar;
	dm(data_1848)=ax0;	{ new level                                  }

	ar=0x0100;
	dm(addr_1848)=ar;
	dm(data_1848)=ax0;
	jump	loop_;

{------ AFSK state ----------------------------------------------------------}
set_databit:	 		{ set databit state                          }
	ay0=0xFF00;
	ar=ax0 and ay0;		{ first mask off LSB                         }
	si=ar;	       		{ shift right 8 bits                         }
	sr=LSHIFT si by -8 (HI);	      
	dm(databit)=sr1;
	jump	loop_;

{------ Select 100/200 baud modem -------------------------------------------}
set_modem:	 		{ set modem_select                           }
	ay0=0xFF00;
	ar=ax0 and ay0;		{ first mask off LSB                         }
	dm(modem_select)=ar;
	jump	loop_;
	
	nop;	  		{ For good measure                           }
	nop;
{====================== END OF DSP RTE ======================================}

