//pad.cpp - C++ program to calculate attenuator 
//resistances and power dissipation
//
// N1BWT 1/94
// compiled with Borland C++ version 3.1

#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include <ctype.h>

class Attenuator
{
public:
	Attenuator();
	float a()   { return ra; };       // end resistors
	float b()   { return rb; };       // middle resistor
	float c()   { return rc; };       // bridged-T resistors
	float p1()  { return tp1; };      // power in first T resistor
        float p2()  { return tp2; };      // power in second T resistor
	float p3()  { return tp3; };      // power in third T resistor
	float p4()  { return tp4; };      // power in bridge resistor

	void calc(float);	        // calculations for T and pi
	void bridge(float);             // calculations for bridged-T

private:
        float ra;
	float rb;
        float rc;
	float tp1;
	float tp2;
        float tp3;
	float tp4;
};

Attenuator::Attenuator()
{       // Constructor
    ra = 0;
    rb = 999999;
    rc = 0;
    tp1 = 0;
    tp2 = 0;
    tp3 = 0;
    tp4 = 0;
}


void Attenuator::calc(float loss)
{       // calculations for T and pi attenuators
    double tmp;

    tmp = pow(10,(loss/20));

    ra = (tmp - 1) / (tmp + 1);

    rb = 2 * tmp / ( pow(10,(loss/10)) - 1 ) ;

//    rc = tmp - 1;

// power: same for pi and T, so calculate for pi  (R = 1/rx)
// assume one volt in, so P(R1) = V**2/R1 = 1/R1 = ra
// since we know the power at the output
// we know the voltage across the other two resistors

    double Vout;

    Vout = pow(10,(-loss/20));

    tp1 = 100 * ra;
    tp3 = 100 * Vout * Vout * ra;
    tp2 = 100 * (1 - Vout)*(1 - Vout) * rb;

 //   cout << "Vout = " << Vout << endl;
}

void Attenuator::bridge(float loss)
{
    double tmp;

    tmp = pow(10,(loss/20));

    rc = tmp - 1;

// assume one volt in, Zo = 1;

    double Vout;
    double iout, i1, i2, i3, i4;
    
    Vout = pow(10,(-loss/20));

    iout = Vout;        // only for readability, since r=1
    
    i4 = (1 - Vout) / rc;
    
    tp4 = 100 * i4 * i4 * rc;

    i3 = iout - i4;

    tp3 = 100 * i3 * i3;

    i1 = 1 - i4;

    tp1 = 100 * i1 * i1;

    tp2 = 100 * (i1 - i3) * (i1 - i3) / rc;      // r2 = 1/rc
}


// forward declarations
void pad_out(float, float);
void pad_header();
void bridge_out(float, float);
void bridge_header();
void one_pad();
void pad_table();

main()
{
    cout << " PAD.CPP - calculates resistance and power dissipation \n"
	 << "           for common attenuators. \n\n"
	 << " N1BWT 1994 \n\n";

    char mode = 'x';
    
    while ( mode != 'T' &&  mode != 'P')
    {
	cout << "\n"
	  << "Enter T for attenuator table, P for specific value: ";
	cin >> mode;
	mode = toupper(mode);
    }

    switch(mode)
    {
	case 'P':
	    one_pad();
	    break;
	case 'T':
	    pad_table();
	    break;
	default:
	    cout  << "Huh?";
    }

    return 0;
}

void one_pad()
{
    float Zo;
    float loss;

    cout << "\n" << "Enter characteristic impedance: ";
    cin >> Zo;

    cout << "\n" << "Desired attenuation? ";
    cin >> loss;

    pad_header();
    
    pad_out(loss, Zo);

    bridge_header();
    
    bridge_out(loss,Zo);
}

void pad_table()
{
    float Zo;
    float loss;
    float initial;
    float increment;
    char type;

    cout << "\n" << "Enter characteristic impedance: ";
    cin >> Zo;

    cout << "\n" << "Desired starting attenuation value? ";
    cin >> initial;

    cout << "\n" << "Desired increment? ";
    cin >> increment;

    cout << "\n" << "Configuration: Enter T for T and pi, B for Bridged-T: ";
    cin >> type;  
    type = toupper(type);    
 
    if (type == 'B')
    {
        bridge_header();

	for (int i = 0; i < 10; i++)
	    bridge_out((initial + i * increment), Zo);
    }
    else
    {
	pad_header();

	for (int i = 0; i < 15; i++)
            pad_out((initial + i * increment), Zo);
    }
}
    
void pad_header()
{
    cout << "\n  T and pi attenuator \n\n";
    cout << " Loss           T                    pi        "
	 << "  Power dissipation \n";
    cout << "  dB     R1,R3       R2      R1,R3       R2     "
	 << " R1       R2       R3 \n";
    cout << " ---     -----     -----     -----      -----   "
         << "-----    -----    ----- \n";     
}

void pad_out(float loss, float Zo)
{    
    Attenuator pad;

    pad.calc(loss);


    cout << setprecision(1)
     //	 << "  "
	 << setw(4)
	 << loss
	 << "   "
	 << setw(7)
	 << setprecision(2)
	 << ( Zo * pad.a())
	 << "   "
	 << setw(7)
	 << ( Zo * pad.b())
	 << "   "
	 << setw(7)
	 << ( Zo /pad.a())
	 << "   "
	 << setw(7)
	 << ( Zo /pad.b())
	 << "   "
	 << setprecision(1)
	 << setw(5)
	 << pad.p1()
	 << "%   "
	 << setw(5)
	 << pad.p2()
	 << "%   "
	 << setw(5)
	 << pad.p3()
	 << "%   "
	 << "\n";
}

void bridge_header()
{
    cout << " \n";
    cout << " Bridged-T Attenuator       ------R4-----       \n";
    cout << "                           |             |      \n";
    cout << "   R1 = R3 = Zo           -+--R1--+--R3--+--    \n";
    cout << "                                  |            \n";
    cout << "                                  R2           \n";
    cout << "                                  |            \n";
    cout << "                                  V            \n\n";
    cout << " Loss      Resistance     "
	 << "       Power dissipation \n";
    cout << "  dB      R2         R4      "
	 << " R1       R2       R3       R4\n";
    cout << " ---     -----     -----     "
         << "-----    -----    -----    -----\n"; 
}    
 
void bridge_out(float loss, float Zo)
{    
    Attenuator pad;

    pad.bridge(loss);


    cout << setprecision(1)
     //	 << "  "
	 << setw(4)
	 << loss
	 << "   "
	 << setw(7)
	 << setprecision(2)
	 << ( Zo * pad.c())
	 << "   "
	 << setw(7)
	 << ( Zo /pad.c())
	 << "   "
	 << setprecision(1)
	 << setw(5)
	 << pad.p1()
	 << "%   "
	 << setw(5)
	 << pad.p2()
	 << "%   "
	 << setw(5)
	 << pad.p3()
	 << "%   "
	 << setw(5)
	 << pad.p4()
	 << "%   "
	 << "\n";
}
