 '  THE PROGRAM FILES MORSE.EXE, MORSE.BAS AND CW.DAT ("THE SOFTWARE") ARE
 '  OWNED BY VE2HOT.  THE PROGRAM OWNER HEREBY ALLOWS YOU TO:
 '
 '      1) USE THE SOFTWARE
 '      2) MAKE AS MANY COPIES OF THE SOFTWARE AS YOU WISH
 '      3) GIVE COPIES OF THE SOTWARE TO ANYONE
 '      4) DISTRIBUTE THE SOFTWARE VIA ELECTRONIC MEANS
 '
 '  YOU  ARE  SPECIFICALLY    PROHIBITED   FROM  CHARGING,  OR  REQUESTING
 '  DONATIONS, FOR ANY SUCH  COPIES,  HOWEVER MADE;  AND FROM DISTRIBUTING
 '  THE SOFTWARE WITH COMMERCIAL PRODUCTS  WITHOUT  PRIOR  PERMISSION.  NO
 '  ONE IS AUTHORIZED TO CHARGE ANY  AMOUNT  FOR DISTRIBUTION OF COPIES OF
 '  THE SOFTWARE, OR TO INCLUDE COPIES OF THE SOFTWARE WITH SALES OF THEIR
 '  OWN PRODUCTS.  THIS NOTICE MAY NOT BE REMOVED OR MODIFIED IN ANY WAY.
 '
 '  THERE IS NO WARRANTY OF ANY KIND.   IN  NO  EVENT  SHALL  THE SOFTWARE
 '  OWNER BE LIABLE FOR ANY DAMAGES, DIRECT OR CONSEQUENTIAL,  ARISING OUT
 '  OF THE USE OF OR INABILITY TO USE THIS PRODUCT, EVEN IF THE AUTHOR HAS
 '  BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  BY USING  THIS  FREE
 '  SOFTWARE, YOU AGREE TO THIS.
 '
10 '-----------------------------------------------------------------
20 '      C O N S T A N T S    A N D     D E F I N I T I O N S
30 '-----------------------------------------------------------------
35 CLS
40 PRINT ""
50 PRINT "TEXT to CW to EPROM conversion program          Dec 1990"
60 PRINT "Written for Nick Ciarallo [VE2HOT] by K.C. Ng Ching Hing"
70 PRINT "________________________________________________________"
80 PRINT ""
90 PRINT "Initializing. Please wait..."
100 MAXBITS% = 7
110 MAXSTRING% = 4000                  'number of bits in string
120 NULL% = -32768!                    'flag for commands
130 DIM ASCII$(127)                    'ascii code lookup table
140 DIM S%(MAXBITS%, MAXSTRING%)       'bit array 1
150 DIM COMMMANDFLAG%(MAXBITS%)        'array of command flags, one per line
160 DIM CURRADDR%(MAXBITS%)            'current bit in eprom
170 FALSE% = 0
180 TRUE% = -1
190 DATATOKEN$ = "data"                'string signifying data follows in input file
200 ESC$ = "\"                         'escape character
210 INTERACTIVE% = FALSE%
220 DATAFILE$ = "cw.dat"
230 BINFILE$ = "cw.bin"                'default output file in binary
240 HEXFILE$ = "cw.hex"                'default output file in hexadecimal
250 AUDITFILE$ = "cw.aud"              'default output file in text form for audit
260 ASCIIFILE$ = "data.txt"            'default
270 '------------------------------------------------------------------
280 '             I N I T I A L I Z E    T H E    D A T A
290 '------------------------------------------------------------------
300 OPEN DATAFILE$ FOR INPUT AS #1
310 FOR I% = 1 TO 127                       'initialise the array
320    ASCII$(I%) = ""
330 NEXT
340 LIN% = 1                                'line number we are at
350 WHILE NOT EOF(1)                        'read the data file
360    LINE INPUT #1, S$
370    F$ = LEFT$(S$, 1)                    'first character in string
380    IF (F$ <> "") THEN GOTO 390 ELSE GOTO 500
390   'do
400       I% = ASC(F$)                      'save table index
410       A$ = MID$(S$, 2)                  'get next character
420       F$ = LEFT$(A$, 1)
430       WHILE (ASC(F$) <= ASC(" ")) OR (ASC(F$) > ASC("~")) 'skip blank characters
440          A$ = MID$(A$, 2)
450          F$ = LEFT$(A$, 1)
460          IF LEN(F$) = 0 THEN PRINT "error: invalid line in data file,"; DATAFILE$; " line"; LIN%, : GOTO 3540
470       WEND
480       ASCII$(I%) = A$
490      LIN% = LIN% + 1
500   'end if
510 WEND
520 CLOSE #1
530 PRINT ""
540 PRINT "Program start..."
550 PRINT ""
560 LINE INPUT "Enter filename to convert > "; A$
570 GOSUB 2760                         'extract name from file
580 ASCIIFILE$ = FILENAME$ + EXT$
590 OPEN ASCIIFILE$ FOR INPUT AS #2
600 PRINT "Converting text..."
610 '------------------------------------------------------------------
620 '       S T A R T    T O    C O N V E R T    T H E    T E X T
630 '------------------------------------------------------------------
640 'get user input
650  IF INTERACTIVE% = TRUE% THEN GOTO 660 ELSE GOTO 690
660 'do
670     PRINT "enter text > ";             'prompt
680     GOSUB 1200                         'my version of input a$
690 'endif
700  DONE% = FALSE%
710  FOR CURRLINE% = 0 TO MAXBITS%
720     CURRADDR%(CURRLINE%) = 1           'init bit position in s%
730  NEXT
740  CURRLINE% = 0                         'default: text is placed on this bit line
750  A$ = " "
760  WHILE (LEFT$(A$, 1) <> CHR$(27)) AND NOT EOF(2)
770     IF INTERACTIVE% = FALSE% THEN GOTO 780 ELSE GOTO 800
780    'do
790        LINE INPUT #2, A$
800    'endif
810     POSITION% = 1                       'first character in string
820     LENGTH = LEN(A$)
830     WHILE POSITION% <= LENGTH
840        CH% = ASC(MID$(A$, POSITION%, 1))'get the character in the table ascii$
850        IF (CH% >= ASC("a")) AND (CH% <= ASC("z")) THEN CH% = CH% - ASC("a") + ASC("A") ' convert to upper case
860        IF (CH% = ASC(ESC$)) THEN GOTO 870 ELSE GOTO 900 ' a command is present ?
870       'do                              'process command
880           GOSUB 2250                   'see what kind od command
890           GOTO 920
900       'else                            'process text
910           GOSUB 1650                   'scan database string and convert to bits
920       'endif
930        POSITION% = POSITION% + 1            'next character in user input
940     WEND                                    'for each string
950     IF INTERACTIVE% = TRUE% THEN GOTO 960 ELSE GOTO 1000
960    'do
970        PRINT "enter text > ";          'prompt
980        GOSUB 1200                      'line input from keyboard
990        GOTO 1000
1000    'endif
1010  WEND
1020  CLOSE #1
1030  CLOSE #2
1040  GOSUB 2680                            'find largest address
1050  A$ = " "
1060  WHILE (LEFT$(A$, 1) <> CHR$(27))
1070     INPUT "Do you want sound? (y/n) >", A$
1080     IF (A$ = "Y") OR (A$ = "y") THEN GOSUB 1510 ELSE A$ = CHR$(27) 'execute sound procedure
1090  WEND
1100  PRINT "Writing output files..."
1110  GOSUB 2940                            'write data in binary
1120  GOSUB 3090                            'write data in hex
1130  GOSUB 3260                            'write data in ascii
1140  IF INTERACTIVE% = TRUE% THEN PRINT
1150  PRINT "End of program"
1160  GOTO 3540
1170 '*****************************************************************
1180 '            E N D    O F    P R O G R A M    H E R E.
1190 '*****************************************************************
1200 '-----------------------------------------------------------------
1210 '               Subroutine to read the keyboard
1220 ' Includes backspaces.
1230 '-----------------------------------------------------------------
1240 STARTPOS% = POS(X)
1250 CH$ = ""
1260 CH% = 0
1270 A$ = ""
1280 QUIT = FALSE%
1290 WHILE NOT QUIT
1300    CH$ = INKEY$                        'get keyboard input
1310    ON LEN(CH$) + 1 GOTO 1490, 1320, 1470
1320   'regular keys
1330    CH% = ASC(CH$)
1340    IF CH% = 27 THEN QUIT = TRUE%: A$ = CH$: GOTO 1490 'user quits
1350    IF CH% = 13 THEN QUIT = TRUE%: GOTO 1380           'end of line
1360    IF CH% = 8 THEN GOTO 1400                          'backspace
1370    A$ = A$ + CH$
1380    PRINT CH$;                          'print character etc
1390    GOTO 1490
1400    IF POS(X) <= STARTPOS% THEN GOTO 1490
1410    LOCATE , POS(X) - 1                 'step back 1 character
1420    A$ = LEFT$(A$, LEN(A$) - 1)         'reduce string
1430    PRINT " ";                          'write a blank
1440    IF POS(X) < STARTPOS% THEN GOTO 1490
1450    LOCATE , POS(X) - 1                 'step back 1 character
1460    GOTO 1490
1470   'function keys
1480    GOTO 1490
1490 WEND
1500 RETURN
1510 '-----------------------------------------------------------------
1520 '      Subroutine to translate string into morse code (sound)
1530 '-----------------------------------------------------------------
1540 TONE% = 800
1550 DURATION% = 1!                        'seconds to sound speaker
1560 INPUT "Bit number to play ? (0..7) >", CURRLINE%
1570 IF (CURRLINE% >= 0) AND (CURRLINE% <= 7) THEN GOTO 1580 ELSE GOTO 1560
1580 IF CURRADDR%(CURRLINE%) = 0 THEN PRINT "No data for that bit": GOTO 1640
1590 FOR ADDR% = 0 TO CURRADDR%(CURRLINE%)
1600    VALUE% = S%(CURRLINE%, ADDR%)
1610    IF VALUE% = 1 THEN SOUND TONE%, DURATION%
1620    IF VALUE% = 0 THEN SOUND 32767, DURATION% 'sound nothing
1630 NEXT
1640 RETURN
1650 '-----------------------------------------------------------------
1660 '       Subroutine to convert ASCII to morse code in bits.
1670 ' The value of the character is stored in a table.  The table is
1680 ' encoded as 0 = a dit and 1 = a dah.
1690 ' Dits are one bit long (high).  Dahs are three bits long (high).
1700 ' The spacing between characters is 3 bits long (low).  The spacing
1710 ' between dits and dahs is 1 bit long (low).
1720 '    (a) If not first item in string, write space between characters.
1730 '    (b) Scan database table. (ASCII$)
1740 '        If 0 then
1750 '           if not first bit then write a 0
1760 '           write a dit
1770 '        else
1780 '           if not first bit then write a 0
1790 '           write a dah
1800 '-----------------------------------------------------------------
1810  IF (CURRADDR%(CURRLINE%) > 1) OR (CH% = ASC(" ")) GOTO 1820 ELSE GOTO 1870'determine if we should add spaces or not
1820 'do
1830  FOR J% = 0 TO 2                       'write sbc
1840     BITVALUE% = 0                      'fill with zeros
1850     GOSUB 2560                         'process this address
1860  NEXT
1870 'endif
1880  P% = 1
1890  L% = LEN(ASCII$(CH%))
1900  IF L% > 0 THEN GOTO 1910 ELSE GOTO 2230
1910  'do
1920  FIRST% = TRUE%                    'are we doing first bit in character?
1930  WHILE P% <= L%              'scan through the string held in ascii$(ch)
1940     V$ = LEFT$(MID$(ASCII$(CH%), P%), 1)
1950     IF V$ = "0" THEN GOTO 1960 ELSE GOTO 2060    'it's a dit
1960    'do
1970        IF FIRST% = FALSE% THEN GOTO 1980 ELSE GOTO 2010
1980        'do
1990           BITVALUE% = 0                'write interval
2000           GOSUB 2560                   'process this address
2010        'endif
2020        BITVALUE% = 1                   'write bit
2030        GOSUB 2560                      'process this address
2040        FIRST% = FALSE%
2050        GOTO 2200
2060    'else
2070        IF V$ = "1" THEN GOTO 2080 ELSE GOTO 2190   'it's a dah
2080       'do
2090           IF FIRST% = FALSE% THEN GOTO 2100 ELSE GOTO 2130
2100          'do
2110              BITVALUE% = 0             'write interval
2120              GOSUB 2560                'process this address
2130          'endif
2140           FOR J% = 0 TO 2
2150              BITVALUE% = 1             'write a bit
2160              GOSUB 2560                'process this address
2170           NEXT
2180           FIRST% = FALSE%
2190       'end if
2200    'end if
2210     P% = P% + 1                        'move to next pos
2220  WEND                                  'for each character.
2230 'endif
2240 RETURN
2250 '-----------------------------------------------------------------
2260 '                  Subroutine to process a command.
2270 '-----------------------------------------------------------------
2280 POSITION% = POSITION% + 1              'get the line num
2290 LINENUMBER% = ASC(MID$(A$, POSITION%, 1)) - ASC("0")
2300 POSITION% = POSITION% + 1              'get the first item
2310 CH$ = MID$(A$, POSITION%, 1)
2320 VALUE% = 0                             'default value
2330 V$ = ""                                'command string
2340 WHILE CH$ <> ESC$
2350    IF (CH$ <> " ") AND (CH$ <> ",") AND (CH$ <> CHR$(9)) THEN GOTO 2360 ELSE GOTO 2440
2360    'do
2370       IF ASC(CH$) >= ASC("0") AND ASC(CH$) <= ASC("9") THEN GOTO 2380 ELSE GOTO 2410
2380       'do
2390          VALUE% = VALUE% * 10 + ASC(CH$) - ASC("0")'convert string to integer
2400          GOTO 2430
2410       'else
2420          V$ = V$ + CH$                 'build command string
2430       'endif
2440    'endif
2450    POSITION% = POSITION% + 1           'get the next item
2460    CH$ = MID$(A$, POSITION%, 1)
2470 WEND
2480 IF V$ = DATATOKEN$ THEN GOTO 2490 ELSE GOTO 2520
2490 'do
2500    CURRLINE% = LINENUMBER%             'the user requested this line
2510    GOTO 2540
2520 'else
2530    IF VALUE% > 0 THEN COMMMANDFLAG%(LINENUMBER%) = 1 ELSE COMMMANDFLAG%(LINENUMBER%) = 0
2540 'endif
2550 RETURN
2560 '-----------------------------------------------------------------
2570 '               Subroutine to process an address.
2580 '  (a) Update the bit.
2590 '  (b) Find out if there is a command to execute.
2600 '  (c) Go to next address.
2610 '-----------------------------------------------------------------
2620 S%(CURRLINE%, CURRADDR%(CURRLINE%)) = BITVALUE%
2630 FOR LINENUMBER% = 0 TO MAXBITS%
2640    IF COMMMANDFLAG%(LINENUMBER%) = 1 THEN S%(LINENUMBER%, CURRADDR%(CURRLINE%)) = 1
2650 NEXT
2660 CURRADDR%(CURRLINE%) = CURRADDR%(CURRLINE%) + 1    'next address
2670 RETURN
2680 '-----------------------------------------------------------------
2690 '           Subroutine to calculate the maximum address.
2700 '-----------------------------------------------------------------
2710 MAXADDR% = 0 'maximum address to write to
2720 FOR I% = 0 TO MAXBITS%
2730    IF CURRADDR%(I%) > MAXADDR% THEN MAXADDR% = CURRADDR%(I%)
2740 NEXT
2750 RETURN
2760 '-----------------------------------------------------------------
2770 '   Find the name of text file and extract it from the full name
2780 '-----------------------------------------------------------------
2790 FOR P = 1 TO LEN(A$)
2800    IF MID$(A$, P, 1) = "." THEN GOTO 2820
2810 NEXT
2820 IF P < LEN(A$) + 1 THEN GOTO 2830 ELSE GOTO 2870   'a dot has been found
2830 'do
2840    FILENAME$ = LEFT$(A$, P - 1)
2850    EXT$ = RIGHT$(A$, LEN(A$) - P + 1)
2860    GOTO 2890
2870 'else
2880    FILENAME$ = LEFT$(A$, 8)
2890 'endif
2900 BINFILE$ = FILENAME$ + ".bin"
2910 HEXFILE$ = FILENAME$ + ".hex"
2920 AUDITFILE$ = FILENAME$ + ".aud"
2930 RETURN
2940 '-----------------------------------------------------------------
2950 '          All data has been read. Write bytes to a file.
2960 '  #3 is a binary file
2970 '-----------------------------------------------------------------
2980 PRINT "BIN file"
2990 OPEN BINFILE$ FOR OUTPUT AS #3
3000 FOR ADDR% = 1 TO MAXADDR% - 1
3010    VALUE% = 0
3020    FOR BIT% = MAXBITS% TO 0 STEP -1
3030       VALUE% = VALUE% * 2 + S%(BIT%, ADDR%)
3040    NEXT
3050    PRINT #3, USING "&"; CHR$(VALUE%);
3060 NEXT
3070 CLOSE #3
3080 RETURN
3090 '-----------------------------------------------------------------
3100 '  Write bytes to a file. #3 is in hex file format
3110 '-----------------------------------------------------------------
3120 PRINT "HEX file"
3130 OPEN HEXFILE$ FOR OUTPUT AS #3
3140 COUNT% = 1
3150 FOR ADDR% = 1 TO MAXADDR% - 1
3160    VALUE% = 0
3170    FOR BIT% = MAXBITS% TO 0 STEP -1
3180       VALUE% = VALUE% * 2 + S%(BIT%, ADDR%)
3190    NEXT
3200    V$ = HEX$(VALUE%)
3210    IF LEN(V$) < 2 THEN PRINT #3, USING "#& "; 0; V$;  ELSE PRINT #3, USING "& "; V$;
3220    IF COUNT% = 16 THEN PRINT #3, : COUNT% = 1 ELSE COUNT% = COUNT% + 1
3230 NEXT
3240 CLOSE #3
3250 RETURN
3260 '-----------------------------------------------------------------
3270 '  Write bytes to a file. #3 is a text file providing an audit trail
3280 '-----------------------------------------------------------------
3290 PRINT "AUD file"
3300 OPEN AUDITFILE$ FOR OUTPUT AS #3
3310 FOR ADDR% = 1 TO MAXADDR% - 1
3320    VALUE% = 0
3330    FOR BIT% = MAXBITS% TO 0 STEP -1
3340       VALUE% = VALUE% * 2 + S%(BIT%, ADDR%)
3350       PRINT #3, USING "#"; S%(BIT%, ADDR%);
3360    NEXT
3370    PRINT #3,
3380 NEXT
3390 CLOSE #3
3400 RETURN
3410 '-----------------------------------------------------------------
3420 ' Subroutine for debugging.
3430 '    Print a dump of s% on the screen
3440 '-----------------------------------------------------------------
3450 PRINT "String = "
3460 FOR BIT% = 0 TO MAXBITS%
3470    A$ = ""
3480    FOR ADDR% = 1 TO CURRADDR%(CURRLINE%) - 1
3490       A$ = A$ + STR$(S%(BIT%, ADDR%))
3500    NEXT
3510    PRINT A$
3520 NEXT
3530 RETURN
3540 END

