' Modify IRFD circuit files contining crystal-ladder filters
' to add tuning capacitors for offset crystal frequencies.
'
' From "Designing and Building High-Performance Crystal Ladder
' Filters," QEX, January, 1995
'
' J. Bloom, KE3Z
' 12/08/94
'
' Note: Little checking of the input file is performed. Only files
' written by the IRFD program "X" should be used as input files.

CLS
PRINT "CLFMOD -- Modifies IRFD ladder crystal filter circuit files for tuning"
PRINT
INPUT "Enter name of original circuit file: ", f1$
OPEN f1$ FOR INPUT AS #1
INPUT "Enter name of output circuit file: ", f2$
OPEN f2$ FOR OUTPUT AS #2
OPEN "OFFSETS.CLF" FOR OUTPUT AS #3
' Get the number of circuit elements
INPUT #1, x
N = (x - 2) / 2      ' Number of poles
' Write the new number of circuit elements, including tuning caps
PRINT #2, N * 3 + 2
' Copy the unchanging parameters
FOR i = 1 TO 14
   INPUT #1, x
   PRINT #2, x
NEXT i
' Loop through each of the meshes, annotating the elements with
' component designators as in Fig 9, adding the tuning capacitors,
' and replacing the crystal offset frequencies with those of the
' real crystals.
FOR i = 0 TO N - 1
   ' Coupling capacitor
   INPUT #1, x$
   PRINT #2, x$, LEFT$(x$, 1) + MID$(STR$(i * 3 + 1), 2)
   INPUT #1, x$
   PRINT #2, x$
   INPUT #1, x
   PRINT #2, x
   ' Crystal
   INPUT #1, x$
   y$ = LEFT$(x$, 1) + MID$(STR$(i * 3 + 2), 2)
   PRINT #2, x$, y$
   INPUT #1, x$
   PRINT #2, x$
   INPUT #1, x
   PRINT "Crystal"; i + 1; "("; y$;
   INPUT ") delta F: ", y
   PRINT #2, y
   PRINT "Target offset frequency for mesh"; i + 1; "= "; x - y
   PRINT #3, x - y
   ' Tuning capacitor
   PRINT #2, "cap", "c" + MID$(STR$(i * 3 + 3), 2)
   PRINT #2, "ser"
   PRINT #2, 200
NEXT i
' Load end coupling capacitor
INPUT #1, x$
PRINT #2, x$, LEFT$(x$, 1) + MID$(STR$(N * 3 + 1), 2)
INPUT #1, x$
PRINT #2, x$
INPUT #1, x
PRINT #2, x
' Should only be one line left, but "just in case," copy to
' end of file
WHILE NOT EOF(1)
   LINE INPUT #1, x$
   PRINT #2, x$
WEND
' Clean up and exit
CLOSE
SYSTEM

