REM  DISHFEED.BAS  ver 1.0                      28 Dec 95    RSL
REM
REM  QBasic program to calculate the efficiency of a parabola as a
REM  function of the feed amplitude characteristics and the f/d of
REM  the dish. Reads the feed amplitude function from a file that has
REM  19 lines corresponding to the dB gain from 0 deg (1st line) to
REM  180 deg (19th line.)  This feed characteristic is assumed to be
REM  axially symmetric so it can be described by a table of numbers from
REM  0 to 180 degrees.  Entries are every 10 degrees and are interpolated
REM  cubicly for integration.
REM
REM  Reference: C. C. Cutler, Parabolic-Antenna Design for Microwaves,
REM             Proceedings of IRE, vol 35, pp1284-1294, Nov 1947
REM  Assumptions:
REM      1 - Amplitude response of feed is axially symmetric for 1 input file
REM          or can be approximated by power average of two patterns for the
REM          two file case.
REM      2 - There are no phase errors from feed.
REM      3 - Diffraction at the dish edge can be ignored (very questionable).
REM      4 - The feed pattern can be described by 10 deg samples.
REM
REM  Also included is a calculation for the (cos x)^n pattern that is often
REM  used as model for dish feeds.
REM
REM  Copyright (C) 1995  Bob Larkin, W7PUA,  boblark@delphi.com
REM  For free use by amateur radio operators for amateur purposes.
REM
REM  Note: this program is not user friendly.  Input errors are not checked.
REM  Also some of the instructions may be in the program as REM's.

DIM FEED#(20), IFEED#(180), ETA#(17), ETAS#(17), ETAI#(17), C#(4, 5)
DIM IN1#(180), IN2#(180)
PI# = 3.14159265359#

REM Either 1 or 2 files can be used to supply data.  The 2 file case
REM is for E-plane & H-plane patterns and these are then averaged in power.
REM This is a good approximation to a full 2 dim integration for
REM dish feed antennas.
REM The 1 file case should be used if only an E-plane or an
REM H-plane cut is available.
REM Files should have 19 entries on separate lines.  The values should be
REM in dB attenuation relative to the peak gain of the feed.  Thus, there
REM should be a 0.0 entry somewhere and no entries should be negative.

INPUT "Enter the number of files for data, 1 or 2, or 3 for cos feeds"; NF%
IF NF% = 1 THEN GOTO GET1
IF NF% = 3 THEN GOTO COSFEEDS
INPUT "Input file name 1, with path and extension, for feed data"; NAMEF1$
OPEN NAMEF1$ FOR INPUT AS #1
INPUT "Input file name 2, with path and extension, for feed data"; NAMEF2$
OPEN NAMEF2$ FOR INPUT AS #2

FOR I% = 1 TO 19
   INPUT #1, FEED1#
   PF1# = 10# ^ (-FEED1# / 10#)
   INPUT #2, FEED2#
   PF2# = 10# ^ (-FEED2# / 10#)
   FEED#(I%) = -4.3429448# * LOG(PF1# + PF2#) + 3.01029996#
NEXT I%
GOTO GOTEM

GET1:
INPUT "Input file name, including path and extension, for feed data"; NAMEF$
OPEN NAMEF$ FOR INPUT AS #1
FOR I% = 1 TO 19
   INPUT #1, FEED#(I%)
NEXT I%

GOTEM:
FOR I% = 1 TO 19
    FEED#(I%) = 10# ^ (-FEED#(I%) / 20#)'Convert to Voltage magnitude
NEXT I%

FEED#(0) = FEED#(2)    'Provides symmetry at the axis for interpolation
FEED#(20) = FEED#(18)  'This does it at 180 degrees as well

REM Next interpolate 18 times by fitting a cubic through adjacent 4 points
REM and interpolating the polynomial at each degree.
FOR I% = 1 TO 18   'Over all 10 degree sectors
    REM For numerical accuracy, we will always consider angle as (-10, 20)
    FOR J% = 1 TO 4   'Over 4 data points
	C#(J%, 1) = 1
	FOR K% = 2 TO 4  '3 coefficients per equation
	    C#(J%, K%) = (10# * (J% - 2)) ^ (K% - 1)
	NEXT K%
	C#(J%, 5) = FEED#(I% + J% - 2)
    NEXT J%

    REM Now solve simultaneous equations
    FOR J% = 1 TO 4
	FOR L% = J% TO 4
	    IF ABS(C#(L%, J%)) > 1E-10 THEN GOTO NONZ
	NEXT L%
NONZ:        FOR K% = 1 TO 5
	    X# = C#(J%, K%)
	    C#(J%, K%) = C#(L%, K%)
	    C#(L%, K%) = X#
	NEXT K%
	Y# = 1# / C#(J%, J%)
	FOR K% = 1 TO 5
	    C#(J%, K%) = Y# * C#(J%, K%)
	NEXT K%
	FOR L% = 1 TO 4
	    IF L% = J% THEN GOTO LUP
	    Y# = -C#(L%, J%)
	    FOR K% = 1 TO 5
		C#(L%, K%) = C#(L%, K%) + Y# * C#(J%, K%)
	    NEXT K%
LUP:     NEXT L%
    NEXT J%
    REM  Now interpolate to each degree point
    FOR J% = 0 TO 10
	AJ# = J%
	V# = C#(1, 5) + C#(2, 5) * AJ# + C#(3, 5) * AJ# ^ 2
	V# = V# + C#(4, 5) * AJ# ^ 3
	REM Take care of polynomial approximation near zero:
	IF V# < 0# THEN V# = -V#
	IFEED#(10 * (I% - 1) + J%) = V#
    NEXT J%
NEXT I%

DOINT:
REM  Now integrate the interpolated curves to find the antenna efficiencies
REM  Collect integrands, U*tan(theta/2) and U^2 * sin(theta) in IN1(), IN2().
REM  Note that integration period 1 is 0 to 1 degrees and is centered on 0.5
REM  degrees.
DENOM# = 0#
FOR I% = 1 TO 180
    U# = .5# * (IFEED#(I% - 1) + IFEED#(I%))
    THETA# = PI# * (I% - .5) / 180#
    HTHETA# = .5# * THETA#
    IN1#(I%) = U# * TAN(HTHETA#)
    IN2#(I%) = U# * U# * SIN(THETA#)
    DENOM# = DENOM# + IN2#(I%)
NEXT I%

DENOM# = PI# * DENOM# / 180#   'Scale to be an area
PRINT
PRINT "I. eff = Illumination efficiency, S. eff = Spillover efficiency"
FOR TH1% = 20 TO 90 STEP 5  'The half angle subtended by dish
    NUM# = 0#
    FOR I% = 1 TO TH1%
	NUM# = NUM# + IN1#(I%)
    NEXT I%
    NUM# = PI# * NUM# / 180#

    DENI# = 0#
    FOR I% = 1 TO TH1%
	DENI# = DENI# + IN2#(I%)
    NEXT I%
    DENI# = PI# * DENI# / 180#

    K# = 2# / ((TAN(PI# * TH1% / 360#)) ^ 2)
    FOD# = 1# / (4# * TAN(PI# * TH1% / 360#))
    ETA# = K# * NUM# * NUM# / DENOM#
    EI# = K# * NUM# * NUM# / DENI#
    ES# = ETA# / EI#
    PRINT USING "Half Angle=## deg, F/D=#.### "; TH1%; FOD#;
    PRINT USING "Feed=###.#dB  "; 8.68589 * LOG(IFEED#(TH1%));
    PRINT USING "Eff=#.### I. eff=#.### S. eff=#.###"; ETA#; EI#; ES#
NEXT TH1%
INPUT "Enter to continue"; ZZ$
STOP

COSFEEDS:
PRINT
PRINT "This is an example feed that is the cosine of the angle made with the"
PRINT "feed axis, raised to an exponent that can be any value (not just"
PRINT "integers.)  The cosine function is used out to it's zero at 90 degrees"
PRINT "after which the feed pattern has zero power.  See S.Silver, Microwave"
PRINT "Antenna Theory and Design, (Rad Lab Vol 12), McGraw Hill 1949,"
PRINT "pp 425-427."
INPUT "Input exponent value n "; N2#
N2V# = N2# / 2#'The N2# is a power function, but in this program we want volts
FOR I% = 1 TO 90
    IFEED#(I%) = (COS(PI# * (I% - .5) / 180#)) ^ N2V#
    IF 5 * INT(I% / 5) = I% THEN GOSUB DOPR
NEXT I%
FOR I% = 91 TO 180
    IFEED#(I%) = 0#
NEXT I%
INPUT "Enter to continue"; ZZ$
GOTO DOINT

DOPR: PRINT USING "At ####.# deg  pattern ####.### dB"; I% - .5; 8.68589 * LOG(IFEED#(I%))
RETURN

