
#if defined(__GNUC__)  &&  defined(__MSP430__)
	#include <legacymsp430.h>
#else
	#include "io430.h"
#endif
#include "b2d.h"
#include "flags.h"

int bin2dec(char *vp, int nBytes, int signd, char *s, int mode)
{
/*
Convert a binary value to a decimal ascii string.
  vp 		- pointer to value to be converted
  nBytes  	- size of vp: 1-byte, 2-int, 4-long
  signd 	- 0 for unsigned value, otherwise value treated as signed
  s  		- output array
  mode 	- APPENDxxx, See flags.h

  Returns length of string in s.
*/
unsigned long val;
int i, n, m, neg;
char *p, *q, *start = s;
//			     nBytes:            1     2           4
const char maxDigits[] = {0, 2, 5, 0, 10};

	p = vp;
	neg = (signd==SIGNED) && (((char)*(p + nBytes - 1)) & 0x80);  // Determine sign
	for (i = 0; i < nBytes; i++)
		if (*p++)
			goto nonzero;
	*s++ = '0';
	goto fixup;	// Value is zero.
nonzero:
	p = vp;
	q = (char*)&val;
	for (i = 0; i < nBytes; i++)	// Move value into val.
		*q++ = *p++;
	n = maxDigits[nBytes];			// max number of characters in output string
	if (neg)
	{
		val = -val;
		n++;
	}
	if (nBytes == 1)
		val &= 0xff;
	else if (nBytes == 2)
		val &= 0xffff;
	m = 0;
    p = s + n;
	while (val)
	{
		*p-- = (val % 10) + 0x30;
		val /= 10;
		m++;
	}
    p++;
    if (neg)
		*s++ = '-';
    for (i = 0; i < m; i++)
	{
		*s++ = *p;			// Remove leading blanks.
		*p++ = ' ';
	}
fixup:
    if (mode & APPENDSP)
     	*s++ = ' ';
	if (mode & APPENDCR)
		*s++ = '\r';
    if (mode & APPENDCRLF)
    {
      	*s++ = '\r';
        *s++ = '\n';
   }
   if (!(mode & APPENDNOTERM))
		*s = 0;
   return (int)(s - start);
}

