#!/usr/bin/python3
#
#  Program to read in the short form of the profile, for example,
# "eutectic_short_profilte.txt"
# and use that data to construct a second-by-second profile, "profile.txt'
# for use with the oven program
#
# command line usage:
#       ./make_profile.py name_of_short_form_profile
#
# Jim Koehler
# Comox, January, 2018
#
##########################################################################

import os
import sys

def open_short(str):
    try:
        inf = open(str, 'r')
        lines = inf.readlines()
        inf.close()
        return lines
    except:
        print("Oops, can't open " + str)
        return 0

def make_profile(str):

    lines = open_short(str)
    if (lines == 0):
        print("cannot find a short profile file!!\n")
    out_file = open("profile.txt", 'w')
    data =[]
    for line in lines:
        data.append(line.split())
    L = len(data)
    for i in range(L-2):
        line1 = data[i]
        line2 = data[i+1]
        t1 = int(line1[0])
        t2 = int(line2[0])
        T1 = int(line1[1])
        T2 = int(line2[1])
        a = T1
        b = (T2 - T1)/(t2 - t1)
        for t in range(t2 - t1):
            str ='{}\t{}\n'.format(round(t1 + t,1),  round(a + b*t, 1)) 
            out_file.write(str)
# now write the last line
    str ='{}\t{}\n'.format(t2, 20) 
    out_file.write(str)

    out_file.close()
    
def main():
    if len(sys.argv) == 2:
        str = sys.argv[1]
    else: str = "short_profile.txt"
    make_profile(str)
    os.system("gnuplot plot_profile.gp")
    os.system("feh profile.png&")
  
        
if __name__ == "__main__":
    main()
    
