#!/usr/bin/python3
#
#      program to read the L.txt file
#  find the best fit to the conductance data
#  and then write the best fit parameters to a file named l_params.txt
#
#  The fitted function is the Gaussian:
#       c / (1.0 + (a*(x-b))**2)
#   and the parameters are written in order: a, b, c in a single line of text
#
# here: c is the peak conductance
#       b is the centre frequency (in MHz!)
#       a is an inverse measure of the width
#
# usage: ./fit_l.py
#
# Jim Koehler
# Comox, BC, May, 2018
#
import sys # need this to read command line arugments
import os
import time
from scipy.optimize import curve_fit
import numpy as np
from pathlib import Path

def s2b(message):
    '''string to bytes'''
    return bytearray(message, "ascii")
    
def get_data():
    r = np.loadtxt('L.txt')
    return r

def G_func(x, a, b, c):
    return (c / (1.0 + (a*(x-b))**2))

# main part of the program here

def main():
    lines = get_data()
    f = lines[:, 0] /1.0E6
    g = lines[:, 1]
    init_vals = []
    init_vals.append(10.0)
    init_vals.append(f[15]) # centre of tabulated frequencies
    init_vals.append(0.2)
    popt, pcov = curve_fit(G_func, f, g, p0=init_vals)
    fh = open("l_params.txt", "wb")
    fh.write(s2b(str(popt[0]) + " " + str(popt[1]) + " " + str(popt[2])))
    fh.close()
    stri = "wgnuplot -c admitplot_l.gp " + str(1.0e6 * f[0]) + " " + str(1.0e6 * f[30]) + " " + str(popt[0]) + " " + str(popt[1]) + " " + str(popt[2])
    os.system(stri)
    time.sleep(.5)#give wgnuplot time to complete writing scan.png
    loop = 1
    while 1:
        c = os.path.isfile("scan.png") and os.path.getsize("scan.png") > 0
        if c > 0:
            break
        time.sleep(1)#give wgnuplot time to complete writing scan.png
        loop +=1
        if loop > 15:
            print ("GNUplot delay timeout")
            break
    time.sleep(1)#give wgnuplot time file write completion
    print("GNUplot delay = ", end = '')
    print(loop, end = '')
    print(" sec.")
    os.system("copy scan.png L.png")
    os.system("L.png") #opens with default pictures viewer for png files

if __name__=="__main__":
    main()
    
