#!/usr/bin/python3
#
#      program to read the adm.txt file and find best fits
# to the conductance and phase curves.
#
#
# Jim Koehler
# Comox, BC, June, 2018
#
import sys # need this to read command line arugments
import os
import time
from scipy.optimize import curve_fit
import numpy as np
from pathlib import Path

def s2b(message):
    '''string to bytes'''
    return bytearray(message, "ascii")
    
def get_data():
    r = np.loadtxt('adm.txt')
    return r

def G_func(x, a, b, c):
    return (c / (1.0 + (a*(x-b))**2))
    
def phi_func(x, a, b):
    return (np.arctan(a * (b - x)))

# main part of the program here

def main():
    lines = get_data()
    freq = lines[:, 0]
    g = lines[:, 1]
    f_centre = freq[20] # the centre frequency
    for i in range(freq.size): # set centre frequency to 0
        freq[i] -= f_centre
    phi = lines[:, 3]
#    print(freq.size, f_centre)
    
    init_vals = []
    init_vals.append(.02)
    init_vals.append(0.0) # centre of tabulated frequencies
    init_vals.append(0.2)
    popt, pcov = curve_fit(G_func, freq, g, p0=init_vals)
#    print(popt[0], popt[1], popt[2])
    g_max = popt[2]
    a_g = popt[0]
    b_g = popt[1]
    c_g = popt[2]
    
    init_vals = []
    init_vals.append(.02)
    init_vals.append(0.0) # centre of tabulated frequencies
    popt, pcov = curve_fit(phi_func, freq, phi, p0=init_vals)
#    print(popt[0], popt[1])
    f_0 = int(round(popt[1]))
    Q = int(round(popt[0]  * (f_centre + f_0) / 2.0))
    a_phi = popt[0]
    b_phi = popt[1]

    fh = open("x_params.txt", "wb")
    fh.write(s2b("#\n"))
    fh.write(s2b("#Freq        R (Ohms)     Q\n"))
    fh.write(s2b("#\n"))
    R = round(100.0/g_max) / 100.0
    fh.write(s2b(str(int(f_centre + f_0)) + "    " + str(R) + "    " + str(Q)))
    fh.close()
    stri = "wgnuplot -c admitplot_xtal_fit.gp " + str(f_centre) + ' '
    stri += str(a_g) + " " + str(b_g) + " " + str(c_g)
    stri += " " + str(a_phi) + " " + str(b_phi)
#    print(stri)
    os.system(stri)
    time.sleep(.5)#give wgnuplot time to complete writing adm.png
    loop = 1
    while 1:
        c = os.path.isfile("adm.png")  and os.path.getsize("adm.png") > 0
        if c > 0:
            break
        time.sleep(1)#give wgnuplot time to complete writing adm.png
        loop +=1
        if loop > 15:
            print ("GNUplot delay timeout")
            break
    time.sleep(1)#give wgnuplot time file write completion
    print("GNUplot delay = ", end = '')
    print(loop, end = '')
    print(" sec.")
    os.system("adm.png") #opens with default pictures viewer for png files
       
if __name__=="__main__":
    main()
    
