#
# program to plot a scan of admittance vs frequency
# 
#
# Jim Koehler, Comox, December 2017
#
#
# amended April, 2019 to set limits to the xrange as passed arguments
# and to automatically switch from linear to logarithmic if the
# ratio of high to low frequency is greater than or equal to ten
#
# usage, called  by:
#
# gnuplot -c admitplot_l.gp lower_limit upper_limit a b c
# where a, b and c are the best fit parameters
#
set terminal push
set terminal png
unset logscale y
set output "scan.png"
if ((ARG2 / ARG1) >= 10) {set logscale x}
else  {unset logscale x}
set grid mxtics mytics xtics ytics
#set grid
#unset xrange
set xrange [(ARG1/1000000.0):(ARG2/1000000.0)]
set title "Admittance vs Frequency"
set ylabel "Siemens"
set xlabel "Frequency in MHz"
f(x) =  ARG5 / (1.0 + (ARG3*(x-ARG4))**2)
plot "L.txt" u ($1/1000000):2 w points t "G" lt rgb "black", "" u ($1/1000000):3 w points t "B" lt rgb "red", f(x) lt rgb "blue"
set terminal pop

