#!/usr/bin/python3
#
#
"""
     This program does a scan of admittance versus frequency
     over a range specified by the call
     
     The call is:
     
     ./y_scan_l.py c w
     
     where  c is the centre frequency in MHz,
			w is the width of the frequency scan, in MHz.
    The program will scan, linearly, using 31 data points

    'L.png' and 'L.txt' will be the created files
    
    L.txt will consist of 31 lines using the following formt:
    freq    G in Siemens    B in Siemens
			
	Jim Koehler, Comox, May, 2019
"""
import numpy as np
import math
import sys
import serial
import time
import os

def rect_to_polar(x, y):
	mag = math.sqrt(x**2 + y**2)
	ph = math.tan(y/x)
	return mag, ph
	
def polar_to_rect(mag, ph):
	x = mag * math.cos(ph)
	y = mag * math.sin(ph)
	return x, y

def get_cal():
	r = np.loadtxt("calibration.txt")
	return r
	
def calibrate( inp, f, c):
	rh = inp[0]  # inp is the uncorrected list with rho magnitude and phase
	ph = inp[1]
	i = round(f / 1e6) - 1 # points to the correct calibration number
	rh = rh * c[i, 0] # correct magnitude
	ph = ph - c[i, 1] # correct phase
	a, b = polar_to_rect(rh, ph) #convert to rectangular
	return a + b * 1j
	

def do_scan(b, u, n):   # u, b and n are int's
    R = complex(50.0, 0)
    TWO = complex(2.0, 0)
    r = [0, 0]
    comm = serial.Serial('/dev/ttyACM0', baudrate = 115200, timeout = 0.3)
    comm.readlines()    # flush the read buffer
    comm.write(s2b("l\r"))   # set mode to linear in frequency
    comm.write(s2b("b " + str(b) + "\r")) 
    time.sleep(0.2)
    comm.write(s2b("u " + str(u)+ "\r")) 
    time.sleep(0.2)
    comm.write(s2b("n " + str(n) + "\r")) 
    time.sleep(0.2)    
    comm.readlines()
    
   
    c = get_cal()
    
    comm.write(s2b("g\r"))
    
    fh=open("tmp.txt", 'wb')   
    for i in range(int(n)):
        v = comm.readline()
        fh.write(v)
    fh.close()
    
    fh=open("tmp.txt", 'rb')
    fh_out = open("admittance.txt", 'wb')
    # fh_out.write(s2b("#    Admittance vs frequency\n"))
    # fh_out.write(s2b("# \n"))
    # fh_out.write(s2b("# freq         G              B\n"))
    # fh_out.write(s2b("# \n"))
   
   
    for i in range(int(n)):
        v = str.split(b2s(fh.readline()))
        r[0] = float(v[1]) / float(v[3])
        r[1] = float(v[2]) - float(v[4])
        rho = calibrate(r, float(v[0]), c)
        z = R * rho/(TWO - rho)
        y = 1/z
        fh_out.write(s2b(v[0] + ' ' + str(y.real) + ' ' + str(y.imag) + '\n'))
 
    fh.close()
    fh_out.close()
	

def b2s(message):
    '''Byte to string'''
    return bytes.decode(message)

def s2b(message):
    '''string to bytes'''
    return bytearray(message, "ascii")

def main():
    c = float(sys.argv[1]) # the first argument of the command line
    w = float(sys.argv[2]) # the second argument of the command line
    b = round(1.0e6 * (c - w/2.0))
    u = round(1.0e6 * (c + w/2.0))
    n = 31
    filename = "L"
    do_scan(b, u, n)
    stri = "-c admitplot_p.gp " + str(b) + " " + str(u)
    os.system("gnuplot " + stri)
    os.system("feh scan.png")
    os.system("mv scan.png " + filename + ".png")
    os.system("mv admittance.txt " + filename + ".txt")
    os.system("rm tmp.txt")   

if __name__=="__main__":
    main()
    
