/* Buttons to add to dial box:
 *  DigiSel - on/off - 4E 00/01
 *  Notch - on/auto/off Manual: 48 00/01 Auto: 41 00/01
 *  Notch Filter Setting - 0D 0000-0255
 *  NR level - 06 0000-0255
 *  RF Power - 0A 0000-0255 
 *  Mic Gain - 0B 0000-0255
 *  Comp Level - 0E 0000-0255
 *  Standard code format: FE FE 98 E0 Cn Sc Data FD
 *  Data is in BCD.  Formula to convert a from decimal to BCD: a/100*256 (byte 1), a%100/10*16 + a%10 (byte 2)
 */

/* Program Sections:
(1) Radios and controllers - enter your communications parameters here.  For Kenwood, this is the baud rate.
(2) Constructors for controls and display - enter your commands in this space according to directions at the top of the section.
 */

// (1) Radios and controllers - change mainrig to the HEX CIV address for your radio.  Mine is 98.  Set radiobaud to the CIV baud setting.  Values must be less than 128000.
byte mainrig = 0x98;
byte controller = 0xE0;
unsigned int radiobaud = 9600;

/* This section defines the controls.  You will need to change the byte arrays to reflect the controls you want to use.  Do not change the pin numbers unless
 *  you are changing the wiring of the controls to the Arduino.  If you wish to add or remove buttons, then add or remove byte variables below as apporpriate.
 */
 
// Do not change any of these lines.  They define the library names to load
#include <DialBoxIcom.h>
#include <Adafruit_GFX.h>    // Core graphics library
#include <MCUFRIEND_kbv.h>   // Hardware-specific library
// uncomment to debug. Make sure you uncomment in the Yaesu library as well.
//#define DEBUG

// You can replace these lines with different colors if you know the bytes that define them.
#define BLACK   0x0000
#define RED     0xF800
#define GREEN   0x07E0
#define WHITE   0xFFFF
#define GREY    0x8410
#define BLUE    0x001F
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0

// Header - do not change this value for Icom radios
char sensorPrintout [3];  
String numvalue;

// (2) Constructors for buttons, dials, rigcontroller buttons and display.  Modify the command, text fields and state fields as appropriate.

// (a) buttons: These are Pushbuttons that control the radio. 
// Replace with the appropriate CIV bytes for the radio function that you want to control.  Syntax {Pin, Command, Subcommand}
//And repalce what is in quotes with the labels for the buttons and their states.
Button Button1 (52, 0x16, 0x4E); // Put your info for the first button here
const char* B1Label[] = {"Btn1 Text: "}; const char* S1Label1[] = {"Off"}; const char* S1Label2[] = {"On "};
Button Button2 (53, 0x16, 0x48); // Put your info for the second button here
const char* B2Label[] = {"Btn2 Text: "}; const char* S2Label1[] = {"Off"}; const char* S2Label2[] = {"On "};
Button Button3 (51, 0x16, 0x40); // Put your info for the third button here
const char* B3Label[] = {"Btn3 Text: "}; const char* S3Label1[] = {"Off"}; const char* S3Label2[] = {"On "};
Button Button4 (50, 0x16, 0x44); // Put your info for the fourth button here
const char* B4Label[] = {"Btn4 Text: "}; const char* S4Label1[] = {"Off"}; const char* S4Label2[] = {"On "};
Button Button5 (48, 0x16, 0x46); // Put your info for the fifth button here
const char* B5Label[] = {"Btn5 Text: "}; const char* S5Label1[] = {"Off"}; const char* S5Label2[] = {"On "};
// The sixth button is saved for the coarse/fine adjustment.

//(b) Dials: These are the dials that control the radio. Replace with the appropriate CIV bytes for the radio function that you want to control.
//Syntax (pin1, pin2, Command, Subcommand).  
Controls Dial1 (47, 46, 0x14, 0x0D); // Notch Shift
const char* D1Label[] = {"Notch Level: "};
Controls Dial2 (45, 44, 0x14, 0x06); // NR Level
const char* D2Label[] = {"NR Level: "};
Controls Dial3 (43, 42, 0x14, 0x0A); // RF Power
const char* D3Label[] = {"RF Pwr: "};
Controls Dial4 (41, 40, 0x14, 0x0B); // Mic Gain
const char* D4Label[] = {"Mic. Gain: "};
Controls Dial5 (39, 38, 0x14, 0x0E); // Compression Level
const char* D5Label[] = {"Compression: "};
Controls Dial6 (37, 36, 0x14, 0x13); // Digisel Level
const char* D6Label[] = {"Digisel Shift: "};

//(c) Constructors for buttons that set features on the rig controller.  Syntax: {pin number}
CtlButton coarsebutton (49); // coarse / fine adjustment - do not change


//(d) Display: These are members of the CIVPoll class - TFT display objects that are updated by the radio.  Syntax: {Command, Subcommand} 
// Make sure they match the bytes for the buttons/dials above
CIVPoll Button1in (0x16, 0x4E);
CIVPoll Button2in (0x16, 0x48);
CIVPoll Button3in (0x16, 0x40);
CIVPoll Button4in (0x16, 0x44);
CIVPoll Button5in (0x16, 0x46);
CIVPoll Dial1in (0x14, 0x0D);
CIVPoll Dial2in (0x14, 0x06);
CIVPoll Dial3in (0x14, 0x0A);
CIVPoll Dial4in (0x14, 0x0B);
CIVPoll Dial5in (0x14, 0x0E);
CIVPoll Dial6in (0x14, 0x13);
MCUFRIEND_kbv tft;

int steplevel = 0;
int toggle = 1;

//These two lines define variables that keep track of the notch toggle, which is 3 positions for the IC7610 (off, manual, auto) and the memory register for the voice memory that is selected. 
int notchvalue = 0; // Keeps track of where we are with notch: 0 = off, 1 = manual notch, 2 = auto notch.
int memval = 1; // Keeps track of which keyer memory we want to send (1-8).

//Variables for screen printing
bool ischanged = true; // to record if we should print a new value on the screen
bool sendmem = false; // variable to print "sending" on the screen if the voice keyer memory is sent.
unsigned long elapsedtime, priortime, currtime; // Variables that keep track of the 5 second timer for polling the radio.

void setup() {
  // initialize the controls - run all of their begin functions.
coarsebutton.begin(); // This is button7, but we call it coarsebutton because it is the coarse/fine adjustment for the dials.
Button1.begin();
Button2.begin();
Button3.begin();
Button4.begin();
Button5.begin();
Dial1.begin();
Dial2.begin();
Dial3.begin();
Dial4.begin();
Dial5.begin();
Dial6.begin();
Serial1.begin (radiobaud); 

  //initialize the TFT object
    uint16_t ID = tft.readID();
    tft.begin(ID);
    tft.setRotation(3);
    tft.fillScreen(BLUE);
    tft.setTextColor(YELLOW, BLUE);
    tft.setTextSize(2);
  priortime=millis(); // start the timer
  updatedisplay(0);
}

// MAIN LOOP
void loop() {
  updatebuttons(); // poll the buttons for a status update.
  icomchange();  // check if there are any changes reported on CIV.
}

// FUNCTIONS - You will not need to change anything below this line unless you add or remove controls.  If so, then modify, add or delete below as appropriate.

//The function icomchange checks to see if any of the dialbox controls were updated on the radio.  If so, the TFT display gets updated.  The radio is checked every 5 seconds.
  
  void icomchange() // check if there are any changes on the CIV bus
{
  currtime = millis();
  elapsedtime = currtime - priortime;
  if (elapsedtime > 5000) { // Check for input every 5 seconds
    priortime=currtime;

// Each if statement loks to see if data is coming in from the radio for that function.  If so, the button is toggled as if it was pushed on the controller, and the display is updated.
    if (Button1in.UpdateCIV(mainrig, controller)) {
      Button1.level = Button1in.level;
      updatedisplay(1); 
    }
      if (Button2in.UpdateCIV(mainrig, controller)) {
      Button2.level = Button2in.level;
      updatedisplay(2); 
    }
      if (Button3in.UpdateCIV(mainrig, controller)) {
      Button3.level = Button3in.level;
      updatedisplay(3); 
    }
      if (Button4in.UpdateCIV(mainrig, controller)) {
      Button4.level = Button4in.level;
      updatedisplay(4); 
    }
      if (Button5in.UpdateCIV(mainrig, controller)) {
      Button5.level = Button5in.level;
      updatedisplay(5); 
    }
      if (Dial1in.UpdateCIV(mainrig, controller)) {
      Dial1.level = Dial1in.level;
      updatedisplay(6); 
    }
      if (Dial2in.UpdateCIV(mainrig, controller)) {
      Dial2.level = Dial2in.level;
      updatedisplay(7); 
    }
      if (Dial3in.UpdateCIV(mainrig, controller)) {
      Dial3.level = Dial3in.level;
      updatedisplay(8); 
    }
      if (Dial4in.UpdateCIV(mainrig, controller)) {
      Dial4.level = Dial4in.level;
      updatedisplay(9); 
    }
      if (Dial5in.UpdateCIV(mainrig, controller)) {
      Dial5.level = Dial5in.level;
      updatedisplay(10); 
    }
      if (Dial6in.UpdateCIV(mainrig, controller)) {
      Dial6.level = Dial6in.level;
      updatedisplay(11); 
    }
  }
}

// This function runs the appropriate command if a button was pressed
void updatebuttons()
 {

// The next three lines control the coarse or fine setting for the dials.
    if (coarsebutton.update()) {
  updatedisplay(0);
    }
  if (Button1.update()){
    Button1.level = 1 - Button1.level; // invert the value, as we are toggling it.
    updatedisplay(1);
    Button1.Senddata(mainrig, controller);
  }
    if (Button2.update()){
    Button2.level = 1 - Button2.level; // invert the value, as we are toggling it.
    updatedisplay(2);
    Button2.Senddata(mainrig, controller);
  }
    if (Button3.update()){
    Button3.level = 1 - Button3.level; // invert the value, as we are toggling it.
    updatedisplay(3);
    Button3.Senddata(mainrig, controller);
  }
    if (Button4.update()){
    Button4.level = 1 - Button4.level; // invert the value, as we are toggling it.
    updatedisplay(4);
    Button4.Senddata(mainrig, controller);
  }
    if (Button5.update()){
    Button5.level = 1 - Button5.level; // invert the value, as we are toggling it.
    updatedisplay(5);
    Button5.Senddata(mainrig, controller);
  }

//These lines update the display and send data to the rig if any of the dials are turned.
if (Dial1.update(steplevel)){
      updatedisplay(6);
  Dial1.Senddata(mainrig, controller);
}

if (Dial2.update(steplevel)){
      updatedisplay(7);
  Dial2.Senddata(mainrig, controller);
}

if (Dial3.update(steplevel)){
    updatedisplay(8);
  Dial3.Senddata(mainrig, controller);
}

if (Dial4.update(steplevel)){
      updatedisplay(9);
  Dial4.Senddata(mainrig, controller);
}

if (Dial5.update(steplevel)){
      updatedisplay(10);
  Dial5.Senddata(mainrig, controller);
}
if (Dial6.update(steplevel)){
      updatedisplay(11);
  Dial6.Senddata(mainrig, controller);
}
 }
 
 //The function update display changes the line on the display corresponding to the button or dial that was updated.  Change the text of the tft.print lines to
//reflect the function you assigned to each button.

void updatedisplay(int device)
{
  switch (device) {
    case 0:
        if (toggle == 1) { // This set of code is for the coarse/fine switch.  We are toggling the coarse/fine option each time the button is pressed.
          tft.setCursor(300, 300);
          tft.print("Coarse: Off");
          steplevel = 1;
        }
        else {
          tft.setCursor(300, 300); 
          tft.print("Coarse: On ");
          steplevel = 5;
    }
     toggle = 1-toggle; // invert the value of toggle.
    break;
    case 1:
    if (Button1.level == 0) { // Button1 Function is off
          tft.setCursor(5, 10);
          tft.print(*B1Label);
          tft.setCursor(180, 10);
          tft.print(*S1Label1);
    }
    else if (Button1.level == 1) { // Button1 Function is on
          tft.setCursor(5, 10); 
          tft.print(*B1Label);
          tft.setCursor(180, 10);
          tft.print(*S1Label2);
    }
    break;
    case 2:
    if (Button2.level == 0) { // Button1 Function is off
          tft.setCursor(5, 35);
          tft.print(*B2Label);
          tft.setCursor(180, 35);
          tft.print(*S2Label1);
    }
    else if (Button2.level == 1) { // Button1 Function is on
          tft.setCursor(5, 35); 
          tft.print(*B2Label);
          tft.setCursor(180, 35);
          tft.print(*S2Label2);
    }
    break;
        case 3:
    if (Button3.level == 0) { // Button1 Function is off
          tft.setCursor(5, 60);
          tft.print(*B3Label);
          tft.setCursor(180, 60);
          tft.print(*S3Label1);
    }
    else if (Button3.level == 1) { // Button1 Function is on
          tft.setCursor(5, 60); 
          tft.print(*B3Label);
          tft.setCursor(180, 60);
          tft.print(*S3Label2);
    }
    break;
        case 4:
    if (Button4.level == 0) { // Button1 Function is off
          tft.setCursor(5, 85);
          tft.print(*B4Label);
          tft.setCursor(180, 85);
          tft.print(*S4Label1);
    }
    
    else if (Button4.level == 1) { // Button1 Function is on
          tft.setCursor(5, 85); 
          tft.print(*B4Label);
          tft.setCursor(180, 85);
          tft.print(*S4Label2);
    }
    break;
        case 5:
    if (Button5.level == 0) { // Button1 Function is off
          tft.setCursor(5, 110);
          tft.print(*B5Label);
          tft.setCursor(180, 110);
          tft.print(*S5Label1);
    }
    else if (Button5.level == 1) { // Button1 Function is on
          tft.setCursor(5, 110); 
          tft.print(*B5Label);
          tft.setCursor(180, 110);
          tft.print(*S5Label2);
    }
    break;

 //The cases below reflect dial levels that are updated.  
             case 6: // Corresponds to Dial 1
          tft.setCursor(5, 135);
          tft.print(*D1Label);
          tft.setCursor(180,135);
          tft.print("   ");
          tft.setCursor(180,135);
          tft.print(Dial1.level);
    break;
             case 7: // Corresponds to Dial 2
          tft.setCursor(5, 160);
          tft.print(*D2Label);
          tft.setCursor(180,160);
          tft.print("   ");
          tft.setCursor(180,160);
          tft.print(Dial2.level);
    break;
             case 8: // Corresponds to Dial 3
          tft.setCursor(5, 185);
          tft.print(*D3Label);
          tft.setCursor(180,185);
          tft.print("   ");
          tft.setCursor(180,185);
          tft.print(Dial3.level);
    break;
             case 9: // Corresponds to Dial 4
          tft.setCursor(5, 210);
          tft.print(*D4Label);
          tft.setCursor(180,210);
          tft.print("   ");
          tft.setCursor(180,210);
          tft.print(Dial4.level);
    break;
             case 10:  // Corresponds to Dial 5
          tft.setCursor(5, 235);
          tft.print(*D5Label);
          tft.setCursor(180,235);
          tft.print("   ");
          tft.setCursor(180,235);
          tft.print(Dial5.level);
    break;
             case 11: // Corresponds to Dial 6
          tft.setCursor(5, 260);
          tft.print(*D6Label);
          tft.setCursor(180,260);
          tft.print("   ");
          tft.setCursor(180,260);
          tft.print(Dial6.level);
    break;
  }
}
  
