/* Buttons to add to dial box:
 *  Noise blanker - on/off - NB0; (off) NB1; (on) NB; to read
 *  Speech Processor - on/off - PR0; (off) PR1; (on) PR to read
 *  Tone Function - on/off - TO0; (off) TO1; (on) TO to read
 *  VOX - VX0; off VX1; on VX; to read
 *  XIT - XT0; (off) XT1; (on) XT; to read 
 *  Lock VFO dial - LK0; (off)  LK1; (on)   LK; read
 *  RF Gain - RG000; to RG100;
 *  RF Power - PC005; to PC100;
 *  Mic Gain - MG000; to MG100;
 *  NR Level - RL00; to RL09;
 *  Keyer Speed - KS010; to KS060;  KS; to read
 *  Noise Blanker Level - NL001; to NL010;  NL; to read
 *  Send command with what is written above.  Receive by calling with first two letters, then semicolon.
 */

 /* PRogram Sections:
(1) Radios and controllers - enter your communications parameters here.  For Kenwood, this is the baud rate.
(2) Constructors for controls and display - enter your commands in this space according to directions at the top of the section.
 */


// (1) Radios and controllers - Set radiobaud to the CAT baud setting.  
unsigned int radiobaud = 9600;

/* This section defines the controls.  You will need to change the noted sections to reflect the controls you want to use.  Do not change the pin numbers unless
 *  you are changing the wiring of the controls to the Arduino.  If you wish to add or remove buttons, then add or remove char* variables below as apporpriate.
 */
 
// Do not change any of these lines.  They define the library names to load
#include <DialBoxYaesu.h>
#include <Adafruit_GFX.h>    // Core graphics library
#include <MCUFRIEND_kbv.h>   // Hardware-specific library
// uncomment to debug. Make sure you uncomment in the Yaesu library as well.
// #define DEBUG

// You can replace these lines with different colors if you know the bytes that define them.
#define BLACK   0x0000
#define RED     0xF800
#define GREEN   0x07E0
#define WHITE   0xFFFF
#define GREY    0x8410
#define BLUE    0x001F
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0

// Header - do not change this value
char sensorPrintout [3];  
String numvalue;

// (2) Constructors for buttons, dials, rigcontroller buttons and display.  Modify the command, text fields and state fields as appropriate.

// (a) buttons: These are members of the button class - buttons that control the radio. 
// Pushbuttons that control the radio.  Syntax: {"Yaesu/Kenwood Command", "State1", "State2",...,etc.}.  You can have as many states as you wish.
// If you have more than 2 states (i.e. more than "on" and "off"), then you will need to add more char arrays and fields in the next section for the additional states.
// The index of the array that is sent corresponds to the variable level for the button object, so if you have more than 2 states, you will need to modify
// the code in the function updatebuttons() to allow level for that button to have additional values.

const char* B1cmd[] = {"NB", "0", "1"}; // Replace for your button as noted above
const char* B2cmd[] = {"PR", "0", "1"};
const char* B3cmd[] = {"TO", "0", "1"};
const char* B4cmd[] = {"VX", "0", "1"};
const char* B5cmd[] = {"XT", "0", "1"};

//For the lines below, replace what is in quotes for the char sections with the labels for the buttons and their states.  Add more if needed.  You will need
//to modify the display code for any more than 2 states.
Button Button1 (52, B1cmd); // Put your info for the first button here.  
const char* B1Label[] = {"Noise Blnkr: "}; const char* S1Label1[] = {"Off"}; const char* S1Label2[] = {"On "};
Button Button2 (53, B2cmd); // Put your info for the second button here
const char* B2Label[] = {"Compression: "}; const char* S2Label1[] = {"Off"}; const char* S2Label2[] = {"On "};
Button Button3 (50, B3cmd); // Put your info for the third button here
const char* B3Label[] = {"Tone: "}; const char* S3Label1[] = {"Off"}; const char* S3Label2[] = {"On "};
Button Button4 (51, B4cmd); // Put your info for the fourth button here
const char* B4Label[] = {"VOX: "}; const char* S4Label1[] = {"Off"}; const char* S4Label2[] = {"On "};
Button Button5 (48, B5cmd); // Put your info for the fifth button here
const char* B5Label[] = {"XIT: "}; const char* S5Label1[] = {"Off"}; const char* S5Label2[] = {"On "};
// The sixth button is saved for the coarse/fine adjustment.

//(b) Dials: These are the dials that control the radio. Replace with the appropriate commands for the radio function that you want to control.
//Syntax (pin1, pin2, "Command", lowest level, highest level, number of digits in level to send to the radio).  
//Replace what is in quotes for the DnLabel (where n=number) variables with the labels for the dials
Controls Dial1 (47, 46, "RG", 0, 100, 3); // For example, the RF Gain dial is on pins 47 and 46.  The command is RG.  The range is 0-100.  The radio expects 3 digits.
const char* D1Label[] = {"RF Gain: "}; // The label to appear on the screen is "RF Gain"
Controls Dial2 (45, 44, "PC", 5, 100, 3); 
const char* D2Label[] = {"RF Pwr: "};
Controls Dial3 (43, 42, "MG", 0, 100, 3); 
const char* D3Label[] = {"Mic. Gain: "};
Controls Dial4 (41, 40, "RL", 0, 9, 2);
const char* D4Label[] = {"NR Level: "};
Controls Dial5 (39, 38, "KS", 10, 60, 3);
const char* D5Label[] = {"Key Speed: "};
Controls Dial6 (37, 36, "NL", 1, 10, 3); 
const char* D6Label[] = {"Noise Blanker: "};

//(c) Constructors for buttons that set features on the rig controller.  Syntax: {pin number}
CtlButton coarsebutton (49); // coarse / fine adjustment - do not change this one.

//(d) Display: These are members of the CIVPoll class - TFT display objects that are updated by the radio.  
//Syntax: {"Kenwood/Yaesu Command", length of data expected, max level of control (per Kenwood/Yaesu CAT manual)}  The last two variables are for QC checking of the reveived data.
// Add or subtract objects based on how many buttons/dials you have.
CIVPoll Button1in ("NB;",1, 1); // For example, the button command for noise blanker is "NB;", it only sends one digit (per the manual), and its max value is 1.
CIVPoll Button2in ("PR;",1, 1);
CIVPoll Button3in ("TO;",1, 1);
CIVPoll Button4in ("VX;",1,1);
CIVPoll Button5in ("XT;",1,1);
CIVPoll Dial1in ("RG;",3,100);
CIVPoll Dial2in ("PC;",3,100);
CIVPoll Dial3in ("MG;",3,100);
CIVPoll Dial4in ("RL;",2,9);
CIVPoll Dial5in ("KS;",3,060);
CIVPoll Dial6in ("NL;",3,10);
MCUFRIEND_kbv tft;

int steplevel = 0;
int toggle = 1;

//Variables for screen printing
bool ischanged = true; // to record if we should print a new value on the screen
bool sendmem = false; // variable to print "sending" on the screen if the voice keyer memory is sent.
unsigned long elapsedtime, priortime, currtime; // Variables that keep track of the 5 second timer for polling the radio.

void setup() {
  // initialize the controls - run all of their begin functions.  Add or remove buttons or dials to fit your configuration.
coarsebutton.begin(); // This is button7, but we call it coarsebutton because it is the coarse/fine adjustment for the dials.
Button1.begin();
Button2.begin();
Button3.begin();
Button4.begin();
Button5.begin();
Dial1.begin();
Dial2.begin();
Dial3.begin();
Dial4.begin();
Dial5.begin();
Dial6.begin();
Serial1.begin (radiobaud); // Kenwood expects 8 data bits, no parity and 1 stop bit.  This is standard for Arduino serial. 
// For Yaesu, the radio expects 2 stop bits.  Therefore use the line Serial1.begin (radiobaud, SERIAL_8N2); in that case.
#ifdef DEBUG
Serial.begin(9600); // Debug Line
#endif
  //initialize the TFT object
    uint16_t ID = tft.readID();
    tft.begin(ID);
    tft.setRotation(3);
    tft.fillScreen(BLUE);
    tft.setTextColor(YELLOW, BLUE);
    tft.setTextSize(2);
  priortime=millis(); // start the timer
  updatedisplay(0);
}

// MAIN LOOP
void loop() {
  updatebuttons(); // poll the buttons for a status update.
  kenwoodchange();  // check if there are any changes reported on CAT
}

// FUNCTIONS - You will not need to change anything below this line unless you add or remove controls.  If so, then modify, add or delete below as appropriate.

//The function Kenwoodchange checks to see if any of the dialbox controls were updated on the radio.  If so, the TFT display gets updated.  The radio is checked every 5 seconds.
  
  void kenwoodchange() // check if there are any changes on the CAT port
{
  currtime = millis();
  elapsedtime = currtime - priortime;
  if (elapsedtime > 5000) { // Check for input every 5 seconds
    priortime=currtime;

// Each if statement loks to see if data is coming in from the radio for that function.  If so, the button is toggled as if it was pushed on the controller, and the display is updated.
    if (Button1in.UpdateCIV()) {
      Button1.level = Button1in.level;
      updatedisplay(1); 
    }
      if (Button2in.UpdateCIV()) {
      Button2.level = Button2in.level;
      updatedisplay(2); 
    }
      if (Button3in.UpdateCIV()) {
      Button3.level = Button3in.level;
      updatedisplay(3); 
    }
      if (Button4in.UpdateCIV()) {
      Button4.level = Button4in.level;
      updatedisplay(4); 
    }
      if (Button5in.UpdateCIV()) {
      Button5.level = Button5in.level;
      updatedisplay(5); 
    }
      if (Dial1in.UpdateCIV()) {
      Dial1.level = Dial1in.level;
      updatedisplay(6); 
    }
      if (Dial2in.UpdateCIV()) {
      Dial2.level = Dial2in.level;
      updatedisplay(7); 
    }
      if (Dial3in.UpdateCIV()) {
      Dial3.level = Dial3in.level;
      updatedisplay(8); 
    }
      if (Dial4in.UpdateCIV()) {
      Dial4.level = Dial4in.level;
      updatedisplay(9); 
    }
      if (Dial5in.UpdateCIV()) {
      Dial5.level = Dial5in.level;
      updatedisplay(10); 
    }
      if (Dial6in.UpdateCIV()) {
      Dial6.level = Dial6in.level;
      updatedisplay(11); 
    }
  }
}

// This function runs the appropriate command if a button was pressed  These functions are set up for 2-state buttons.  If you have a 3-state button, you will need to modify accordingly.
// See the KE1IU implementation code for an example (note the example is for Icom - you will need to modify for Kenwood/Yaesu).


void updatebuttons()
 {

// The next three lines control the coarse or fine setting for the dials.
    if (coarsebutton.update()) {
  updatedisplay(0);
    }
  if (Button1.update()){
    Button1.level = 1 - Button1.level; // invert the value, as we are toggling it.
    updatedisplay(1);
    Button1.Senddata();
  }
    if (Button2.update()){
    Button2.level = 1 - Button2.level; // invert the value, as we are toggling it.
    updatedisplay(2);
    Button2.Senddata();
  }
    if (Button3.update()){
    Button3.level = 1 - Button3.level; // invert the value, as we are toggling it.
    updatedisplay(3);
    Button3.Senddata();
  }
    if (Button4.update()){
    Button4.level = 1 - Button4.level; // invert the value, as we are toggling it.
    updatedisplay(4);
    Button4.Senddata();
  }
    if (Button5.update()){
    Button5.level = 1 - Button5.level; invert the value, as we are toggling it.
    updatedisplay(5);
    Button5.Senddata();
  }

//These lines update the display and send data to the rig if any of the dials are turned.
if (Dial1.update(steplevel)){
      updatedisplay(6);
  Dial1.Senddata();
}

if (Dial2.update(steplevel)){
  Dial2.Senddata();
    updatedisplay(7);
}

if (Dial3.update(steplevel)){
  Dial3.Senddata();
    updatedisplay(8);
}

if (Dial4.update(steplevel)){
  Dial4.Senddata();
    updatedisplay(9);
}

if (Dial5.update(steplevel)){
  Dial5.Senddata();
    updatedisplay(10);
}
if (Dial6.update(steplevel)){
  Dial6.Senddata();
    updatedisplay(11);
}
 }

 //DISPLAY LABELS SECTION
 //The function update display changes the line on the display corresponding to the button or dial that was updated.  
//If you have greater than two states for any button, then you will need to add lines reflecting the occasions where Buttonx.level == other values than 0 or 1.

void updatedisplay(int device)
{
  switch (device) {
    case 0:
        if (toggle == 1) { // This set of code is for the coarse/fine switch.  We are toggling the coarse/fine option each time the button is pressed.
          tft.setCursor(300, 300);
          tft.print("Coarse: Off");
          steplevel = 1;
        }
        else {
          tft.setCursor(300, 300); 
          tft.print("Coarse: On ");
          steplevel = 5;
    }
     toggle = 1-toggle; // invert the value of toggle.
    break;
    case 1:
    if (Button1.level == 0) { // Button1 Function is off
          tft.setCursor(5, 10);
          tft.print(*B1Label);
          tft.setCursor(180, 10);
          tft.print(*S1Label1);
    }
    else if (Button1.level == 1) { // Button1 Function is on
          tft.setCursor(5, 10); 
          tft.print(*B1Label);
          tft.setCursor(180, 10);
          tft.print(*S1Label2);
    }
    break;
    case 2:
    if (Button2.level == 0) { // Button1 Function is off
          tft.setCursor(5, 35);
          tft.print(*B2Label);
          tft.setCursor(180, 35);
          tft.print(*S2Label1);
    }
    else if (Button2.level == 1) { // Button1 Function is on
          tft.setCursor(5, 35); 
          tft.print(*B2Label);
          tft.setCursor(180, 35);
          tft.print(*S2Label2);
    }
    break;
        case 3:
    if (Button3.level == 0) { // Button1 Function is off
          tft.setCursor(5, 60);
          tft.print(*B3Label);
          tft.setCursor(180, 60);
          tft.print(*S3Label1);
    }
    else if (Button3.level == 1) { // Button1 Function is on
          tft.setCursor(5, 60); 
          tft.print(*B3Label);
          tft.setCursor(180, 60);
          tft.print(*S3Label2);
    }
    break;
        case 4:
    if (Button4.level == 0) { // Button1 Function is off
          tft.setCursor(5, 85);
          tft.print(*B4Label);
          tft.setCursor(180, 85);
          tft.print(*S4Label1);
    }
    
    else if (Button4.level == 1) { // Button1 Function is on
          tft.setCursor(5, 85); 
          tft.print(*B4Label);
          tft.setCursor(180, 85);
          tft.print(*S4Label2);
    }
    break;
        case 5:
    if (Button5.level == 0) { // Button1 Function is off
          tft.setCursor(5, 110);
          tft.print(*B5Label);
          tft.setCursor(180, 110);
          tft.print(*S5Label1);
    }
    else if (Button5.level == 1) { // Button1 Function is on
          tft.setCursor(5, 110); 
          tft.print(*B5Label);
          tft.setCursor(180, 110);
          tft.print(*S5Label2);
    }
    break;

 //The cases below reflect dial levels that are updated.  
             case 6: // Corresponds to Dial 1
          tft.setCursor(5, 135);
          tft.print(*D1Label);
          tft.setCursor(180,135);
          tft.print("   ");
          tft.setCursor(180,135);
          tft.print(Dial1.level);
    break;
             case 7: // Corresponds to Dial 2
          tft.setCursor(5, 160);
          tft.print(*D2Label);
          tft.setCursor(180,160);
          tft.print("   ");
          tft.setCursor(180,160);
          tft.print(Dial2.level);
    break;
             case 8: // Corresponds to Dial 3
          tft.setCursor(5, 185);
          tft.print(*D3Label);
          tft.setCursor(180,185);
          tft.print("   ");
          tft.setCursor(180,185);
          tft.print(Dial3.level);
    break;
             case 9: // Corresponds to Dial 4
          tft.setCursor(5, 210);
          tft.print(*D4Label);
          tft.setCursor(180,210);
          tft.print("   ");
          tft.setCursor(180,210);
          tft.print(Dial4.level);
    break;
             case 10:  // Corresponds to Dial 5
          tft.setCursor(5, 235);
          tft.print(*D5Label);
          tft.setCursor(180,235);
          tft.print("   ");
          tft.setCursor(180,235);
          tft.print(Dial5.level);
    break;
             case 11: // Corresponds to Dial 6
          tft.setCursor(5, 260);
          tft.print(*D6Label);
          tft.setCursor(180,260);
          tft.print("   ");
          tft.setCursor(180,260);
          tft.print(Dial6.level);
    break;
  }
}
  
