#include "DialBoxYaesu.h"
// Uncomment the line below for debugging.
// #define DEBUG

CtlButton::CtlButton(int pin) // Constructor for a button that adjusts a setting on the controller.  Used for the coarse/fine adjustment button and the memory select button.
{
pinnumberc = pin;
}

void CtlButton::begin() // Function to set up a button that adjusts a setting on the controller.  Used for the coarse/fine adjustment button and the memory select button.
{
pinMode (pinnumberc, INPUT_PULLUP);
}

bool CtlButton::update() // Function to update the button that adjusts a setting on the controller.  Used as noted above.
{
status = digitalRead(pinnumberc); // Read the digital pin for the button and store value in the Boolean variable "status"
if (status == 0) delay(200); // delay introduced to avoid button bounce.
return !status; // Returns the value of the button - inverted so "true" means it was pressed, and "false" means it was not.
}

Button::Button(int pin, const char** command) // Contructor for buttons that directly send commands to the radio.
    {
      pinnumber = pin; // stores the value of the button's pin.
      _command = command; // the actual command that came in as a set of characters
}

void Button::begin() // Begin function for a button used as above.  Sets up the digital pin for the button.
{
      pinMode(pinnumber, INPUT_PULLUP); 
}

bool Button::update() // Update function for a button used as above.  
 {
    if (digitalRead(pinnumber)==LOW) {
    delay(200); // (eliminate button bounce)
    return true; // Return true if pressed.
  }
  else return false; // Return false if pressed.
}

 void Button::Senddata() // Function to send data to the radio when a button is pressed
{
  Serial1.print(_command[0]); // the first member of the array is the Yaesu command name
  Serial1.print(_command[level+1]); // the other members of the array are indexed by level (0 or 1 for off or on).  You can have more states if needed.
  Serial1.println(";"); // semicolon is the Yaesu terminator for all command lines.
  Serial1.flush(); // wait until all data sent
  delay(10);
#ifdef DEBUG
  Serial.print(_command[0]); // the first member of the array is the Yaesu command name
  Serial.print(_command[level+1]); // the other members of the array are indexed by level (0 or 1 for off or on).  You can have more states if needed.
  Serial.println(";"); // semicolon is the Yaesu terminator for all command lines.
  Serial.flush(); // wait until all data sent
  delay(10);
#endif
  }

Controls::Controls(int pinU, int pinL, const char* command, int low, int high, int digits) : thisEncoder (pinU, pinL)
    {
      pinnumberu = pinU;
      pinnumberl = pinL;
      _command = command;
      _low=low;
      _high=high;
      _digits=digits;
    }

void Controls::begin()  // Set up the controls
{
pinMode(pinnumberu, INPUT_PULLUP);
pinMode(pinnumberl, INPUT_PULLUP);
}  

// The code below gets input from the dials.  It returns a value of true if a dial was turned.  Step corresponds to the increment multiplier (1 or 5) set by the coarse/fine adjustment
bool Controls::update(int step) {
thisEncoder.tick();
controldir=thisEncoder.getDirection();
if (step == 1){
if ((level>_low && level <_high)||(level == _low && controldir >0) || (level == _high & controldir <0)) {
level += controldir*step;
}
}
if (step == 5){
if ((level>_low+4 && level <_high-4)||(level <_low+5 && controldir >0) || (level >_high-6 && controldir <0)) {
level += controldir*step;
}
}
if (controldir != 0)
{
return true;
} 
else return false;
}

  void Controls::Senddata()
 { 
// The following lines send the data it as a multi digit number with leading zeroes.
  Serial1.print (_command);
  if (level<100 && _digits==3) Serial1.print ("0");
  if (level<10 && _digits>1) Serial1.print ("0");
  Serial1.print (level);
  Serial1.println (";"); // Semicolon is the terminator for all Yaesu or Kenwood CAT lines.
  Serial1.flush(); // wait until all data sent
#ifdef DEBUG
  Serial.print (_command);
  if (level<100 && _digits==3) Serial.print ("0");
  if (level<10 && _digits>1) Serial.print ("0");
  Serial.print (level);
  Serial.println (";"); // Semicolon is the terminator for all Yaesu or Kenwood CAT lines.
  Serial.flush(); // wait until all data sent
#endif
//  success=true; // delete this line when implementing.
  delay(10);
 }

CIVPoll::CIVPoll (const char* cmd, int _length, int _maxlevel) // brings in the information for a control - the text command, the length of the expected data in digits, and the max level of the control.
    {
    _command = cmd;
    len = _length;
    maxlevel = _maxlevel;
    }

// This function tests to see if there is new data available from the radio and sends "true" if valid data are received.

bool CIVPoll::UpdateCIV()
 {
retrycount=0;
  Serial1.flush(); // wait until all data sent
  Serial1.println (_command);
  length = sizeof(_command) - 2;
 // We want to first read the command and check if it is valid.  Commands have a ; and a null character at the end, so subtract 2 to get the length of the command itself
  j = 0; // Reset the character counter
while (Serial1.available() <1 ) {} // wait for radio
CAT_TRX_next:
if (Serial1.available() >0) { // If serial data are available, then process it.
Serial1.readBytes(incomingTRX,length); // Get the incoming data from the radio
for (int i=0; i<=length; i++) {
  if (incomingTRX[i] == _command[i]) { // We are testing to see if every character received matches the command
j++; // If so, increment the matching character counter
}
}
if (j==length) {       // If the number of matching characters equals the command length then we have valid data.
      goto CAT_TRX_start;  // Go to the routine to start processing the data                 
    }
  delay (1);  // allow buffer to fill
if (retrycount<10) { // If no valid data received yet, keep getting new data for 10 tries.
retrycount++;
  goto CAT_TRX_next;                         // no specific byte received, so keep monitoring buffer
}
else goto invalid; // If the retry count expires, then we have invalid data.  Go to the invalid routine.

   //-------------------------------------------------------------------
CAT_TRX_start:                             
  //-------------------------------------------------------------------

  delay (20);                                     // delay is required to allow buffer to fill : too low = buffer not filled ! Too high = not smooth response
    if (Serial1.available() > 0) {           // there is data in buffer !
    length=Serial1.readBytesUntil(';',buffget_CAT,8);     // load buffget with next characters until the ; terminator is reached.  8 characters is the longest we will receive.
    _level = 0; // reset the level for that control because we are getting valid data.
    for (int i=1; i<=len; i++) {
    number = (int) buffget_CAT[len-i]; //convert the digits from char to int starting from rightmost character.  The ; terminator was dropped
    number = number-48; // Convert from ASCII to the actual number
    _level = _level + number * pow(10,i-1); //adds the value to level.  The pow function converts the integer to its proper place in the base 10 number.
}  
#ifdef DEBUG
Serial.print("Raw data: ");
Serial.println(buffget_CAT);
Serial.print("Processed number: ");
Serial.println(_level);
#endif
if (_level>=0 && _level <= maxlevel) {
level = _level;
        return true;
}
else {
return false; // data is out of range, so do not update the display.
}
      }
}

 invalid: // this routine runs if the Serial1 buffer has bad data, and it dumps the buffer contents
while (Serial1.available()>0) {
bufferdump = Serial1.read(); // clear all Serial1 buffer data
}
retrycount=0; // reset the counter
 return false;    // data was bad - return a false state so the display is not updated.
 }
  
