#include "DialBoxIcom.h"
// Uncomment the line below for debugging.
// #define DEBUG

CtlButton::CtlButton(int pin) // Constructor for a button that adjusts a setting on the controller.  Used for the coarse/fine adjustment button and the memory select button.
{
pinnumberc = pin;
}

void CtlButton::begin() // Function to set up a button that adjusts a setting on the controller.  Used for the coarse/fine adjustment button and the memory select button.
{
pinMode (pinnumberc, INPUT_PULLUP);
}

bool CtlButton::update() // Function to update the button that adjusts a setting on the controller.  Used as noted above.
{
status = digitalRead(pinnumberc); // Read the digital pin for the button and store value in the Boolean variable "status"
if (status == 0) delay(200); // delay introduced to avoid button bounce.
return !status; // Returns the value of the button - inverted so "true" means it was pressed, and "false" means it was not.
}

Button::Button(int pin, byte CmdAddress, byte SubAddress) // Contructor for buttons that directly send commands to the radio.
    {
      pinnumber = pin; // stores the value of the button's pin.
      command = CmdAddress; // stores its command (from the Icom CIV table for your rig)
      subcommand = SubAddress; // stores its subcommand (from the Icom CIV table for your rig).
    }

void Button::begin() // Begin function for a button used as above.  Sets up the digital pin for the button.
{
      pinMode(pinnumber, INPUT_PULLUP); 
}

bool Button::update() // Update function for a button used as above.  
 {
    if (digitalRead(pinnumber)==LOW) {
    delay(200); // (eliminate button bounce)
    return true; // Return true if pressed.
  }
  else return false; // Return false if pressed.
}

 void Button::Senddata(byte radio, byte ctrlr) // Function to send data to the radio when a button is pressed
 {
  for (int i=0; i<2; i++) {
    Serial1.write (header[i]); // Sent the header, which is FE FE
  }
  Serial1.write (radio); // Send the CIV address of the radio, which is defined in the main program.
  Serial1.write (ctrlr); // Send the CIV address of the controller, which is defined in the main program.
  Serial1.write (command); // Send the command byte
  Serial1.write (subcommand); // Send the subcommand byte
  Serial1.write (level); // Send the level of the button or dial
  Serial1.write (0xFD); // Send the footer byte FD
  Serial1.flush(); // wait until all data sent
  delay(10); // Small delay to let things settle
#ifdef DEBUG
  for (int i=0; i<2; i++) {
    Serial.write (header[i]); // Sent the header, which is FE FE
  }
  Serial.write (radio); // Send the CIV address of the radio, which is defined in the main program.
  Serial.write (ctrlr); // Send the CIV address of the controller, which is defined in the main program.
  Serial.write (command); // Send the command byte
  Serial.write (subcommand); // Send the subcommand byte
  Serial.write (level); // Send the level of the button or dial
  Serial.write (0xFD); // Send the footer byte FD
  Serial.flush(); // wait until all data sent
  delay(10);
#endif
  }

Controls::Controls(int pinU, int pinL, byte Command, byte Subcommand) : thisEncoder (pinU, pinL)
    {
      pinnumberu = pinU; // The pin corresponding to clockwise rotation of the dial
      pinnumberl = pinL; // The pin corresponding to counterclockwise rotation of the dial
      command = Command; // The command for the dial
      subcommand = Subcommand; // The subcommand for the dial
    }

void Controls::begin() // Set up the controls
{
pinMode(pinnumberu, INPUT_PULLUP);
pinMode(pinnumberl, INPUT_PULLUP);
}  

// The code below gets input from the dials.  It returns a value of true if a dial was turned.  Step corresponds to the increment multiplier (1 or 5) set by the coarse/fine adjustment

bool Controls::update(int step) { 
thisEncoder.tick();
controldir=thisEncoder.getDirection();
if (step == 1){
if ((level>0 && level <100)||(level == 0 && controldir >0) || (level == 100 & controldir <0)) {
level += controldir*step;
}
}
if (step == 5){
if ((level>4 && level <96)||(level <5 && controldir >0) || (level >94 && controldir <0)) {
level += controldir*step;
}
}
if (controldir != 0)
{
return true;
} 
else return false;
}

  void Controls::Senddata(byte radio, byte ctrlr)
 { 
// The following lines send an untranslated decimal number in hex format across two bytes.  i.e. 255 is sent as "0255".
  normlevel=level*256/100;
  data[0] = normlevel/100;
  data[1] = (normlevel%100/10*16)+normlevel%10;
 for (int j=0; j<2; j++) {
    Serial1.write (header[j]);
  }
  Serial1.write (radio);
  Serial1.write (ctrlr);
  Serial1.write (command);
  Serial1.write (subcommand);
  for (int i=0; i<2; i++) {
    Serial1.write (data[i]);
  }
  Serial1.write (0xFD);
Serial1.flush(); // wait until all data sent
success=true; // delete this line when implementing.
delay(10);
#ifdef DEBUG
 for (int j=0; j<2; j++) {
    Serial.write (header[j]);
  }
  Serial.write (radio);
  Serial.write (ctrlr);
  Serial.write (command);
  Serial.write (subcommand);
  for (int i=0; i<2; i++) {
    Serial.write (data[i]);
  }
  Serial.write (0xFD);
Serial.flush(); // wait until all data sent
#endif
 }

CIVPoll::CIVPoll (byte cmd, byte subcmd) // len is the length of the byte array for pull, cmd is the command, subcmd is the subcommand, datapull is the data.
    {
    command = cmd;
    subcommand = subcmd;
    }

  bool CIVPoll::UpdateCIV(byte radio, byte ctrlr)
 {
retrycount=0;
   for (int j=0; j<2; j++) {
  Serial1.write (header[j]);
   }
  Serial1.write (radio);
  Serial1.write (ctrlr);
  Serial1.write (command);
  Serial1.write (subcommand);
  Serial1.write (0xFD);
  Serial1.flush(); // wait until all data sent
while (Serial1.available() <1 ) {} // wait for radio
CAT_TRX_next:
if (Serial1.available() >0) {
  incomingTRX = Serial1.read();
       if ((incomingTRX == 254)   ) {            // look for an FE = start of CAT sequence , no overflow (mutilated string ?)
      goto CAT_TRX_start;                     // it is possibly a start !
    }
  delay (1);  // allow buffer to fill
if (retrycount<10) {
retrycount++;
  goto CAT_TRX_next;                         // no specific byte received, so keep monitoring buffer
}
else goto invalid;
  }

   //-------------------------------------------------------------------
CAT_TRX_start:                                   // 1st byte was a 254
  //-------------------------------------------------------------------

  delay (20);                                     // delay is required to allow buffer to fill : too low = buffer not filled ! Too high = not smooth response

  for (int i = 0; i < 10; i++) {                     // search for end,  9 bytes is the longest datagram

    if (Serial1.available() > 0) {           // there is dat in buffer !

      buffget_CAT[i] = Serial1.read();     // load buffget with next characters

      String byte_string = String(buffget_CAT[i], HEX);

      if (buffget_CAT[i] ==  253   ) {
        goto process_string_TRX;
      }                                           // end of string detected

      delay( 1 );                                 //delay 1 ms if true, leave time for buffer to work
    }
  }
 if (retrycount<10) {
retrycount++;
  goto CAT_TRX_start;                             
}
else goto invalid;
    //-------------------------------------------------------------------
process_string_TRX:                   // Process the string on TRX line
  //-------------------------------------------------------------------

  if ((buffget_CAT[0] == 254)) {      // is the 2nd character again an FE ?
retrycount=0;
    goto valid_string_TRX;               // yes, now process string !
  }

if (retrycount<10) {
retrycount++;
  goto CAT_TRX_next;                     // no, capture another CAT string ! 
}
else goto invalid;
  //-------------------------------------------------------------------
valid_string_TRX:                    // Process the string on TRX line
  //-------------------------------------------------------------------


      if (buffget_CAT[3] == command && buffget_CAT[4] == subcommand) { // It is a valid line based on our poll - go get the data.  It should be on byte 5

      // translate on CAT line
      //Serial1TRX.flush();  
      delay (20);
      if (command == 0x16) { // Get a 0 or 1 for all of our buttons.
        level = buffget_CAT[5]; // will be 0 or 1 if off or on.  
        return true;
      }
      if (command == 0x14) { // Get the number (0 to 255) for all of our controls.
        level = (buffget_CAT[5]&0x0F) * 100; // gets the 100s digit of the BCD data.
        level = level + (((buffget_CAT[6]>>4)*10)+(buffget_CAT[6]&0x0F)); // Gets the 10s and 1s digits and adds them.  We should now have 0 <=level<256;
        rawlevel = level*100/256; // Normalize this to 0-100, which is the range for all of our controls.
        level = rawlevel;
        if (level < 101) {
        return true; // go back to the main page.
}
else return false; // data is out of range, so do not update the display.
      }
      }

 invalid: // this routine runs if the serial buffer has bad data, and it dumps the buffer contents
while (Serial1.available()>0) {
bufferdump = Serial1.read(); // clear all serial buffer data
}
retrycount=0; // reset the counter
 return false;    // data was bad - return a false state so the display is not updated.
 }
  
