# -*- coding: utf-8 -*-

"""
F. Daout & J.C. Henaux
Etude d'une antenne End-Fire
Spring 2020
"""
from math import *
import easygui
import sys
from easygui import *
#*********************************************************************
# entree des caractéristiques de l'antenne
#*********************************************************************

#cotes=[1.7e-3,0.75e-3,0.5e-3,3,4,5,6,7,8,9,10,11,12,13,]

easygui.msgbox(msg="        'GUN ANTENNA'",image="lang_US_intro.gif",ok_button="continue")
# entrée de la fréquence
freq=easygui.enterbox(msg="working frequency  (GHz) ?  \nformat x.xxx, no comma !.\nThe program has not been checked out of the band 0.8 to 4.2GHz " )
try:
    Freq_Giga=float(freq)
except:
    print("The frequency is in a bad format, example of a correct format : 2.45, or 4, or 3.745")
    easygui.msgbox(msg="==>The frequency is in a bad format, example of a correct format : 2.45, or 4, or 3.745 \n  \n  only digits and one point\n\n  comma forbidden !")
    sys.exit(0)

 #entrée de la longueur du GOS
    ln=easygui.buttonbox(msg="length of the Surface Waveguide (unit=wavelength) :\n1->12.6dB,      2->14.7dB,      3->16.1dB,      4->17.1dB.",choices=('1','2','3','4'))
    Ln=int(ln)

#*********************************************************************
#valable pour Freq >2GHz

if Freq_Giga > 2 :


    #entrée de la longueur du GOS
    ln=easygui.buttonbox(msg="length of the Surface Waveguide (unit=wavelength) :\n1->12.6dB,      2->14.7dB,      3->16.1dB,      4->17.1dB.",choices=('1','2','3','4'))
    Ln=int(ln)

    if Ln==1: # Ln=1 Calcul des dimensions pour Freq >2GHz
        r_sma=1.7e-3
        r_pin=0.75e-3
        ep_tole=0.5e-3
        lambda_0=3e8/Freq_Giga*1e-9
        ecart_disc=lambda_0/4
        espace=lambda_0/16
        patch_dia=160.81*Freq_Giga**(-0.99306)*1e-3
        dist_patch=0.21*patch_dia/2
        dia_axe=0.09*patch_dia
        dia_ref=lambda_0
        ray_entree=patch_dia/2*(0.4119+0.41563*exp(-0.94142*Freq_Giga))
        indice=(1.0083*Ln)/(-0.18119+Ln)
        dia_disc=(-0.58131+1.2681*indice-0.38934*(indice*indice))*lambda_0
        gain="12.6dB"


# Ln=2  Calcul des dimensions pour Freq >2GHz
    elif Ln==2:
        r_pin=0.75e-3
        ep_tole=0.5e-3
        lambda_0=3e8/Freq_Giga*1e-9
        ecart_disc=lambda_0/4
        espace=lambda_0/16
        patch_dia=160.81*Freq_Giga**(-0.99306)*1e-3
        dist_patch=0.21*patch_dia/2
        dia_axe=0.09*patch_dia
        dia_ref=lambda_0
        ray_entree=patch_dia/2*(0.48084+1.0949*exp(-1.3193*Freq_Giga))
        indice=(1.0083*Ln)/(-0.18119+Ln)
        dia_disc=(-0.58131+1.2681*indice-0.38934*(indice*indice))*lambda_0
        gain="14.7dB"

 # Ln=3  Calcul des dimensions pour Freq >2GHz
    elif Ln==3:
        r_sma=1.7e-3
        r_pin=0.75e-3
        ep_tole=0.5e-3
        lambda_0=3e8/Freq_Giga*1e-9
        ecart_disc=lambda_0/4
        espace=lambda_0/16
        patch_dia=160.81*Freq_Giga**(-0.99306)*1e-3
        dist_patch=0.21*patch_dia/2
        dia_axe=0.09*patch_dia
        dia_ref=lambda_0
        ray_entree=patch_dia/2*(0.49665+0.55557*exp(-0.99546*Freq_Giga))
        indice=(1.0083*Ln)/(-0.18119+Ln)
        dia_disc=(-0.58131+1.2681*indice-0.38934*(indice*indice))*lambda_0
        gain="16.1dB"

# Ln=4  Calcul des dimensions pour Freq >2GHz
    elif Ln==4:
        r_sma=1.7e-3
        r_pin=0.75e-3
        ep_tole=0.5e-3
        lambda_0=3e8/Freq_Giga*1e-9
        ecart_disc=lambda_0/4
        espace=lambda_0/16
        patch_dia=161.67*Freq_Giga**(-0.99925)*1e-3  #fit special sur 4 valeurs
        dist_patch=0.21*patch_dia/2
        dia_axe=0.09*patch_dia
        dia_ref=lambda_0
        ray_entree=patch_dia/2*(0.49665+0.55557*exp(-0.99546*Freq_Giga))
        indice=(1.0083*Ln)/(-0.18119+Ln)
        dia_disc=(-0.58131+1.2681*indice-0.38934*(indice*indice))*lambda_0
        gain="17.1dB"

#*********************************************************************
#valable pour Freq >2GHz
if Freq_Giga <= 2 :


#entrée de la longueur du GOS  pour Freq <=2GHz
    ln=easygui.buttonbox(msg="length of the Surface Waveguide (unit=wavelength) :\n1->12.6dB,      2->14.7dB,      3->16.1dB,      4->17.1dB.",choices=('1','2','3','4'))
    Ln=int(ln)

# Ln=1 Calcul des dimensions pour Freq <=2GHz
    if Ln==1:
        r_sma=1.7e-3
        r_pin=0.75e-3
        ep_tole=0.5e-3
        lambda_0=3e8/Freq_Giga*1e-9
        ecart_disc=lambda_0/4
        espace=lambda_0/16
        patch_dia=(2.0103+162.51*(Freq_Giga**-1.0406))*1e-3
        dist_patch=0.21*patch_dia/2
        dia_axe=0.09*patch_dia
        dia_ref=lambda_0
        ray_entree=patch_dia/2*(0.45833+0.78742*exp(-1.8076*Freq_Giga))
        indice=(1.0083*Ln)/(-0.18119+Ln)
        dia_disc=(-0.58131+1.2681*indice-0.38934*(indice*indice))*lambda_0
        gain="12.6dB"

# Ln=2  Calcul des dimensions pour Freq <=2GHz
    elif Ln==2:
        r_sma=1.7e-3
        r_pin=0.75e-3
        ep_tole=0.5e-3
        lambda_0=3e8/Freq_Giga*1e-9
        ecart_disc=lambda_0/4
        espace=lambda_0/16
        patch_dia=(2.0103+162.51*(Freq_Giga**-1.0406))*1e-3
        dist_patch=0.21*patch_dia/2
        dia_axe=0.09*patch_dia
        dia_ref=lambda_0
        ray_entree=patch_dia/2*(0.54577+1.3488*exp(-2.2131*Freq_Giga))
        indice=(1.0083*Ln)/(-0.18119+Ln)
        dia_disc=(-0.58131+1.2681*indice-0.38934*(indice*indice))*lambda_0
        gain="14.7dB"

 # Ln=3  Calcul des dimensions pour Freq <=2GHz
    elif Ln==3:
        r_sma=1.7e-3
        r_pin=0.75e-3
        ep_tole=0.5e-3
        lambda_0=3e8/Freq_Giga*1e-9
        ecart_disc=lambda_0/4
        espace=lambda_0/16
        patch_dia=(2.0103+162.51*(Freq_Giga**-1.0406))*1e-3
        dist_patch=0.21*patch_dia/2
        dia_axe=0.09*patch_dia
        dia_ref=lambda_0
        ray_entree=patch_dia/2*(0.54635+1.126*exp(-1.8521*Freq_Giga))
        indice=(1.0083*Ln)/(-0.18119+Ln)
        dia_disc=(-0.58131+1.2681*indice-0.38934*(indice*indice))*lambda_0
        gain="16.1dB"

# Ln=4  Calcul des dimensions pour Freq <=2GHz
    elif Ln==4:
        r_sma=1.7e-3
        r_pin=0.75e-3
        ep_tole=0.5e-3
        lambda_0=3e8/Freq_Giga*1e-9
        ecart_disc=lambda_0/4
        espace=lambda_0/16
        patch_dia=(2.0103+162.51*(Freq_Giga**-1.0406))*1e-3
        dist_patch=0.21*patch_dia/2
        dia_axe=0.09*patch_dia
        dia_ref=lambda_0
        ray_entree=patch_dia/2*(0.54635+1.126*exp(-1.8521*Freq_Giga))
        indice=(1.0083*Ln)/(-0.18119+Ln)
        dia_disc=(-0.58131+1.2681*indice-0.38934*(indice*indice))*lambda_0
        gain="17.1dB"
 #***************************************************************
 # affichage preparation

l="length of the SWG: "+str(Ln)+"*Wavelength"+"\n"+"index of the SWG:"+str( round(indice,3))
a="Working Frequency: "+str(Freq_Giga)+" GHz "+"\n"+"Wavelength: "+str(round(lambda_0*1000,2))+" mm"
b="Full length of the antenna: "+str(round(lambda_0*1000*Ln+dist_patch*1000+espace*1000,1))+" mm"+"\n"+"******************************************"
c="thickness of the discs: 0.5 mm, non critical"
d="axis diameter: "+str(round(dia_axe*1000,1))+" mm or the closest available"
e="patch diameter : "+str(round(patch_dia*1000,2))+" mm ($)"
f="distance from the center of the SMA connector to the axis :"+str( round(ray_entree*1000,2))+" mm ($)"
g="reflector diameter : "+ str(round(dia_ref*1000,1))+" mm"
h="distance between patch and reflector: "+str( round(dist_patch*1000,2))+" mm ($)"
i="space between the patch and the first disc of the SWG : "+str( round(espace*1000,2 ))+" mm"
j="diameter of the SWG discs: "+str( round(dia_disc*1000,1))+" mm"
k="distance between the SWG discs: "+str(round(ecart_disc*1000,1))+" mm"+"\n"+"******************************************"
m="expected directivity :" + str(gain) +"\n\n\n($) précision : +-0.5% of the Wavelength "

#affichage
z=("\n"+a+"\n"+l+"\n"+b+"\n"+c+"\n"+d+"\n"+e+"\n"+f+"\n"+g+"\n"+h+"\n"+i+"\n"+j+"\n"+k+"\n"+"\n"+m)
print(z)
easygui.textbox(msg="Dimensions of a Gun Antenna", text=z)

# affichage preparation
#l="length of the Surface WaveGuide: "+str(Ln)+"*wavelength"+"\n"+"index of the SWG:"+str(round(indice,3))
#a="Working frequency: "+str(Freq_Giga)+" GHz "+"\n"+"wavelength: "+str(round(lambda_0*1000,2)
#b="longueur totale de l'antenne: "+str(round(lambda_0*1000*Ln+dist_patch*1000+espace*1000,1))+" mm"
#b="Full length of the antenna: "+str(round(lambda_0*1000*Ln+dist_patch*1000+espace*1000,1))+" mm"+"\n"+"******************************************"
#c="thicknes of metal sheet: 0.5 mm, non critical"
#d="diameter of the axis: "+str(round(dia_axe*1000,1))+" mm or close"
#e="diametre du patch: "+str(round(patch_dia*1000,2))+" mm($)"
#f="distance from the center of the SMA connector to the axis :"+str( round(ray_entree*1000,2))+" mm($)"
#g="reflector diameter : "+ str(round(dia_ref*1000,1))+" mm"
#h="distance patch-reflector: "+str( round(dist_patch*1000,2))+" mm"
#i="space between the patch and the first disc of the SWG : "+str( round(espace*1000,2 ))+" mm"
#j="diameter of the SWR discs: "+str( round(dia_disc*1000,1))+" mm"
#k="distance between the SWR discs: "+str(round(ecart_disc*1000,1))+" mm"+"\n"+"******************************************"
#m="expected directivity :" + str(gain) +"\n\n\n($) necessary précision +-0.5% of the wavelength"
#z=("\n"+a+"\n"+l+"\n"+b+"\n"+c+"\n"+d+"\n"+e+"\n"+f+"\n"+g+"\n"+h+"\n"+i+"\n"+j+"\n"+k+"\n"+"\n"+m)
#print(z)
#easygui.textbox(msg="Dimensions of a Gun Antenna, reflector diameter : 1 wavelength", text=z)