Pascal Source Code Listing


{$C-,U-}
program freqcnt;
const baseaddr = $300;
type count = array[0..6] of byte;

procedure scanclk(control:byte);
var qc: byte;
begin
     qc := control AND $DF; {scan clock low}
     port[baseaddr] := qc;
     qc := control OR $20; {scan clock high}
     port[baseaddr] := qc;
end;

procedure getcount(control:byte; var data:count);
var xc,dc,dct: byte;
begin
     xc := control;
     dc := port[baseaddr];
     data[1] := dc SHR 4;
     data[0] := dc AND $0F;
     dc := port[baseaddr + 1];
     data[6] := dc AND $0F;
     xc := xc AND $F7; {remove scan master reset}
     port[baseaddr] := xc;
     scanclk(xc);
     dc := port[baseaddr + 1];
     data[5] := dc AND $0F;
     scanclk(xc);
     dc := port[baseaddr + 1];
     data[4] := dc AND $0F;
     scanclk(xc);
     dc := port[baseaddr + 1];
     data[3] := dc AND $0F;
     scanclk(xc);
     dc := port[baseaddr + 1];
     data[2] := dc AND $0F;
     port[baseaddr] := control;
end;

var i: integer;
    d, control: byte;
    data: count;
    gate,prescale,lz,dsj: boolean;
    freq, pp: real;
    xk: char;
label start;

begin
     prescale := False;
     gate := True;  {True => short gate}
     dsj := True;
start:
     if KeyPressed then
        begin
        read(Kbd,xk);
        if (xk = Char(27)) then
           begin
                dsj := True;
                read(Kbd,xk);
                if (xk = Char(68)) then prescale := NOT prescale;
                if (xk = Char(59)) then gate := NOT gate;
                if (xk = Char(60)) then Halt;
           end;
        if (xk = 'x') then Halt;
        if prescale then gate := True;
        end;
     control := $FF;
     if gate then control := control AND $FE;
     if prescale then control := control AND $FD;
     port[baseaddr] := control;
     control := control AND $FB;
     delay(1000);
     port[baseaddr] := control; {remove clear}
     port[baseaddr + 3] := $80; {arm gate}
     repeat
     d := port[baseaddr + 2];
     d := d AND $80;
     until (d = $80);
     repeat
     d := port[baseaddr + 2];
     d := d AND $80;
     until (d = $0);
     getcount(control,data);
     if dsj then begin
        ClrScr;
        Writeln('                Frequency Counter');
        Writeln;
        Writeln('                    F1    1 Second Gate / 0.1 Second Gate');
        Writeln('                    F10   Direct Input / Prescaler');
        Writeln('                    x     Exit');
        Writeln;
        Writeln;
        Writeln;
        Write('                Input source: ');
        if (prescale) then writeln('prescaler (50 Ohm)') else writeln('direct');
        Write('                Gate: ');
        if (gate) then writeln('0.1 second') else writeln('1 second');
        Write('                Maximum Input Frequency: ');
        if (prescale) then writeln('1 GHz') else
           if (gate) then writeln('40 MHz') else writeln('9.9 MHz');
        dsj := False;
     end;
     GotoXY(1,14);
     ClrEol;
     lz := False;
     if (gate AND NOT prescale) then
        begin
        Write('                        ');
        for i := 6 downto 3 do
            begin
                 if ((data[i] = 0) AND NOT lz) then write(' ')
                    else begin
                              write(data[i]);
                              if (i = 5) then write(',');
                              lz := True;
                         end;
            end;
        write(data[2],'.');
        for i := 1 downto 0 do write(data[i]);
        writeln('      kiloHertz');
        end;
     if ((NOT gate) and (NOT prescale)) then
        begin
        Write('                        ');
        for i := 6 downto 1 do
            begin
                 if ((data[i] = 0) AND NOT lz) then write(' ')
                    else begin
                              write(data[i]);
                              if ((i = 6) OR (i = 3)) then write(',');
                              lz := True;
                         end;
            end;
        writeln(data[0],'      Hertz');
        end;
     if (prescale) then
        begin
        freq := 0;
        pp := 1;
        for i := 0 to 6 do
            begin
                 freq := freq + pp*data[i];
                 pp := pp*10.0;
            end;
        freq := freq*64.0/1000000.0;
        if (gate) then freq := freq*10.0;
        Write('                        ');
        writeln(freq:10:4,'      MegaHertz');
        end;
     goto start;
end.

