/*
 * fpp.h
 *
 * Header file for the FPP project.
 * Define __MSDOS__ for a Win32 console mode application.
 * Define __MSDOS__ and DOSTIMER for the DOS version.
 *
 * Revision history:
 *
 * 30-Oct-2001: V-0.0; created
 * 01-Nov-2001: V-0.1; added mess.c functions
 * 15-Nov-2001: V-0.2; updated to list ALL globals
 * 18-Nov-2001: V-0.3; added reg.c functions
 *
 * Copyright (C) 2001 David Tait.  All rights reserved.
 * Permission is granted to use, modify, or redistribute this software
 * so long as it is not sold or exploited for profit.
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED.
 *
 */

#ifndef __FPP_H
#define __FPP_H

#ifndef __MSDOS__	     /* if not for DOS its for WIN32 */
#ifndef __WIN32__
#define __WIN32__
#endif
#endif	/* __MSDOS__ */

#include "version.h"
#include "hex.h"
#include "conio.h"
#include "timer.h"
#include "hw.h"

#ifdef __WIN32__
#undef getch
#define getch() getc(stdin)  /* getch doesn't work in Windows */
#endif

#define SUCCESS 0	     /* exit return status */
#define FAIL	1

#define PBASE	0	     /* logical addresses for all PICs */
#define IBASE	0x2000
#define CBASE	0x2007
#define DBASE	0x2100

typedef struct {
    char *part;
    int pn;
    int pm;
    int dm;
} DEVICE;

       /*
	* All globals (and there are too many!) are defined here
	* even if they are already defined in another include file.
	* Hopefully, if you are struggling to understand this
	* program this list will help you.  To prevent the unnecessary
	* inclusion of windows.h, the Windows specific globals are
	* listed in comments
	*
	*/

		     /* globals in main.c */

/* extern HISTANCE hInst	instance handle returned by WinMain */
extern int got_console;      /* true if console is attached */

		     /* globals in fppgui.c */

/* extern HWND hDlg;		GUI window handle */

		     /* globals in fpp.c */

extern int psize;	     /* program (code) memory size in words */
extern int dsize;	     /* data memory size in bytes */
extern int debug;	     /* true if debug requested */
extern int usewin;	     /* use Windows GUI if true */
extern int mplab;	     /* allow some vital messages if true */
extern int silent;	     /* no text output (mplab overrides) */
extern int no_read;	     /* do not read from PIC if true */
extern int mode;	     /* either STOP or GO */
extern int setcfg;	     /* true if config set by command-line or GUI */
extern int setid;	     /* true if ID is set by GUI */
extern int pause;	     /* pause before quitting */
extern char *part;	     /* part number */
extern DEVICE device[];      /* list of known devices and sizes */


		     /* globals in hex.c */

extern U16 progbuf[MAXPM];   /* program memory */
extern U16 databuf[MAXDM];   /* EEDATA memory */
extern U16 idbuf[4];	     /* ID words */
extern U16 config;	     /* config word */
extern int pmlast;	     /* last program memory address loaded */
extern int dmlast;	     /* last EEDATA memory address loaded */
extern int id;		     /* 0 or IBASE if loaded */
extern int cf;		     /* 0 or CBASE if loaded */
extern int format;	     /* determines load/dump style */

		     /* globals in hw.c */

extern HWSETUP known[];      /* known setups */
extern int bases[];	     /* I/O port base addresses */
extern int prgdly;	     /* programming cycle delay */
extern int pwrdly;	     /* VDD to PGM and PGM to MCLR delay */
extern int tdly;	     /* tiny (I/O) delay */
extern int dumpfmt;	     /* hex dump format set by the environment */
extern int can_read;	     /* hardware can read PIC */
extern int can_run;	     /* whether the hardware supports GO mode */
extern int wait;	     /* true if prog mode is asserted manually */
extern int valid;	     /* whether hardware is defined and seems OK */
extern int hwport;	     /* hardware port number */
extern HW hw;		     /* struct describing hardware */

		     /* functions in main.c */

#ifdef __WIN32__
void get_console(void);
#else
#define get_console()
#endif

		     /* functions in fpp.c */

int fpp(int argc, char *argv[]);
void usage(void);
int program_code(void);
int program_data(void);
int program_ID(void);
int program_conf(void);
int verify_code(void);
int verify_data(void);
int verify_ID(void);
int verify_conf(void);
int read_code(void);
int read_data(void);
int read_ID(void);
int read_conf(void);
void erase_code(void);
void erase_data(void);
void erase_all(void);
int load_all(FILE *fp);
void save_all(FILE *fp);

		     /* functions in mess.c */

void errmsg(char *s);
void info(const char *fmt, ...);
void message(const char *fmt, ...);
void quit(char *s, int status);
int query(char *s, int yn);

		     /* functions in hw.c */

unsigned inval(void);
void assertp(int doit);
void outlo(int doit);
void clklo(int doit);
void vddlo(int doit);
void mclrlo(int doit);
void pgmlo(int doit);
void readlo(int doit);
void outhi(int doit);
void clkhi(int doit);
void vddhi(int doit);
void mclrhi(int doit);
void pgmhi(int doit);
void readhi(int doit);
int sethws(char *s);
int hws2hw(HW *h);
void hw2hws(HW *h);
int setup(void);
void run_mode(int mode);
void prog_mode(void);
void out_word(int w);
int in_word(void);
void command(int cmd);
void cleanup(void);

		     /* functions in hex.c */

int loadhex(FILE *fp, int psize, int dsize, int ibase, int cbase, int dbase);
void dumphex(FILE *fp, int psize, int dsize, int ibase, int cbase, int dbase);
void erasehex(int psize, int dsize, int ws);
char *errhex(int e);
int hex(int c);

		     /* functions in timer.c */

void us_delay(int ticks);

		     /* functions in fppgui.c */

int fppgui(void);

		     /* functions in reg.c */
#ifdef __WIN32__
int reg_open(void);
void reg_getall(void);
void reg_putall(void);
int reg_close(void);
int reg_purge(void);
#else /* !__WIN32__ */
#define reg_open()
#define reg_getall()
#define reg_putall()
#define reg_close()
#define reg_purge()
#endif /* __WIN32__ */

#endif /* __FPP_H */

