/*
 * hw.h
 *
 * Header file for hardware-level routines.
 *
 * Revision history:
 *
 * 17-Oct-2001: V-0.0; created
 * 30-Oct-2001: V-0.1; moved some definitions to fpp.h
 * 16-Oct-2001: V-0.1; added definitions for Setup dialogue
 *
 * Copyright (C) 2001 David Tait.  All rights reserved.
 * Permission is granted to use, modify, or redistribute this software
 * so long as it is not sold or exploited for profit.
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED.
 *
 */

#ifndef __HW_H
#define __HW_H

#define STOP     0
#define GO       1

#define PARALLEL 0
#define SERIAL   1

#define TDLY            TICKS(5)     /* default I/O delay (5us) */
#define CYCLE           20           /* default prog cycle delay (20ms) */
#define PWRDLY          25           /* default power-up delay (25ms) */

#define PHWSSIZE 20            /* H/W descriptor length for LPT port */
#define SHWSSIZE 12            /* and for COM port */

typedef struct {
    int hwid;
    char *hws;
    char *hwname;
} HWSETUP;

typedef struct {
    int type;           /* either SERIAL or PARALLEL */
    int icsp;           /* true if ICSP cabable (i.e. supports GO mode) */
    int manual;         /* true if prog mode is enabled manually */
    int outpin;         /* physical pin numbers, -ve if signal is inverted */
    int clkpin;
    int inpin;
    int vddpin;
    int mclrpin;
    int pgmpin;
    int readpin;
    int hwid;           /* ID if a known setup or -1 if user defined */
    char *hws;          /* all the above encoded as a string */
    char *hwname;       /* name of this setup */
} HW;


extern HWSETUP known[];      /* known setups */
extern int bases[];          /* I/O port base addresses */
extern int prgdly;           /* programming cycle delay */
extern int pwrdly;           /* VDD to PGM and PGM to MCLR delay */
extern int tdly;             /* tiny (I/O) delay */
extern int dumpfmt;          /* hex dump format set by the environment */
extern int can_read;         /* whether hardware can read PIC */
extern int can_run;          /* whether the hardware supports GO mode */
extern int wait;             /* true if prog mode is asserted manually */
extern int hwport;           /* hardware port number */
extern int valid;            /* whether hardware is defined and seems OK */
extern HW hw;                /* struct describing hardware */


unsigned inval(void);
void assertp(int doit);
void outlo(int doit);
void clklo(int doit);
void vddlo(int doit);
void mclrlo(int doit);
void pgmlo(int doit);
void readlo(int doit);
void outhi(int doit);
void clkhi(int doit);
void vddhi(int doit);
void mclrhi(int doit);
void pgmhi(int doit);
void readhi(int doit);
int sethws(char *s);
int hws2hw(HW *h);
void hw2hws(HW *h);
int setup(void);
void run_mode(int mode);
void prog_mode(void);
void out_word(int w);
int in_word(void);
void command(int cmd);
void cleanup(void);

#endif  /* __HW_H */
