/*
 * inout.c
 *
 * Port I/O for MinGW.
 *
 * Revision history:
 *
 * 01-Dec-2001: V-0.0; created
 *
 * Copyright (C) 2001 David Tait.  All rights reserved.
 * Permission is granted to use, modify, or redistribute this software
 * so long as it is not sold or exploited for profit.
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED.
 *
 */


static unsigned char b;   /* the use of global variables is intentional so */
static unsigned short p;  /* arg passing details are left to the compiler */

unsigned char inportb(unsigned short port)
{
    p = port;

    __asm__ ("movw  _p,%dx\n\t"
	     "in    %dx,%al\n\t"
	     "movb  %al,_b");

    return b;
}


void outportb(unsigned short port, unsigned char c)
{
   p = port;
   b = c;

   __asm__ ("movw   _p,%dx\n\t"
	    "movb   _b,%al\n\t"
	    "out    %al,%dx");
}



