/*
 * main.c
 *
 * Choose between main() or WinMain() startup.
 *
 * Revision history:
 *
 * 07-Nov-2001: V-0.0; created
 *
 * Copyright (C) 2001 David Tait.  All rights reserved.
 * Permission is granted to use, modify, or redistribute this software
 * so long as it is not sold or exploited for profit.
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED.
 *
 */

#include "fpp.h"
#ifdef __WIN32__
#include <windows.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include "resource.h"
#ifdef __LCC__
#define _fdopen fdopen
#endif	/* __LCC__ */
#define MAX_ARGS 100

HINSTANCE hInst;
int got_console = 0;


static char *skipws(char *sp)
{
    while ( *sp == ' ' || *sp == '\t' )
       ++sp;
    return sp;
}

static char *markeos(char *sp)
{
    while ( *sp && *sp != ' ' && *sp != '\t' )
       ++sp;
    if ( *sp )
       *sp++ = 0;
    return sp;
}


int APIENTRY WinMain(HINSTANCE h, HINSTANCE hp, LPSTR cl, int show)
{
    static char *argv[MAX_ARGS] = {NULL};
    int argc = 1;
    char *sp;
    WNDCLASS wc;

    memset(&argv, 0, MAX_ARGS);

    if ( !got_console )
	argv[argc++] = "-w1";

    sp = cl;	     /* convert WinMain command line to argc, argv form */
    while ( *(sp = skipws(sp)) ) {
	argv[argc++] = sp;
	if ( (sp = markeos(sp)) == 0 )
	    break;
    }

    memset(&wc, 0, sizeof(wc));
    wc.lpfnWndProc = DefDlgProc;
    wc.cbWndExtra = DLGWINDOWEXTRA;
    wc.hInstance = h;
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hIcon = LoadIcon(h, MAKEINTRESOURCE(IDC_FPPICON));
    wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wc.lpszClassName = PNAME;
    RegisterClass(&wc);
    hInst = h;

    return fpp(argc, argv);
}


void get_console(void)
{
    int hIO;
    FILE *fp;

    AllocConsole();
    got_console = 1;
    hIO = _open_osfhandle((long) GetStdHandle(STD_OUTPUT_HANDLE),
			   _O_TEXT );
    fp = _fdopen( hIO, "w" );
    *stdout = *fp;

    hIO = _open_osfhandle((long) GetStdHandle(STD_INPUT_HANDLE),
			    _O_RDONLY | _O_TEXT );
    fp = _fdopen( hIO, "r" );
    *stdin = *fp;

    setvbuf(stdout, NULL, _IONBF, 0);
    setvbuf(stdin, NULL, _IONBF, 0);
}

#else /* __MSDOS__ */

int got_console = 1;

int main(int argc, char *argv[])
{
    return fpp(argc, argv);
}

#endif /* __MSDOS__ */
