/*
 * mess.c
 *
 * Routines to print messages and ask for confirmation.
 *
 * Revision history:
 *
 * 01-Nov-2001: V-0.0; created
 *
 * Copyright (C) 2001 David Tait.  All rights reserved.
 * Permission is granted to use, modify, or redistribute this software
 * so long as it is not sold or exploited for profit.
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED.
 *
 */
#include "fpp.h"
#ifdef __WIN32__
#include <windows.h>
extern HWND hDlg;	 /* defined in fppgui.c */
#endif
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>


       /* errmsg()
        *
        * Print (and display in a box) an error message.
        * Override the silent flag if mplab flag is true.
        *
        */

void errmsg(char *s)
{
    info((silent && !mplab)?"":"%s: %s\n",PNAME,s);
#ifdef __WIN32__
    if ( mplab || !got_console )
        MessageBox(hDlg, s,
                   TEXT(PNAME), MB_ICONERROR | MB_OK );
#endif
}


       /* query()
        *
        * Either waits for "any key"/Control-C or (if yn=1) for 'y'/'n'.
        *
        */

int query(char *s, int yn)
{
    char c = 'Y';

    if ( mplab || !got_console ) {
#ifdef __WIN32__
         if ( MessageBox(hDlg, s,
                         TEXT(PNAME),
                         MB_ICONQUESTION | MB_OKCANCEL) != 1 )
             c = 3;		       /* Control C */
#endif
    } else {
        info("%s%s",s, yn?" (y/n) ":" ");
        c = getch()&0x5F;	       /* get upper case char */
        info("\n\n");
    }
    if ( yn )
        return (c=='Y')? 1: 0;
    else
        return (c!=3)? 1: 0;
}


         /* message()
          *
          * Print a message (or not depending on the silent flag).
          *
          */

void message(const char *fmt, ...)
{
    va_list argp;

    if ( silent || !got_console )
        return;
    va_start(argp, fmt);
    vprintf(fmt, argp);
    va_end(argp);
}


         /* info()
          *
          * Print a message regardless of the silent flag
          *
          */


void info(const char *fmt, ...)
{
    va_list argp;

    if ( !got_console )
        return;
    va_start(argp, fmt);
    vprintf(fmt, argp);
    va_end(argp);
}


       /* quit()
        *
        * Terminates the program and prints an error message if
        * failed, otherwise runs or halts the PIC depending on the
        * mode flag.
        *
        */

void quit(char *s, int status)
{
    if ( s && status == FAIL )
        errmsg(s);
    if ( valid ) {
        if ( status != FAIL && mode == GO )
            run_mode(GO);
        else
            run_mode(STOP);
    }
    cleanup();
    if ( pause )
        query("\nHit <ENTER> to continue ...", 0);
    exit(status);
}
