/*
 * reg.c
 *
 * Handle registry information.
 *
 * Revision history:
 *
 * 18-Nov-2001: V-0.0; created
 *
 * Copyright (C) 2001 David Tait.  All rights reserved.
 * Permission is granted to use, modify, or redistribute this software
 * so long as it is not sold or exploited for profit.
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED.
 *
 */

#include "fpp.h"
#ifdef __WIN32__
#include <windows.h>
#include <tchar.h>
#include <string.h>
#include "version.h"


#define ROOT        HKEY_CURRENT_USER
#define TAITKEY     "Software\\David_Tait"
#define FPPKEY      "Software\\David_Tait\\FPP"
#define MAXSIZE     100             /* max value size should be 21 chars */


static HKEY hKey = NULL;
static char hwnamebuf[MAXSIZE];
static char hwsbuf[MAXSIZE];
static char partbuf[MAXSIZE];
static char version[MAXSIZE];       /* not used at present */


       /* regopen()
        *
        * Open registry key or create it then open it.  Returns 0
        * if the key already existed, 1 if not and -1 if the key
        * can't be opened or created.
        *
        */

int reg_open(void)
{
    DWORD d;

    if ( hKey )
       return 1;

    if ( RegCreateKeyEx(ROOT, TAITKEY, 0, NULL,
                        REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
                        NULL, &hKey, &d) != ERROR_SUCCESS )
        return -1;
    RegCloseKey(hKey);
    if ( RegCreateKeyEx(ROOT, FPPKEY, 0, NULL,
                        REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
                        NULL, &hKey, &d) != ERROR_SUCCESS )
        return -1;
    if ( d == REG_CREATED_NEW_KEY ) {
        reg_putall();
        return 1;
    }
    return 0;
}

int reg_close(void)
{
    HKEY h = hKey;

    if ( hKey ) {
       hKey = NULL;
       return (RegCloseKey(h) == ERROR_SUCCESS)? 0: -1;
    }
    return 0;
}


static int reg_getint(TCHAR *s)
{
    char value[MAXSIZE];
    DWORD size = MAXSIZE;

    if ( RegQueryValueEx(hKey, s, NULL, NULL, (LPBYTE) &value, &size)
                                                != ERROR_SUCCESS )
        return 0;
    return  *((int *) value);
}

static void reg_gets(TCHAR *s, char *dest)
{
    DWORD size = MAXSIZE;

    if ( RegQueryValueEx(hKey, s, NULL, NULL, dest, &size)
                                               != ERROR_SUCCESS )
        *dest = '\0';
}

void reg_getall(void)
{
    reg_gets(TEXT("Version"), version);
    reg_gets(TEXT("Part"), partbuf);
    part = partbuf;
    reg_gets(TEXT("Programmer"), hwnamebuf);
    hw.hwname = hwnamebuf;
    reg_gets(TEXT("Setup"), hwsbuf);
    hw.hws = hwsbuf;
    hw.hwid = reg_getint(TEXT("ID"));
    psize = reg_getint(TEXT("Psize"));
    dsize = reg_getint(TEXT("Dsize"));
    hwport = reg_getint(TEXT("Port"));
    prgdly = reg_getint(TEXT("Cycle"));
    pwrdly = reg_getint(TEXT("Pwrup"));
    tdly = reg_getint(TEXT("IOdly"));
}


static void reg_puts(TCHAR *v, char *s)
{
    if ( s == NULL )
        s = "";

    RegSetValueEx(hKey, v, 0, REG_SZ, s, strlen(s)+1);
}

static void reg_putint(TCHAR *v, int n)
{
    DWORD data = n;

    RegSetValueEx(hKey, v, 0, REG_DWORD, (BYTE *) &data, sizeof(DWORD));
}


void reg_putall(void)
{
    reg_puts(TEXT("Version"), VERSION);
    reg_puts(TEXT("Part"), part);
    reg_puts(TEXT("Programmer"), hw.hwname);
    reg_puts(TEXT("Setup"), hw.hws);
    reg_putint(TEXT("ID"), hw.hwid);
    reg_putint(TEXT("Psize"), psize);
    reg_putint(TEXT("Dsize"), dsize);
    reg_putint(TEXT("Port"), hwport);
    reg_putint(TEXT("Cycle"), prgdly);
    reg_putint(TEXT("Pwrup"), pwrdly);
    reg_putint(TEXT("IOdly"), tdly);
}

int reg_purge(void)
{
    HKEY h;

    reg_close();
    if ( RegOpenKeyEx(ROOT, TAITKEY, 0, KEY_ALL_ACCESS, &h)
                                              == ERROR_SUCCESS ) {
        RegDeleteKey(h, "FPP");
        RegCloseKey(h);
        RegDeleteKey(ROOT, TAITKEY);
        return 0;
    }
    return 1;
}

#endif  /* __WIN32__ */
