;=====================rotor672.asm=======================
;	for automatic operation of antenna rotor
; program for "ROTORMAPIC" by Roger Monroe K7NTW
;========================================================
	list	p=12c672
	__config	h'3fe4'	;pwr on reset,WDT off,
;				code protect off,internal rc
;				external master clear	
	radix	hex
	errorlevel 1, -302
;-------------------------------------------------------
;	cpu equates (memory map)
gpio	equ	0x05	;I/O
status	equ	0x03	;flag register
adcon0	equ	0x1f	;A/D operation control
adcon1	equ	0x9f	;A/D port pin config
adres	equ	0x1e	;A/D result register
intcon	equ	0x0b	;interrupt control
count	equ	0X20	;|delay    |
mcount	equ	0x21	;|routine  |
ncount	equ	0x22	;|counting | 
ocount	equ	0x23	;|registers|
knob	equ	0x24	;knob position kept here
ant	equ	0x25	;antenna position kept here
pcount	equ	0x26	;|loop |
rcount	equ	0x27	;|count|
scount	equ	0x28	;single pass flag reg
tcount	equ	0x29	;motor stall register
trisa	equ	0x85	;renamed tris register
osccal	equ	0x8f	;internal osc cal register
;-------------------------------------------------------
;	bit equates
rp0	equ	5	;status reg bank select
z	equ	2	;status reg zero bit
dband 	equ	2	;dead band parameter
cw_	equ	4	;cw relay
ccw_	equ	2	;ccw relay
brak_	equ	5	;brake relay and motor xfmr
;------------------------------------------------------------
	org	0x00
;------------------------------------------------------------
	call	07FEh	;get trim value for internal RC clock
	movwf	osccal	;stuff it in register
;-------------------------------------------------------------
;-----------input and output setup----------------------------
start	bsf	status,rp0	;select bank 1
	movlw	b'00001011'	;AN0,1,MCLR-inputs GP2,4,5-out
	movwf	trisa
	movlw	b'00000100'	;GP4,2-digital AN0,1-analog
	movwf	adcon1
	bcf	status,rp0	;select bank 0
	clrf	gpio		;turn off relays
	bcf	intcon,7	;disable all interrupts
;-------------------------------------------------------------
;----------main loop reset------------------------------------
looprs	movlw	d'14'		;set motor stuck time out
	movwf	rcount		;& resets @ antenna stop 
	clrf	scount		;set first trip thru loop flag
	clrf	pcount		;reset loop count
;-------------------------------------------------------------
;----get analog readings from knob and antenna pots-----------
knobloc	movlw	b'11000001'	;sel AN0,internal rc osc
	movwf	adcon0
	call	del_20		;20 microsecond
	bsf	adcon0,2
testnob	btfsc	adcon0,2
	goto	testnob		;loop untill busy flag cleared
	movf	adres,w		;retreve A/D data
	movwf	knob		;save knob position
antloc	movlw	b'11001001'	;config a/d sel AN1
	movwf	adcon0		;and repeat for potentometer
	call	del_20		;at antenna end
	bsf	adcon0,2
testant	btfsc	adcon0,2
	goto	testant
	movf	adres,w
	movwf	ant		;save antenna position
;--------------------------------------------------------------
;------------------compare potentiometer readings--------------
knbant	movf	knob,w
	subwf	ant,w		;compare knob to antenna
	btfss	status,0
	goto	antknb		;test for antilogical condition
	sublw	dband		;put in some dead band
	btfss	status,0
	goto	ftcw		;go move antenna
	goto	pwrdwn		;stop movment and apply brake
ftcw	movf	scount,1	;allow only one trip thru
	btfsc	status,z	;unstick routine
	goto	cwus		;backs up to help jammed brake
	goto	cw		;then keep turning ant
antknb	movf	ant,w		;compare antenna to knob
	subwf	knob,w		;if they are = stop
	btfss	status,0
	goto	pwrdwn
	sublw	dband
	btfss	status,0	;default to stop
	goto	ftccw		;first trip
	goto	pwrdwn
ftccw	movf	scount,1
	btfsc	status,z
	goto	ccwus		;unstick routine
	goto	ccw		;move direction
pwrdwn	movf	scount,1	;test trip flag to skip over 5
	btfsc	status,z	;sec delay routine when waiting
	goto	knobloc		;for initial knob movement.
	bcf	gpio,ccw_	;turn off motor direction relays
	bcf	gpio,cw_	;followed by transformer pri
	call	del_5s		;after 5 second delay
	bcf	gpio,brak_	;which applys brake
	goto	looprs		;loop again with reset
;------------------------------------------------------------
;----------counter clockwise rotation------------------------
ccw	movlw	b'00100100'	;apply brake release power &
	movwf	gpio		;motor direction relay
	call	hyst		;50 millisecond delay
	decfsz	pcount,1	;accumlate enough trips
	goto	knobloc		;through nested loop
	decfsz	rcount,1	;counters means ant stalled
	goto	knobloc		;keep moving till at new pos
	goto	stall		;it stalled !
;-------------------------------------------------------------
;-----------clockwise rotation--------------------------------
cw	movlw	b'00110000'	;other direction
	movwf	gpio
	call	hyst
	decfsz	pcount,1
	goto 	knobloc
	decfsz	rcount,1
	goto	knobloc
	goto	stall
;------------------------------------------------------------
;-----------unstick jammed brake wedge-----------------------
ccwus	movlw	b'00110000'	;first back up antenna
	movwf	gpio
	call	delhsec		;for short blip
	movlw	b'00100000'	;wait for inertia 
	movwf	gpio
	call	delhsec
	movlw	b'00100100'	;then ahead for same time
	movwf	gpio
	call	delhsec
	decf	scount,1	;1st trip done flag it
	goto	ccw		;and continue turning ant
cwus	movlw	b'00100100'	
	movwf	gpio
	call	delhsec
	movlw	b'00100000'
	movwf	gpio
	call	delhsec
	movlw	b'00110000'
	movwf	gpio
	call	delhsec
	decf	scount,1
	goto	cw
;---------------------------------------------------------
;---------------motor jam handled here--------------------
stall	movlw	d'15'		;flash lights 15 times
	movwf	tcount
blink	movlw	b'00010100'	;brk/motor xfmr off 
	movwf	gpio		;and direction relays on
	call	del_1s		;on for 1 second
	clrf	gpio		;lights out
	call	del_1s		;for 1 second
	decfsz	tcount,1	;done ?
	goto	blink		;no loop till done
hang	goto	hang		;controller halts here
;---------------------------------------------------------
;-----------------time delay counters---------------------
del_20	movlw	0x07	;20 microsecond delay
	movwf	count
repeat	decfsz	count
	goto	repeat
	return
;---------------------------------------------------------
hyst	movlw	d'129'	;50 millisecond delay
	movwf	mcount
loadn	movlw	d'129'
	movwf	ncount
decn	decfsz	ncount,f
	goto	decn
	decfsz	mcount,f
	goto	loadn
	return
;----------------------------------------------------------
del_5s	movlw	d'25'	;5 second delay
	movwf	ocount
	call	oload
	return
;----------------------------------------------------------
del_1s	movlw	d'5'	;1 second delay
	movwf	ocount
	call	oload
	return
;----------------------------------------------------------
delhsec	movlw	d'3'	;about .6 second delay
	movwf	ocount
	call	oload
	return
;----------------------------------------------------------
oload	movlw	d'255'
	movwf	mcount
nload	movlw	d'255'
	movwf	ncount
nmin	decfsz	ncount
	goto	nmin
	decfsz	mcount
	goto	nload
	decfsz	ocount
	goto	oload
	return
	end

