#include <MONITOR.H>

char outstring[16];
byte memnum,curmem,j,oldmemnum,tdelay,i;
byte mem1,mem2;
long tottime, currtime;



void bumpcount(){   // increments current memory time
   mem1 = read_eeprom(2*curmem+1);
   mem1++;
   write_eeprom(2*curmem+1,mem1);
   if (mem1==0){
         mem2 = read_eeprom(2*curmem+2);
         mem2++;
         write_eeprom(2*curmem+2,mem2);
   }

}
void nextmem(){
   curmem++;
   if (curmem==memnum) {
       (curmem = 0);
   }
   output_high(PIN_B4);
   delay_ms(350);               //  Select the next memory.
   output_low(PIN_B4);
}
void delayasec(){
   delay_ms(1000);
}
void pad(int padnum){
   for (i=0;i<padnum;i++) (putc(' '));
}

void printmem(){
  putc(12);
 printf("Mem #%u:",(curmem+1));
  if (curmem < 9) (pad(2));
   else (pad(1));

}


void output(){
         byte dig1, dig2, dig3,dig4;
         mem1 = read_eeprom(62);
         mem2 = read_eeprom(63);
         tottime = (mem2*256)+mem1;
         mem1 = read_eeprom(2*curmem+1);
         mem2 = read_eeprom(2*curmem+2);
         currtime = ((mem2*256)+mem1);

         dig1 = (currtime*10)/tottime;
         dig2 = (((currtime*10)%tottime)*10)/tottime;
         dig3 = (((((currtime*10)%tottime)*10)%tottime)*10)/tottime;
         dig4 = (((((((currtime*10)%tottime)*10)%tottime)*10)%tottime)*10)/tottime;
         printmem();

         printf("%u%u.",dig1,dig2);
         printf("%u%u %%",dig3,dig4);

 }

void bumptotal(){
   mem1 = read_eeprom(62);
   mem1++;
   write_eeprom(62,mem1);
   if (mem1 == 0){
      mem2 = read_eeprom(63);
      mem2++;
      write_eeprom(63,mem2);
   }

}
Main() {
   set_tris_b(0xEF);
   set_tris_a(0xF6);
   output_low(Pin_B4);
   output_low(PIN_A0);
   setup_counters(RTCC_INTERNAL,RTCC_DIV_2);
   port_b_pullups(TRUE);
   delayasec();
   delayasec();
   delayasec();
   memnum = READ_EEPROM(0);
   if (memnum == 0xFF) goto restart;            //go to restart if this is the first run
   tdelay = 3;

normal:
     curmem= 0;
     j = memnum;  //if starting over, force bumptotal.
resume:
     while(input(PIN_B0)){
          if (j == memnum){
            bumptotal();
            j = 0;
         }
         printmem();
         pad(8);
         if (!input(PIN_B2)){
               tdelay--;
               if (tdelay == 0) (tdelay = 8);
               putc(12);
               delay_ms(50);
               printf(" Speed = %u", 8-tdelay);
               pad(9);
        }
           for (i=0;i<tdelay;i++) (delayasec());
           if (!input(PIN_A2)) {
              (bumpcount());
              OUTPUT_HIGH(PIN_A0);
         }
         output();
         delayasec();
         output_low(PIN_A0);
         nextmem();
         j++;
     }
     goto pauseit;

restart:
            for (curmem=0;curmem<64;curmem++)  (WRITE_EEPROM(curmem,0));     //clear all the EEPROM space
            oldmemnum = memnum;
            memnum = 0;
            While (input(PIN_B1)){
                  putc(12);
                  if (!input(PIN_B2)){                //determine the new number of memories
                     memnum++;
                     if (memnum >30) (memnum = 1);
                  }
                  delay_ms(50);
                  printf("Memories? %u", memnum);
                  pad(5);
                  delay_ms(250);
            }
            if (memnum==0) memnum = oldmemnum;
            write_eeprom(0,memnum);                 //save the memory data in EEPROM 0
            putc(12);
            goto normal;

pauseit:
   putc(12);
   printf("................");
   delayasec();
   delayasec();
   output();
   While (TRUE){
      if (!input(PIN_B3)) goto restart;
      if (!input(PIN_B1)) goto resume;
      if (!input(PIN_B2)) {
         output();
         nextmem();
      }
    delay_ms(250);
   }

}// end of main
