'10-30-93
'WILCO / CODE
'AUTHOR: ROGER JOHNSON WA0VLL
'
'03-09-94
'1st COMMERCIAL VERSION
'COPYRIGHT DOVER RESEARCH CORPORATION
'AUTHOR: JAMES "JAY" CRASWELL WB0VNE
'FOR THE HARRIS HSP45102 DDS CHIP

'EQUATES
        PORT = &H3BC

        SCLKON = 1
        SDON = 2
        TXON = 4
        SFON = 64
        MSBON = 32
        SELON = 128
        ENPON = 8
        LOADON = 16

START:  IDLE = TXON + LOADON + MSBON + SELON
        OUT PORT, IDLE
       

SEND:
        COLOR 0, 7
        CLS
        PRINT " ͻ"
        FOR dl = 1 TO 16

        PRINT "                                                                              "
        NEXT dl
        PRINT " ͼ"
        LOCATE 3, 20
        PRINT "20 MHz SOFT-SIGNAL/SWEEP GENERATOR"
        LOCATE 4, 20
        PRINT "COPYRIGHT 1993,94 by DOVER RESEARCH CORPORATION"
        LOCATE 5, 20
        PRINT "(612) 492-3913"
        LOCATE 8, 20
        PRINT "<F> ENTER A NEW FREQUENCY"
        LOCATE 9, 20
        PRINT "<B> SET SWEEP BAND EDGES"
        LOCATE 10, 20
        PRINT "<T> SET SWEEP STEP"
        LOCATE 11, 20
        PRINT "<S> SWEEP"
        LOCATE 12, 20
        PRINT "<P> SELECT NEW I/O PORT"
        LOCATE 13, 20
        PRINT "<Q> QUIT TO DOS"
        LOCATE 20, 6
        PRINT "CURRENT FREQ = ";
        IF F = 0 THEN GOTO AR1
        LOCATE 20, 20
        PRINT " ["; F; "]      "
AR1:    LOCATE 21, 6
        PRINT "CURRENT STEP = ";
        IF SSTEP = 0 THEN GOTO AR2
        LOCATE 21, 20
        PRINT " ["; SSTEP; "]      "
AR2:    LOCATE 20, 34
        PRINT "SWEEP LOW LIMIT  FREQ = ";
        IF BMIN = 0 THEN GOTO AR3
        LOCATE 20, 57
        PRINT " ["; BMIN; "]           "
AR3:    LOCATE 21, 34
        PRINT "SWEEP HIGH LIMIT FREQ = ";
        IF BMAX = 0 THEN GOTO AR4
        LOCATE 21, 57
        PRINT " ["; BMAX; "]           "
AR4:

REREAD: K$ = INKEY$
        IF K$ = "" THEN GOTO REREAD
        LOCATE 23, 1
        IF K$ = "F" THEN GOTO FREQ
        IF K$ = "f" THEN GOTO FREQ
        IF K$ = "B" THEN GOTO BAND
        IF K$ = "b" THEN GOTO BAND
        IF K$ = "T" THEN GOTO SSTEP
        IF K$ = "t" THEN GOTO SSTEP
        IF K$ = "S" THEN GOTO SWEEP
        IF K$ = "s" THEN GOTO SWEEP
        IF K$ = "P" THEN GOTO SPORT
        IF K$ = "p" THEN GOTO SPORT
        IF K$ = "Q" THEN GOTO QUIT
        IF K$ = "q" THEN GOTO QUIT
        LOCATE 20, 1
        SOUND 2024, .5
        GOTO SEND

BAND:   LOCATE 15, 20
        INPUT "ENTER LOWER FREQUENCY (For Sweep)"; BMIN
        LOCATE 15, 20
        PRINT "ENTER LOWER FREQUENCY (For Sweep)                "
        LOCATE 15, 20
        INPUT "ENTER UPPER FREQUENCY (For sweep)"; BMAX
        GOTO SEND

SWEEP:  IF SSTEP = 0 THEN GOTO NOSTPERR
        IF BMAX = 0 THEN GOTO NOSETERR
        F = BMIN
        LOCATE 15, 20
        PRINT "SWEEPING..."
RESWEEP:
        GOSUB FREAK
        F = F + SSTEP
        IF F > BMAX THEN F = BMIN
        K$ = INKEY$
        IF K$ = "" THEN GOTO RESWEEP ELSE GOTO DSWEEP

DSWEEP: LOCATE 15, 20
        SOUND 2048, .5
        PRINT "DONE SWEEPING!"
        GOSUB DELAY
        GOTO START

FREAK:  IF F > 20000000 THEN GOTO MAXERR
        N = F / (40000000 / 2 ^ 32)

        FOR X = 31 TO 0 STEP -1
        BIT = 0
        IF N - INT(2 ^ X) >= 0 THEN BIT = 1: N = N - (INT(2 ^ X))
        IF BIT = 1 THEN BIT = 2
        GOSUB CLOCK
        NEXT X
        GOSUB TXFER
        RETURN

SSTEP:  LOCATE 15, 20
        INPUT "ENTER STEP (in Hertz)"; SSTEP
        GOTO SEND

QUIT:   SYSTEM

FREQ:   LOCATE 15, 20
        INPUT "ENTER A NEW FREQUENCY (in Hertz)"; F
        IF F > 20000000 THEN GOTO MAXERR
        N = F / (40000000 / 2 ^ 32)

        FOR X = 31 TO 0 STEP -1
        BIT = 0
        IF N - INT(2 ^ X) >= 0 THEN BIT = 1: N = N - (INT(2 ^ X))
        IF BIT = 1 THEN BIT = 2
        GOSUB CLOCK
        NEXT X
        GOSUB TXFER
        GOTO DONE

CLOCK:  OUT PORT, IDLE + BIT
        OUT PORT, IDLE + BIT + SCLKON
        OUT PORT, IDLE
        RETURN

TXFER:  OUT PORT, IDLE - TXON
        OUT PORT, IDLE
        RETURN

DONE:   GOTO SEND

MAXERR: SOUND 1024, .5
        LOCATE 15, 20
        PRINT "ERROR!  MAX FREQUNCY is 20MHz                             "
        F = 0
        GOSUB DELAY
        GOTO SEND

NOSTPERR:
        SOUND 1024, .5
        LOCATE 15, 20
        PRINT "ERROR!  SWEEP STEP PARAMETER NOT SET."
        GOSUB DELAY
        LOCATE 15, 20
        PRINT "SET SWEEP STEP FIRST!                 "
        GOSUB DELAY
        GOTO SEND

NOSETERR:
        SOUND 1024, .5
        LOCATE 15, 20
        PRINT "ERROR!  SWEEP BAND LIMITS NOT SET.:"
        GOSUB DELAY
        LOCATE 15, 20
        PRINT "SET BAND LIMITS FIRST!              "
        GOSUB DELAY
        GOTO SEND


DELAY:  FOR XT = 1 TO 10000
        NEXT XT
        RETURN

SPORT:  LOCATE 15, 20
        PRINT "<A> LPT1:"
        LOCATE 16, 20
        PRINT "<B> LPT2:"
        LOCATE 17, 20
        PRINT "<C> COMPAQ CONTURA PORT"
RPORT: K$ = INKEY$
        IF K$ = "" THEN GOTO RPORT
        IF K$ = "A" THEN PORT = &H378
        IF K$ = "a" THEN PORT = &H378
        IF K$ = "B" THEN PORT = &H278
        IF K$ = "b" THEN PORT = &H278
        IF K$ = "C" THEN PORT = &H3BC
        IF K$ = "c" THEN PORT = &H3BC
        GOTO START

