;----------THERMOM.ASM----------
;Digital thermometer using 16C71
;Has Morse readout provision 
;By Bert Kelley      Jan 8, 2000    
	list	p=16c71
	__config  0x3ff1
        radix	hex
        errorlevel -302
;registers
indf	equ	0x00    ;part of indirect addr
tmr0    equ     0x01    ;serial
pc	equ	0x02    ;call segmnt
status  equ     0x03    ;
fsr     equ	0x04
porta	equ	0x05    ;
portb	equ	0x06    ;
adcon0  equ	0x08    ;a/d control register
adres   equ	0x09    ;
intcon  equ     0x0b    ;interrupt control
optreg  equ	0x81    ;serial
trisa	equ	0x85    ;bank 1 porta
trisb	equ	0x86    ;bank 1 portb
adcon1	equ	0x88    ;a/d control register
;bit identifications
rp0	equ	5       ;bank switch bit
c	equ	0       ;carry flag    
z	equ	2       ;z flag bit
w	equ	0       ;w register
f	equ	1       ;file
;variables
sndreg  equ	0x0c    ;serial
count	equ	0x0d    ;used by serial         
ncount	equ	0x0e    ;used by nested loop   
mcount  equ	0x0f    ;used by nested loop  
temp    equ     0x10    ;A/D, bn2bcd
;variables displayed on serial LCD appear below
inside  equ     0x11    ;inside temp in hex
outside equ     0x12    ;outside temp in hex
hunds   equ     0x13    ;bcd 100's
tens	equ     0x14    ;bcd 10's
ones    equ     0x15    ;bcd 1's                      
added  	equ	0x16    ;bcd 10, 1,  OR'd        
dispten	equ	0x17    ;10s after conv to 7 seg
dispone equ     0x18    ;1's after conv to 7 seg
;following variables used for Morse 
tone    equ     0x19    ;frequency of Morse tone
morse   equ     0x1a    ;number of Morse characters
cw_0    equ     0x1b    ;'i' (inside) identification
cw_1    equ     0x1c    ;inside tens
cw_2    equ     0x1d    ;inside units              
cw_3    equ	0x1e    ;'o' (outside) identification
cw_4    equ     0x1f    ;outside tens
cw_5    equ     0x20    ;outside units
shift   equ     0x21    ;morse 'shift register'
;--------------------------
	org	0x000
start
     	bsf	status,rp0 ;switch to bank 1
        movlw   0x0b       ;bits 0,1,3 in; 2,4 out 
	movwf	trisa      ;on port a
	movlw	0x00       ;                        
	movwf	trisb      ;
	movlw	0x02       ;Port A bits 0,1 a/d inputs
	movwf	adcon1     ;bits 2,3,4 digital
	bcf	status,rp0 ;switch back to bank0
	clrf	portb      ;clear output port
	bcf	intcon,7   ;disable interrupt
	clrf	inside     ;inside displayed upper left
	clrf	outside    ;outside disply'd next right
	clrf	hunds      ;hunds displayed next right
	clrf	tens       ;tens  displayed upper right
	clrf	ones       ;ones displayed lower left
	clrf 	added      ;two low digits combined             
	clrf	dispten    ;             
	clrf	dispone    ;                                 
	goto	getin 
;-------INSIDE TEMPERATURE ACQUISITION--
getin 	movlw	0x81       ;config A/D, select AN0
	movwf	adcon0     ;
	call	del_20     ;wait 20 microseconds
	bsf	adcon0,2   ;start conversion
test	btfsc	adcon0,2   ;test for go/done bit
	goto	test       ;
	movf	adres,w    ;adres holds conversion
	movwf   inside     ;for diagnostic
	movwf	temp       ;temp will be negated to 
	comf	temp,f     ;compensate for inversion
                   	   ;in op amp
        call    bn2bcd     ;convert hex to decimal
        call    load1      ;load morse for cw  
  	call    range      ;
 	call	display    ;display inside temperature
        call	getout     ;get outside temp, 
  	call    bn2bcd     ;                           
    	call    load2      ;
        call    range      ;
 	bsf	dispten,7  ;turns on outside LED
   	call	display    ;                                 
	btfss   porta,3    ;
        call    sendcw     ; 
	goto	getin      ;                             
;-------OUTSIDE TEMPERATURE ACQUISITION-----
getout  movlw	0x89      ;turn on AN1
	movwf	adcon0    ;
 	call	del_20    ;
	bsf	adcon0,2  ;
testagn btfsc	adcon0,2  ;
	goto	testagn   ;
	movf	adres,w   ; 
	movwf   outside   ;for diagnostic
	movwf	temp      ;	
 	comf	temp,f    ;invert data
 	return
;-------LOAD MORSE CHARACTERS  
load1   movlw   0x20      ;An 'i' (inside) ident 
        movwf   cw_0      ;is first character sent
	movf	tens,w    ;                              
        call    bcd2cw    ;convert to cw character        
        movwf   cw_1      ;store as 10's inside temp.
	movf    ones,w    ;
        call    bcd2cw    ;
        movwf   cw_2      ;store as units inside temp.
        return            ;                         
;
load2   movlw   0xf0      ;'O' (outside) ident.
        movwf   cw_3      ;
        movf    tens,w    ;
        call    bcd2cw    ;
        movwf   cw_4      ;
        movf    ones,w    ;
        call    bcd2cw    ;
        movwf   cw_5      ;
        movlw   0x06      ;
        movwf   morse     ;
        return

bcd2cw  addwf   pc,f      ;Conversion from BCD to Morse
        retlw   0xfc      ;0
        retlw   0x7c      ;1
        retlw   0x3c      ;2
        retlw   0x1c      ;3
        retlw   0x0c      ;4
        retlw   0x04      ;5
        retlw   0x84      ;6
        retlw   0xc4      ;7
        retlw   0xe4      ;8
        retlw   0xf4      ;9 
	return
;-------CONVERT HEX TO DECIMAL AND 7 SEGMENT
bn2bcd	clrf	hunds     ;will hold hundreds
	clrf    tens      ;will hold tens
	comf	hunds,f   ;hundreds now = FF
	comf	tens,f    ;tens now = FF
	movlw	0x64      ;64h = 100 decimal
inchun  incf	hunds,f   ;increment hundreds
	subwf	temp,f    ;formerly used temp
	btfsc	status,c
	goto	inchun
	movf	temp,w    ;hunds now holds BCD hundreds
	addlw	0x64      ;correct remainder in temp
	movwf	temp 
	movlw	0x0a      ;0Ah = 10 decimal
incten	incf	tens,f    ;                
	subwf	temp,f
	btfsc	status,c
	goto	incten
	movf	temp,w    ;tens now holds bcd tens
	addlw	0x0a      ;adjust neg. number in remainder
	movwf   ones      ;BCD ones
        call	segmnt    ;convert to 7 seg,
	movwf	dispone   ;BCD ones after conv. to 7 seg
        movf	tens,w    ;BCD tens is checked. If zero,
	btfsc   status,z  ;leading zero blanking is turned
        goto    blank     ;on.
	call	segmnt    ;if OK, convert to 7 seg
	movwf   dispten   ;BCD tens after conv. to 7 seg
        return
blank   movlw   0x00      ;
        movwf   dispten   ;
	return
;
;-------CHECK IF OP AMP VOLTAGES IN CORRECT RANGE
range   movf    tens,w    ;Selects temperature display                                    
        movwf   added     ;of 1 to 99. The actual BCD
        swapf   added,f   ;numbers selected are 101 to 199,
	movf	ones,w    ;excluding 0-100 and 200-255
        iorwf   added,f   ;                   
        btfsc   status,z  ;if z not set, skip next
	goto    off       ;if 00, shut off display     
        movf    hunds,w   ;chk if in bcd 100's range
        sublw   0x01      ;
        btfsc   status,z  ;
        return            ;is OK.
off	movlw	0x00      ;is not between 01 and 99,
	movwf	dispone   ;shut off display.
        movwf   dispten   ;        
	return   
;
;-------OPERATE TWO DIGIT LED DISPLAY 
display	movlw	0x04      ;setup long delay 
        movwf	ncount    ;
reload	movlw	0xff      ;                              
 	movwf	mcount
inloop	movlw   0x18      ;               
        movwf	fsr       ;set fsr to start of data 
        bcf     porta,2   ;Dispone will be output to
        movf	indf,w    ;LED, then dispten.        
	movwf   portb     ;
	call	wait      ;
	bsf	porta,2   ;
  	decf    fsr,1     ;            
	movf	indf,w    ;
	movwf	portb     ;
	call    wait      ;                     
                          ;'comment out' next four
 	decfsz  mcount,f  ;to include 'goto reload' 
 	goto	inloop    ;to make display rapidly
        decfsz	ncount,f  ;cycle
 	goto	reload    ;
	movlw   0x00	  ;exits with 
	movwf   portb     ;display off
        return
;
;--------------------------LOOKUP TABLE
segmnt	addwf	pc,f      ;add w to pc
	retlw	0x3f      ;0                                   
	retlw	0x06	  ;1  
	retlw	0x5b	  ;2
	retlw	0x4f	  ;3
	retlw	0x66	  ;4
	retlw	0x6d	  ;5
	retlw	0x7d	  ;6
	retlw	0x07	  ;7
	retlw	0x7f	  ;8
	retlw	0x6f      ;9
	return
;----------------------------
del_5	movlw	0x29      ;Approx 5 millisec delay
	movwf	mcount    ;
delay	call	del_125   ;uses next call
	decfsz  mcount,f
	goto    delay
        return
;---------------------------
del_125 movlw	0x2a      ;125 microsec delay
	movwf   ncount    
time  	decfsz	ncount,f  
	goto	time  
	return
;---------------------------
wait	clrf	count
	comf	count,f
delay1  decf	count,1
	btfss	status,2
	goto	delay1
	return
;-------------------------
del_20  movlw	0x10
	movwf	count
again	decfsz  count,f
	goto	again
	return
;
	org	0x100     ;
;
;--------------------------SEND TEMPERATURE IN MORSE   
sendcw  movlw   0x1b      ;
        movwf   fsr       ;set fsr to start CW message
	movf    indf,w    ;first char to shift register
        movwf   shift     ;
rotate  bcf     status,c  ;clear carry flag
        rlf	shift,1   ;rotate shift register left
        btfsc   status,c  ;skip next if Cy not set
        goto    dah       ;send a dah if carry flag
                          ;a '1' was rotated into carry
        goto    dit       ;send a dit if no flag
chkeoc  clrw              ;a '0' was rotated into carry
        movf	shift,w   ;check if end of character
	sublw   0x80      ;signified by 80 being                          
        btfss   status,z  ;rotated into 'shift'
	goto    rotate    ;              
        decfsz  morse,1   ;   
        goto    getmor    ;
        clrf    shift     ;                     
        return            ;end CW transmission
getmor  call    del_1e    ;total space between characters 
        call    del_1e    ;is three elements including
        incf    fsr,1     ;one el. appended to dot's/dash's
        movf    indf,w    ; 
        movwf   shift      ;next char. to send register
        goto    rotate    ;
;-------------------------SEMD A DIT
dit	movlw   0x78      ;A dit is a one 'element' long
        movwf   mcount    ;tone plus 1 element of silence
uphalf  bsf	porta,4   ;inter-element spacing.     
	movlw   0x50      ;length of one half 
	movwf   tone	  ;cycle is in 'tone.'
upper   decfsz  tone,f    ;
        goto    upper     ;
	bcf     porta,4   ;start half of cycle 
	movlw   0x50      ;                                 
	movwf   tone      ;
lower   decfsz  tone,f    ;Each 60 ms = 1 element (20 wpm)
	goto    lower     ;
	decfsz  mcount,f  ;Frequency of tones is 2055 hz
	goto	uphalf    ;
        movlw   0x3c      ;1T silence starts after dit
        movwf   temp      ;60 millisec long
rest    call    wait      ;
        decfsz  temp,f    ;
        goto    rest      ;
 	goto    chkeoc    ;
;-------------------------SEND A DAH
dah	movlw   0x03      ;A dah is tone 3X length of a
        movwf   count     ;dit or 180 milliseconds
restor  movlw   0x78      ;
        movwf   mcount    ;plus 60 ms silence
hicy    bsf	porta,4   ;upper half of cycle 
	movlw   0x50      ;begins                    
	movwf   tone	  ;
hitime  decfsz  tone,f    ;
        goto    hitime    ;
	bcf     porta,4   ;lower half of cycle 
	movlw   0x50      ;begins
	movwf   tone      ;
lotime  decfsz  tone,f    ;
	goto    lotime    ;
	decfsz  mcount,f  ;
	goto	hicy      ;
	decfsz  count,1   ;
        goto    restor    ;
	movlw	0x3c      ;1T silence after dash starts
        movwf	temp      ;
quiet   call	wait
	decfsz  temp,f
	goto    quiet     ;
        goto    chkeoc    ;check if end-of-character
;-----------------------------1 Element delay
del_1e  movlw   0x3c      ;60 millisecond delay             
	movwf	mcount    ;                                                       
main	call	wait      ;
	decfsz  mcount,1
	goto    main
	return
;-----------------------------3 Element delay
del_3e  movlw	0x03      ;180 milliseconds
	movwf	count     ;                   
repo    movlw   0x3c      ;
        movwf   mcount    ;
circle  call    wait
	decfsz  mcount,1 
	goto    circle
	decfsz  count,1 
	goto    repo  
        return
;--------------------------(DIAGNOSTIC) not used            
serial 	bsf	porta,4   ;   
        movlw	0x1a      ;
	movwf   fsr       ;                                                   
	movlw   0x08      ;                                      
	movwf	mcount    ;
string 	movf	indf,w    ;
	movwf	sndreg    ;
        call	ser_out   ;
	incf	fsr,f
	decfsz  mcount,f  ;              
        goto    string      
	return            ;                  
;
ser_out bcf	intcon,5  ;                       
	bcf	intcon,7  ;    
	clrf	tmr0      ;                
	clrwdt                    
	bsf	status,rp0        
	movlw   0xd8              
	movwf	optreg            
	bcf	status,rp0  ;                               
	movlw	0x08      
	movwf	ncount    
	bcf	porta,4   ;
	clrf	tmr0      ;
	bcf	intcon,2  ;                         
time1   btfss	intcon,2  ;                           
	goto	time1     ;
	bcf	intcon,2  ;           
nxtbit  rlf	sndreg,f  ;                      
	bcf	porta,4   ;                        
	btfsc	status,c  ;
	bsf	porta,4   
time2   btfss	intcon,2  ;                
	goto    time2     
	bcf	intcon,2          
	decfsz	ncount,f
	goto	nxtbit
	bsf	porta,4
time3   btfss	intcon,2  ;                          
	goto	time3
	return
;
        end
