#include <KEYPAD.H>
#ROM 0x2100 = {0x48,0x01,0x80,0x01,0x80,0x01,0x99,0x03,0x50,0x03,0x75,0x03,0x99,0x07,0x00,0x07,0x15,0x07,0x30,0x10,0x10,0x10,0x15,0x10,0x15,
               0x14,0x00,0x14,0x15,0x14,0x35,0x18,0x06,0x18,0x11,0x18,0x17,0x21,0x00,0x21,0x20,0x21,0x45,
               0x24,0x89,0x24,0x93,0x24,0x99,0x28,0x00,0x28,0x30,0x28,0x99,0x29,0x00,0x29,0x00,0x29,0x70}

unsigned int dataout[11] ={0xFE, 0xFE, 0x48, 0xE0, 0x05, 0x00, 0x00, 0x10, 0x07, 0x00, 0xFD};
//                           0     1     2    3      4     5     6     7     8     9    10


int port = 0x48;
short split = FALSE;
int freq[10];


int GetDigit(){
int digit;
      digit = 17;
      if (!input(B0)){   //scan keypad rows
         delay_ms(20);   //debounce
         if (!input(B0)) (digit = 3);
         do{
         }while (!input(B0));   //don't let it register as two pushes
      }
      if (!input(B1)){
         delay_ms(20);   //debounce
         if (!input(B1)) (digit = 2);
         do{
         }while (!input(B1));   //don't let it register as two pushes
      }
         if (!input(B2)){
         delay_ms(20);   //debounce
         if (!input(B2)) (digit = 1);
         do{
         }while (!input(B2));  //don't let it register as two pushes
      }
      return digit;
}

void Xmit(int num){
int i;
 for (i=0;i<num;i++) (putc(dataout[i]));
 delay_ms(60);
}
int GetKey(void){    //scan keypad columns

int key, work;
   output_low(A2);
   output_high(B4);
   output_high(B5);
   output_high(B6);
   output_high(B7);

   key =17;
   While (key > 16){
      output_low(B4);
      work = GetDigit();
      if (work < 17) (key =work);
      output_high(b4);
      output_low(b5);
      work = GetDigit();
      if (work < 17) (key = work+3);
      output_high(b5);
      output_low(b6);
      work = GetDigit();
      if (work < 17) (key = work+6);
      output_high(b6);
      output_low(b7);
      work  = GetDigit();
      if (work < 17) (key = work+9);
      output_high(b7);
      output_low(B3);
      work = GetDigit();
      if (work < 17) (key = work+12);
      output_high(b3);
   }
   if (key == 11) (key = 0);  //replace 11 with zero
   return key;
}

SetPort(){
int dig1, dig2;
   dig1 = GetKey();
      if (dig1 == 12) (dig1 = GetKey() +9);
   dig2 = GetKey();
      if (dig2 == 12) (dig2 = GetKey() +9);
   dataout[2] = (dig1<<4)+dig2;
   write_eeprom(0x00,dataout[2]);
}

SetMemory(){
int i,dig1, dig2;
   dig1 = GetKey();
   dig2 = GetKey();
   dataout[4] = 0x08;
   dataout[5] = 0xFD;
   Xmit(6);
   dataout[5] = (dig1<<4)+dig2;
   dataout[6] = 0xFD;
   Xmit(7);
}
VFO(){
int i;
   dataout[4] = 0x07;
   dataout[5] = 0xFD;
   Xmit(6);
}

SwitchVFO(){
int i;
   dataout[4] = 0x07;
   dataout[5] = 0xB0;
   dataout[6] = 0xFD;
   Xmit(7);
}
MakeSplit(){
int i;
   dataout[4] = 0x0F;
   dataout[5] = 0x00;
   if (split == FALSE) (dataout[5] = 0x01);
   if (split == FALSE) (split = TRUE);
      else (split = FALSE);
   dataout[6] = 0xFD;
   Xmit(7);
}
SetMode(int mode) {

int i;
   dataout[4] = 0x06;
   dataout[5] = mode;
   dataout[6] = 0xFD;
   Xmit(7);
}
SetFreq(){
int i, k,decimal,length,ssb,mode;
int limit[6];

      decimal = 9;
      for (i=1;i<10;i++) (freq[i] = 0);
      i =1;
      do {
         freq[i] = GetKey();
         if (freq[i] == 10) (decimal = i);
         i++;
      }while ((freq[i-1] !=12) && (i < 10));
       if (freq[i-1] == 12){
          (freq[i-1] = 0);   //get rid of the trailing # sign
          length = i-1;
       }
       if (decimal ==1){
          freq[9] = freq[7];
          freq[8] = freq[6];
          freq[7] = freq[5];
          freq[6] = freq[4];
          freq[5] = freq[3];
          freq[4] = freq[2];
          freq[3] = freq[0];
          freq[2] = freq[1] = 0;
     }
       if (decimal == 2){
          freq[9] = freq[8];
          freq[8] = freq[7];
          freq[7] = freq[6];
          freq[6] = freq[5];
          freq[5] = freq[4];
          freq[4] = freq[3];
          freq[3] = freq[1];
          freq[2] = freq[0];
          freq[1] =0;
        }
       if ((decimal == 3)  && (freq[0] < 5)){
         freq[3] = freq[2];
         freq[2] = freq[1];
         freq[1] = freq[0];
       }
       if ((decimal == 3) && (freq[0] > 4)) {
         freq[9] = freq[6];
         freq[8] = freq[5];
         freq[7] = freq[4];
         freq[6] = freq[2];
         freq[5] = freq[1];
         freq[4] = freq[0];
         freq[3] =freq[2]=freq[1]=0;
       }
       if (decimal == 4){
         freq[9] = freq[7];
         freq[8] = freq[6];
         freq[7] = freq[5];
         freq[6] = freq[3];
         freq[5] = freq[2];
         freq[4] = freq[1];
         freq[3] = freq[0];
         freq[2]=freq[1]=0;
      }
      if (decimal == 5){
         freq[9] = freq[8];
         freq[8] = freq[7];
         freq[7] = freq[6];
         freq[6] = freq[4];
         freq[5] = freq[3];
         freq[4] = freq[2];
         freq[3] = freq[1];
         freq[2] = freq[0];
         freq[1]=0;
      }
      if (decimal == 6){
         freq[6] = freq[5];
         freq[5] = freq[4];
         freq[4] = freq[3];
         freq[3] = freq[2];
         freq[2] = freq[1];
         freq[1] = freq[0];
      }
      if (decimal == 9) {
           if (length == 1){
              freq[3] = freq[0];
           }
           if (length == 2){
              freq[3] = freq[1];
              freq[2] = freq[0];
              freq[1] = 0;
           }
           if ((length == 3) && (freq[0] <5)){
              freq[3] = freq[2];
              freq[2] = freq[1];
              freq[1] = freq[0];
            }
           if ((length == 3) && (freq[0] > 4)){
               freq[6] = freq[2];
               freq[5] = freq[1];
               freq[4] = freq[0];
               freq[2] = freq[1] = 0;
           }
           if (length == 4){
               freq[6] = freq[3];
               freq[5] = freq[2];
               freq[4] = freq[1];
               freq[3] = freq[0];
               freq[2] = freq[1] = 0;
             }
           if (length == 5){
                 freq[6] = freq[4];
               freq[5] = freq[3];
               freq[4] = freq[2];
               freq[3] = freq[1];
               freq[2] = freq[0];
               freq[1] = 0;
            }
            if (length == 6){
               freq[6] = freq[5];
               freq[5] = freq[4];
               freq[4] = freq[3];
               freq[3] = freq[2];
               freq[2] = freq[1];
               freq[1] = freq[0];
            }
      }

      dataout[4] = 0x07;
      dataout[5] = 0xFD;
      Xmit(6);
      dataout[4] = 0x05;
      dataout[9] = freq[1];
      dataout[8] = (freq[2]<<4)+freq[3];
      dataout[7] = (freq[4]<<4)+freq[5];
      dataout[6] = (freq[6]<<4)+freq[7];
      dataout[5] = (freq[8]<<4)+freq[9];
      Xmit(11);
      mode = 0x02;  // HF out of Ham bands = AM
      for (i=0;i<10;i++){
           if ((dataout[8] == read_eeprom(6*i+1)) && (dataout[7] >= read_eeprom(6*i+2)) && (dataout[7] <= read_eeprom(6*i+6))) {
                  mode = 0x01;
                  if (i<3) (mode = 0x00);
                  if (dataout[7] < read_eeprom(6*i+4)) (mode = 0x03);
           }
      }
       if ((dataout[8] == 0x04) && (dataout[7] == 0x00)) (mode = 0x00);  //fix for 4.00 MHz.
       if ((dataout[8] == 0x02) && (dataout[7] == 0x00)) (mode = 0x00);  //fix for 2.00 MHz.
       if (dataout[9] == 0x00){
            if (dataout[8] == 0x50){
                mode = 0x03;
                if (dataout[7] > 0x10) (mode = 0x01);
                if (dataout[7] > 0x59) (mode = 0x05);//FM on 6 meters
            }
            if (dataout[8] > 0x50) (mode = 0x05);  //FM on 6 meters
            if (dataout[8] > 0x54) (mode = 0x06);  //TV and FM Broadcast bands
      }
      if (dataout[9] == 0x01){
         if (dataout[8] > 0x39) (mode = 0x05);       // FM above 140 MHz.
         if (dataout[8] ==0x44){
            if (dataout[7] < 0x50) (mode=0x01);  //2 meter SSB and CW
            if (dataout[7] < 0x10) (mode=0x03);
         }


         if (dataout[8] < 0x09) (mode = 0x06);      //Wideband FM on FM BC Band
      }
      SetMode(mode);
}

main() {// setup_counters(RTCC_INTERNAL,RTCC_DIV_2);
  port_b_pullups(TRUE);
  dataout[2] = read_eeprom(0x00);
 if (dataout[2] == 0xff) (dataout[2] =0x48);
   While (TRUE){
      freq[0] = GetKey();
      switch (freq[0]) {
         case 10:
               freq[0] = GetKey();
               if (freq[0] == 10){
                  SetPort();
                  break;
               }
               break;
         case 12:   VFO();break;
         case 13:   SwitchVFO(); break;
         case 14:   SetMemory();break;
         case 15:   MakeSplit(); break;
         default:  SetFreq();

      }


       }
}
