
'  The Spot Grabber  (pic source code)
'  -----------------------------------------
'  file:    sg11.bas
'  version: 1.1
'  date:    12/2000
'  author:  Paulo N. Jorge CT1EFL/G0MUW
'  info:    http://wwww.qsl.net/ct1efl
'  -----------------------------------------

'  setup for pic16f876

DEFINE OSC              10
DEFINE DEBUG_REG        PORTA
DEFINE DEBUG_BIT        0
DEFINE DEBUG_MODE       0
DEFINE LCD_DREG         PORTB
DEFINE LCD_DBIT         0
DEFINE LCD_RSREG        PORTB
DEFINE LCD_RSBIT        5
DEFINE LCD_EREG         PORTB
DEFINE LCD_EBIT         4

ADCON1  = 7
TRISC   = 0

AF_out      var PORTB.7
setup_in    var PORTA.4
hold_in     var PORTB.6
TX_rs232    var PORTA.0
TX_flow     var PORTA.1
RX_rs232    var PORTA.2
RX_flow     var PORTA.3
led_red     var PORTA.4
prt_strobe  var PORTA.5


lcd_list_no var byte[2]
list_no     var byte
dx_in       var byte[12]
dx_in_beep  var byte[2]
dx_in_R     var byte[2]
strg_mhz    var byte[3]
str_cmmnt   var byte[30]
lcd_mhz     var byte[3]
freq_mhz    var word
lcd_khz     var byte[3]
freq_khz    var word
lcd_hz      var byte
freq_hz     var byte
time_zulu   var byte[4]

cw_ssb_160  var word
cw_ssb_80   var word
cw_ssb_40   var byte
cw_ssb_30   var byte
cw_ssb_20   var byte
cw_ssb_17   var byte
cw_ssb_15   var byte
cw_ssb_12   var word
cw_ssb_10   var byte
cw_ssb_6    var byte
cw_ssb_2    var byte

dx_in1      var byte[12]
lcd_mhz1    var byte[3]
freq_khz1   var word
freq_hz1    var byte
time_zulu1  var byte[4]

dx_in2      var byte[12]
lcd_mhz2    var byte[3]
freq_khz2   var word
freq_hz2    var byte
time_zulu2  var byte[4]

dx_in3      var byte[12]
lcd_mhz3    var byte[3]
freq_khz3   var word
freq_hz3    var byte
time_zulu3  var byte[4]

dx_in4      var byte[12]
lcd_mhz4    var byte[3]
freq_khz4   var word
freq_hz4    var byte
time_zulu4  var byte[4]

dx_in5      var byte[12]
lcd_mhz5    var byte[3]
freq_khz5   var word
freq_hz5    var byte
time_zulu5  var byte[4]


prt_idx     var byte
prt_char    var byte
idx_scroll  var byte
band        var byte
Z_chk       var byte
lcd_idx     var byte
character   var byte
index1      var byte
index2      var byte
index3      var byte
index4      var byte
index5      var byte
index6      var byte
time_idx    var byte
index7      var byte
index8      var byte
index9      var byte
index10     var byte
elements    var byte
dah_length  var byte
char_spc    var byte
quiet       con 0

target_char var byte
EEaddr      var byte
action      var byte
bands1      var byte
bands2      var byte
bands3      var byte
options     var byte
alarm_rpt   var byte
tone        var byte
dit_length  var byte
word_space  var byte
lcd_pause   var byte
lcd_msecs   var word
target1     var byte[12]
target2     var byte[12]
target3     var byte[12]


cw_160      var bit     'bands1.0
ssb_160     var bit     'bands1.1
cw_80       var bit     'bands1.2
ssb_80      var bit     'bands1.3
cw_40       var bit     'bands1.4
ssb_40      var bit     'bands1.5
cw_30       var bit     'bands1.6
ssb_30      var bit     'bands1.7
cw_20       var bit     'bands2.0
ssb_20      var bit     'bands2.1
cw_17       var bit     'bands2.2
ssb_17      var bit     'bands2.3
cw_15       var bit     'bands2.4
ssb_15      var bit     'bands2.5
cw_12       var bit     'bands2.6
ssb_12      var bit     'bands2.7
cw_10       var bit     'bands3.0
ssb_10      var bit     'bands3.1
cw_6        var bit     'bands3.2
ssb_6       var bit     'bands3.3
cw_2        var bit     'bands3.4
ssb_2       var bit     'bands3.5
all_70      var bit     'bands3.6
alarm_cw    var bit     'options.0
print_on    var bit     'options.1
preamble_on var bit     'options.2
targets_on  var bit     'options.3


'load initial eeprom data:
'bands1, bands2, bands3, options, tone, dit_length, alarm_rpt, lcd_pause,...
'...target1, target2, target3, mode_division_freqs


                data %01010101, %01010101, %00000001, %00000011, 113, 3, 1, 3,_
                 "DX/TARGET1  ", "DX/TARGET2  ", "DX/TARGET3  ", 38, 80, 35,_
                 140, 70, 100, 80, 30, 50, 100, 150

                pause 500

                dx_in1[0] = " "      
                dx_in1[1] = " "      
                dx_in1[2] = "w"      
                dx_in1[3] = "a"      
                dx_in1[4] = "i"      
                dx_in1[5] = "t"      
                dx_in1[6] = "i"      
                dx_in1[7] = "n"      
                dx_in1[8] = "g"      
                dx_in1[9] = "."      
                dx_in1[10] = "."      
                dx_in1[11] = "."      
                lcd_mhz1[0] = "0"
                lcd_mhz1[1] = "0"
                lcd_mhz1[2] = "0"
                freq_khz1 = 0
                freq_hz1 = 0   
                time_zulu1[0] = "0"  
                time_zulu1[1] = "0"  
                time_zulu1[2] = "0"  
                time_zulu1[3] = "0"  

                dx_in2[0] = " "      
                dx_in2[1] = " "      
                dx_in2[2] = "w"      
                dx_in2[3] = "a"      
                dx_in2[4] = "i"      
                dx_in2[5] = "t"      
                dx_in2[6] = "i"      
                dx_in2[7] = "n"      
                dx_in2[8] = "g"      
                dx_in2[9] = "."      
                dx_in2[10] = "."      
                dx_in2[11] = "."      
                lcd_mhz2[0] = "0"
                lcd_mhz2[1] = "0"
                lcd_mhz2[2] = "0"
                freq_khz2 = 0
                freq_hz2 = 0   
                time_zulu2[0] = "0"  
                time_zulu2[1] = "0"  
                time_zulu2[2] = "0"  
                time_zulu2[3] = "0"  

                dx_in3[0] = " "      
                dx_in3[1] = " "      
                dx_in3[2] = "w"      
                dx_in3[3] = "a"      
                dx_in3[4] = "i"      
                dx_in3[5] = "t"      
                dx_in3[6] = "i"      
                dx_in3[7] = "n"      
                dx_in3[8] = "g"      
                dx_in3[9] = "."      
                dx_in3[10] = "."      
                dx_in3[11] = "."      
                lcd_mhz3[0] = "0"
                lcd_mhz3[1] = "0"
                lcd_mhz3[2] = "0"
                freq_khz3 = 0
                freq_hz3 = 0   
                time_zulu3[0] = "0"  
                time_zulu3[1] = "0"  
                time_zulu3[2] = "0"  
                time_zulu3[3] = "0"

                dx_in4[0] = " "      
                dx_in4[1] = " "      
                dx_in4[2] = "w"      
                dx_in4[3] = "a"      
                dx_in4[4] = "i"      
                dx_in4[5] = "t"      
                dx_in4[6] = "i"      
                dx_in4[7] = "n"      
                dx_in4[8] = "g"      
                dx_in4[9] = "."      
                dx_in4[10] = "."      
                dx_in4[11] = "."      
                lcd_mhz4[0] = "0"
                lcd_mhz4[1] = "0"
                lcd_mhz4[2] = "0"
                freq_khz4 = 0
                freq_hz4 = 0   
                time_zulu4[0] = "0"  
                time_zulu4[1] = "0"  
                time_zulu4[2] = "0"  
                time_zulu4[3] = "0"

                dx_in5[0] = " "      
                dx_in5[1] = " "      
                dx_in5[2] = "w"      
                dx_in5[3] = "a"      
                dx_in5[4] = "i"      
                dx_in5[5] = "t"      
                dx_in5[6] = "i"      
                dx_in5[7] = "n"      
                dx_in5[8] = "g"      
                dx_in5[9] = "."      
                dx_in5[10] = "."      
                dx_in5[11] = "."      
                lcd_mhz5[0] = "0"
                lcd_mhz5[1] = "0"
                lcd_mhz5[2] = "0"
                freq_khz5 = 0
                freq_hz5 = 0   
                time_zulu5[0] = "0"  
                time_zulu5[1] = "0"  
                time_zulu5[2] = "0"  
                time_zulu5[3] = "0"

                dx_in_beep[0] = "T"          
                dx_in_beep[1] = " "
                dx_in_R[0] = "R"
                dx_in_R[1] = " "

                PORTC = 255

                high prt_strobe

                lcdout $FE, 1, $FE, $94, "  = SPOT GRABBER =  ", $FE, $D4, " www.qsl.net/ct1efl "
                gosub lcd_scroll

                if setup_in = 1 then start

setup:
                pause 1000
                lcdout $FE, 1, "     SETUP MODE", $FE, $C0, "    version  1.1" 

                gosub eeprom_read
                gosub load_options

                dx_in[0] = "D"
                dx_in[1] = "X"
                dx_in[2] = "/"
                dx_in[3] = "C"
                dx_in[4] = "A"
                dx_in[5] = "L"
                dx_in[6] = "L"
                dx_in[7] = " "


setup_again:
                gosub answ_R

                serin2 RX_rs232\RX_flow, 396, [wait ("set_up "), action, skip 1,_
                 bin8 bands1, skip 1, bin8 bands2, skip 1, bin8 bands3, bin8 options,_
                 skip 1, dec3 tone, skip 1, dec3 dit_length, skip 1, dec3 alarm_rpt,_
                 skip 1, dec3 lcd_pause, skip 1, str target1\12, skip 1, str target2\12,_
                 skip 1, str target3\12, skip 1, dec3 cw_ssb_160, skip 1, dec3 cw_ssb_80,_
                 skip 1, dec3 cw_ssb_40, skip 1, dec3 cw_ssb_30, skip 1, dec3 cw_ssb_20,_
                 skip 1, dec3 cw_ssb_17, skip 1, dec3 cw_ssb_15, skip 1, dec3 cw_ssb_12,_
                 skip 1, dec3 cw_ssb_10, skip 1, dec3 cw_ssb_6, skip 1, dec3 cw_ssb_2]


                if action = "W" then                    'write new setup
                 gosub eeprom_write
                 gosub answ_R
                endif

                if action = "P" then                    'read setup + preview alarm
                 gosub eeprom_read                      
                 gosub load_options
                 gosub alarm_checks
                endif

                if action = "R" then
                 gosub eeprom_read
                 gosub load_options
                 serout2 TX_rs232\TX_flow, 396, ["set_up A,", bin8 bands1,_
                  ",", bin8 bands2, ",", bin8 bands3, ",", bin8 options, ",",_
                  dec3 tone, ",", dec3 dit_length, ",", dec3 alarm_rpt, ",",_
                  dec3 lcd_pause, ",", str target1\12, ",", str target2\12,_
                  ",", str target3\12, ",", dec3 cw_ssb_160, ",", dec3 cw_ssb_80,_
                  ",", dec3 cw_ssb_40, ",", dec3 cw_ssb_30, ",", dec3 cw_ssb_20,_
                  ",", dec3 cw_ssb_17, ",", dec3 cw_ssb_15, ",", dec3 cw_ssb_12,_
                  ",", dec3 cw_ssb_10, ",", dec3 cw_ssb_6, ",", dec3 cw_ssb_2]
                endif

                pause 200
                goto setup_again



start:         
                gosub answ_R


                gosub answ_R

                gosub eeprom_read
                cw_ssb_160 = cw_ssb_160 + 800
                cw_ssb_80 = cw_ssb_80 + 500
                cw_ssb_12 = cw_ssb_12 + 890

                gosub load_options

                for prt_idx = 1 to 32 
                 prt_char = " "
                 gosub print_now
                next prt_idx
                for prt_idx = 0 to 19
                 lookup prt_idx, ["= SPOT GRABBER =", 10, 13, 10, 13], prt_char
                 gosub print_now
                next prt_idx

                list_no = 1
                lcd_msecs = lcd_pause * 1000


spot_in:
                high led_red


                if lcd_msecs = 0 then spot_exit

                if list_no = 6 then
                 list_no = 1
                endif

                serin2 RX_rs232\RX_flow, 396, lcd_msecs, spot_exit, [wait ("DX de "), skip 10,_
                 str strg_mhz\3, dec3 freq_khz, skip 1, dec1 freq_hz, skip 2,_
                 str dx_in\12, skip 1, str str_cmmnt\30, skip 1, str time_zulu\4, Z_chk]


                if Z_chk <> "Z" then spot_in

                low led_red
                pause 30

                lcd_mhz[0] = strg_mhz[0]
                lcd_mhz[1] = strg_mhz[1]
                lcd_mhz[2] = strg_mhz[2]


                gosub list_check
                gosub targets_check
                gosub bands_check
               
               
                list_no = 0

                gosub lcd_scroll                        'scroll display
                gosub lcd_show                          'display rxed spot on lcd
                gosub alarm_checks                      'sound alarm
                gosub print_dx                          'print
                gosub list_reorder                      'reorder dx-spot list
                pause lcd_msecs + 3000                  'pause 3secs more on rxed spot

                list_no = 1


spot_exit:      if hold_in = 1 then
                 low led_red                 
                 pause 500
                 high led_red
                 pause 500                 
                 goto spot_exit
                endif

                gosub lcd_scroll
                branchl list_no, [dummy_no0, show_no1, show_no2,_
                 show_no3, show_no4, show_no5]



inc_list_no:    list_no = list_no + 1
                lcd_msecs = lcd_pause * 1000

                goto spot_in

        	end




'subroutines here:  ---------------------------------------------------------
'----------------------------------------------------------------------------


print_dx:      
                for prt_idx = 0 to 3
                 lookup prt_idx, ["dx: "], prt_char
                 gosub print_now
                next prt_idx

                for prt_idx = 0 to 11
                 prt_char = dx_in[prt_idx]
                 gosub print_now
                next prt_idx

                for prt_idx = 0 to 3
                 lookup prt_idx, [" on:"], prt_char
                 gosub print_now
                next prt_idx

                for prt_idx = 0 to 2
                 prt_char = lcd_mhz[prt_idx]
                 gosub print_now
                next prt_idx

                for prt_idx = 0 to 2
                 prt_char = lcd_khz[prt_idx]
                 gosub print_now
                next prt_idx

                prt_char = "."
                gosub print_now
                prt_char = lcd_hz
                gosub print_now

                for prt_idx = 0 to 9
                 lookup prt_idx, ["KHz   at: "], prt_char
                 gosub print_now
                next prt_idx

                for prt_idx = 0 to 3
                 prt_char = time_zulu[prt_idx]
                 gosub print_now
                next prt_idx

                for prt_idx = 0 to 3
                 lookup prt_idx, ["utc "], prt_char
                 gosub print_now
                next prt_idx

                for prt_idx = 0 to 29
                 prt_char = str_cmmnt[prt_idx]
                 gosub print_now
                next prt_idx

                prt_char = 10
                gosub print_now
                prt_char = 13
                gosub print_now

                return


print_now:      if print_on = 0 then print_exit
                PORTC = prt_char
                pause 1
                pulsout prt_strobe,2
                pause 1
                PORTC = 255
                pause 1
print_exit:     return


lcd_show:                  
                lcd_khz[0] = (freq_khz dig 2) + 48
                lcd_khz[1] = (freq_khz dig 1) + 48
                lcd_khz[2] = (freq_khz dig 0) + 48
                lcd_hz[0] = (freq_hz dig 0) + 48

                if list_no = 0 then
                 lcd_list_no[0] = "n"
                 lcd_list_no[1] = "w"
                else
                 lcd_list_no[0] = "#"
                 lcd_list_no[1] = (list_no dig 0) + 48
                endif

                lcdout $FE, $94, "dx  ", str dx_in\12, "    ", $FE, $D4,_
                 str lcd_list_no\2, " ", str lcd_mhz\3, str lcd_khz\3, ".",_
                 str lcd_hz\1, "KHz ", str time_zulu\4, "z"

                gosub lcd_scroll

                return


lcd_scroll:     for idx_scroll = 1 to 20
                 lcdout $FE, $18
                 pause 30
                next idx_scroll

                return

                

list_check:    
                for index6 = 0 to 11
                 if dx_in[index6] <> dx_in1[index6] then list2_check
                next index6
                for time_idx = 0 to 3
                 if time_zulu[time_idx] <> time_zulu1[time_idx] then list2_check
                next time_idx
                lcd_msecs = lcd_msecs - 500
                goto spot_in
list2_check:   
                for index6 = 0 to 11
                 if dx_in[index6] <> dx_in2[index6] then list3_check
                next index6
                for time_idx = 0 to 3
                 if time_zulu[time_idx] <> time_zulu2[time_idx] then list3_check
                next time_idx
                lcd_msecs = lcd_msecs - 500
                goto spot_in
list3_check:    
                for index6 = 0 to 11
                 if dx_in[index6] <> dx_in3[index6] then list4_check
                next index6
                for time_idx = 0 to 3
                 if time_zulu[time_idx] <> time_zulu3[time_idx] then list4_check
                next time_idx
                lcd_msecs = lcd_msecs - 500
                goto spot_in
list4_check:    
                for index6 = 0 to 11
                 if dx_in[index6] <> dx_in4[index6] then list5_check
                next index6
                for time_idx = 0 to 3
                 if time_zulu[time_idx] <> time_zulu4[time_idx] then list5_check
                next time_idx
                lcd_msecs = lcd_msecs - 500             
                goto spot_in
list5_check:    
                for index6 = 0 to 11
                 if dx_in[index6] <> dx_in5[index6] then list_check_out
                next index6
                for time_idx = 0 to 3
                 if time_zulu[time_idx] <> time_zulu5[time_idx] then list_check_out
                next time_idx
                lcd_msecs = lcd_msecs - 500
                goto spot_in

list_check_out: return


dummy_no0:      'debug 10, 13, "dummy show no0!", 10, 13 ..should never go here!
                return

show_no1:                     
                dx_in[0] = dx_in1[0]
                dx_in[1] = dx_in1[1]     
                dx_in[2] = dx_in1[2]      
                dx_in[3] = dx_in1[3]     
                dx_in[4] = dx_in1[4]    
                dx_in[5] = dx_in1[5]     
                dx_in[6] = dx_in1[6]     
                dx_in[7] = dx_in1[7]     
                dx_in[8] = dx_in1[8]     
                dx_in[9] = dx_in1[9]    
                dx_in[10] = dx_in1[10]   
                dx_in[11] = dx_in1[11]     
                lcd_mhz[0] = lcd_mhz1[0]
                lcd_mhz[1] = lcd_mhz1[1]
                lcd_mhz[2] = lcd_mhz1[2]
                freq_khz = freq_khz1
                freq_hz = freq_hz1   
                time_zulu[0] = time_zulu1[0]
                time_zulu[1] = time_zulu1[1] 
                time_zulu[2] = time_zulu1[2] 
                time_zulu[3] = time_zulu1[3]
               
                gosub lcd_show
                goto inc_list_no

show_no2:      
                dx_in[0] = dx_in2[0]
                dx_in[1] = dx_in2[1]     
                dx_in[2] = dx_in2[2]      
                dx_in[3] = dx_in2[3]     
                dx_in[4] = dx_in2[4]    
                dx_in[5] = dx_in2[5]     
                dx_in[6] = dx_in2[6]     
                dx_in[7] = dx_in2[7]     
                dx_in[8] = dx_in2[8]     
                dx_in[9] = dx_in2[9]    
                dx_in[10] = dx_in2[10]   
                dx_in[11] = dx_in2[11]     
                lcd_mhz[0] = lcd_mhz2[0]
                lcd_mhz[1] = lcd_mhz2[1]
                lcd_mhz[2] = lcd_mhz2[2]
                freq_khz = freq_khz2
                freq_hz = freq_hz2   
                time_zulu[0] = time_zulu2[0]
                time_zulu[1] = time_zulu2[1] 
                time_zulu[2] = time_zulu2[2] 
                time_zulu[3] = time_zulu2[3]
               
                gosub lcd_show
                goto inc_list_no

show_no3:      
                dx_in[0] = dx_in3[0]
                dx_in[1] = dx_in3[1]     
                dx_in[2] = dx_in3[2]      
                dx_in[3] = dx_in3[3]     
                dx_in[4] = dx_in3[4]    
                dx_in[5] = dx_in3[5]     
                dx_in[6] = dx_in3[6]     
                dx_in[7] = dx_in3[7]     
                dx_in[8] = dx_in3[8]     
                dx_in[9] = dx_in3[9]    
                dx_in[10] = dx_in3[10]   
                dx_in[11] = dx_in3[11]     
                lcd_mhz[0] = lcd_mhz3[0]
                lcd_mhz[1] = lcd_mhz3[1]
                lcd_mhz[2] = lcd_mhz3[2]
                freq_khz = freq_khz3
                freq_hz = freq_hz3   
                time_zulu[0] = time_zulu3[0]
                time_zulu[1] = time_zulu3[1] 
                time_zulu[2] = time_zulu3[2] 
                time_zulu[3] = time_zulu3[3]
               
                gosub lcd_show
                goto inc_list_no

show_no4:      
                dx_in[0] = dx_in4[0]
                dx_in[1] = dx_in4[1]     
                dx_in[2] = dx_in4[2]      
                dx_in[3] = dx_in4[3]     
                dx_in[4] = dx_in4[4]    
                dx_in[5] = dx_in4[5]     
                dx_in[6] = dx_in4[6]     
                dx_in[7] = dx_in4[7]     
                dx_in[8] = dx_in4[8]     
                dx_in[9] = dx_in4[9]    
                dx_in[10] = dx_in4[10]   
                dx_in[11] = dx_in4[11]     
                lcd_mhz[0] = lcd_mhz4[0]
                lcd_mhz[1] = lcd_mhz4[1]
                lcd_mhz[2] = lcd_mhz4[2]
                freq_khz = freq_khz4
                freq_hz = freq_hz4   
                time_zulu[0] = time_zulu4[0]
                time_zulu[1] = time_zulu4[1] 
                time_zulu[2] = time_zulu4[2] 
                time_zulu[3] = time_zulu4[3]
               
                gosub lcd_show
                goto inc_list_no

show_no5:      
                dx_in[0] = dx_in5[0]
                dx_in[1] = dx_in5[1]     
                dx_in[2] = dx_in5[2]      
                dx_in[3] = dx_in5[3]     
                dx_in[4] = dx_in5[4]    
                dx_in[5] = dx_in5[5]     
                dx_in[6] = dx_in5[6]     
                dx_in[7] = dx_in5[7]     
                dx_in[8] = dx_in5[8]     
                dx_in[9] = dx_in5[9]    
                dx_in[10] = dx_in5[10]   
                dx_in[11] = dx_in5[11]     
                lcd_mhz[0] = lcd_mhz5[0]
                lcd_mhz[1] = lcd_mhz5[1]
                lcd_mhz[2] = lcd_mhz5[2]
                freq_khz = freq_khz5
                freq_hz = freq_hz5   
                time_zulu[0] = time_zulu5[0]
                time_zulu[1] = time_zulu5[1] 
                time_zulu[2] = time_zulu5[2] 
                time_zulu[3] = time_zulu5[3]
               
                gosub lcd_show
                goto inc_list_no



list_reorder:
                dx_in5[0] = dx_in4[0]    
                dx_in5[1] = dx_in4[1]     
                dx_in5[2] = dx_in4[2]      
                dx_in5[3] = dx_in4[3]     
                dx_in5[4] = dx_in4[4]    
                dx_in5[5] = dx_in4[5]     
                dx_in5[6] = dx_in4[6]     
                dx_in5[7] = dx_in4[7]     
                dx_in5[8] = dx_in4[8]     
                dx_in5[9] = dx_in4[9]    
                dx_in5[10] = dx_in4[10]   
                dx_in5[11] = dx_in4[11]     
                lcd_mhz5[0] = lcd_mhz4[0]
                lcd_mhz5[1] = lcd_mhz4[1]
                lcd_mhz5[2] = lcd_mhz4[2]
                freq_khz5 = freq_khz4
                freq_hz5 = freq_hz4   
                time_zulu5[0] = time_zulu4[0]
                time_zulu5[1] = time_zulu4[1] 
                time_zulu5[2] = time_zulu4[2] 
                time_zulu5[3] = time_zulu4[3] 

                dx_in4[0] = dx_in3[0]    
                dx_in4[1] = dx_in3[1]     
                dx_in4[2] = dx_in3[2]      
                dx_in4[3] = dx_in3[3]     
                dx_in4[4] = dx_in3[4]    
                dx_in4[5] = dx_in3[5]     
                dx_in4[6] = dx_in3[6]     
                dx_in4[7] = dx_in3[7]     
                dx_in4[8] = dx_in3[8]     
                dx_in4[9] = dx_in3[9]    
                dx_in4[10] = dx_in3[10]   
                dx_in4[11] = dx_in3[11]     
                lcd_mhz4[0] = lcd_mhz3[0]
                lcd_mhz4[1] = lcd_mhz3[1]
                lcd_mhz4[2] = lcd_mhz3[2]
                freq_khz4 = freq_khz3
                freq_hz4 = freq_hz3   
                time_zulu4[0] = time_zulu3[0]
                time_zulu4[1] = time_zulu3[1] 
                time_zulu4[2] = time_zulu3[2] 
                time_zulu4[3] = time_zulu3[3] 

                dx_in3[0] = dx_in2[0]    
                dx_in3[1] = dx_in2[1]     
                dx_in3[2] = dx_in2[2]      
                dx_in3[3] = dx_in2[3]     
                dx_in3[4] = dx_in2[4]    
                dx_in3[5] = dx_in2[5]     
                dx_in3[6] = dx_in2[6]     
                dx_in3[7] = dx_in2[7]     
                dx_in3[8] = dx_in2[8]     
                dx_in3[9] = dx_in2[9]    
                dx_in3[10] = dx_in2[10]   
                dx_in3[11] = dx_in2[11]     
                lcd_mhz3[0] = lcd_mhz2[0]
                lcd_mhz3[1] = lcd_mhz2[1]
                lcd_mhz3[2] = lcd_mhz2[2]
                freq_khz3 = freq_khz2
                freq_hz3 = freq_hz2   
                time_zulu3[0] = time_zulu2[0]
                time_zulu3[1] = time_zulu2[1] 
                time_zulu3[2] = time_zulu2[2] 
                time_zulu3[3] = time_zulu2[3] 

                dx_in2[0] = dx_in1[0]    
                dx_in2[1] = dx_in1[1]     
                dx_in2[2] = dx_in1[2]      
                dx_in2[3] = dx_in1[3]     
                dx_in2[4] = dx_in1[4]    
                dx_in2[5] = dx_in1[5]     
                dx_in2[6] = dx_in1[6]     
                dx_in2[7] = dx_in1[7]     
                dx_in2[8] = dx_in1[8]     
                dx_in2[9] = dx_in1[9]    
                dx_in2[10] = dx_in1[10]   
                dx_in2[11] = dx_in1[11]     
                lcd_mhz2[0] = lcd_mhz1[0]
                lcd_mhz2[1] = lcd_mhz1[1]
                lcd_mhz2[2] = lcd_mhz1[2]
                freq_khz2 = freq_khz1
                freq_hz2 = freq_hz1   
                time_zulu2[0] = time_zulu1[0]
                time_zulu2[1] = time_zulu1[1] 
                time_zulu2[2] = time_zulu1[2] 
                time_zulu2[3] = time_zulu1[3] 

                dx_in1[0] = dx_in[0]    
                dx_in1[1] = dx_in[1]     
                dx_in1[2] = dx_in[2]      
                dx_in1[3] = dx_in[3]     
                dx_in1[4] = dx_in[4]    
                dx_in1[5] = dx_in[5]     
                dx_in1[6] = dx_in[6]     
                dx_in1[7] = dx_in[7]     
                dx_in1[8] = dx_in[8]     
                dx_in1[9] = dx_in[9]    
                dx_in1[10] = dx_in[10]   
                dx_in1[11] = dx_in[11]     
                lcd_mhz1[0] = lcd_mhz[0]
                lcd_mhz1[1] = lcd_mhz[1]
                lcd_mhz1[2] = lcd_mhz[2]
                freq_khz1 = freq_khz
                freq_hz1 = freq_hz   
                time_zulu1[0] = time_zulu[0]
                time_zulu1[1] = time_zulu[1] 
                time_zulu1[2] = time_zulu[2] 
                time_zulu1[3] = time_zulu[3] 

                return


load_options:   cw_160  = bands1.0
                ssb_160 = bands1.1
                cw_80   = bands1.2
                ssb_80  = bands1.3
                cw_40   = bands1.4
                ssb_40  = bands1.5
                cw_30   = bands1.6
                ssb_30  = bands1.7
                cw_20   = bands2.0
                ssb_20  = bands2.1
                cw_17   = bands2.2
                ssb_17  = bands2.3
                cw_15   = bands2.4
                ssb_15  = bands2.5
                cw_12   = bands2.6
                ssb_12  = bands2.7
                cw_10   = bands3.0
                ssb_10  = bands3.1
                cw_6    = bands3.2
                ssb_6   = bands3.3 
                cw_2    = bands3.4
                ssb_2   = bands3.5
                all_70  = bands3.6
                alarm_cw = options.0
                print_on = options.1
                preamble_on = options.2
                targets_on =  options.3

                return


bands_check:
                if strg_mhz[0] = " " then                       'convert strg to dec with leading zeros
                 strg_mhz[0] = 0
                else
                 strg_mhz[0] = strg_mhz[0] - 48
                endif
                if strg_mhz[1] = " " then
                 strg_mhz[1] = 0
                else
                 strg_mhz[1] = strg_mhz[1] - 48
                endif
                if strg_mhz[2] = " " then
                 strg_mhz[2] = 0
                else
                 strg_mhz[2] = strg_mhz[2] - 48
                endif

                freq_mhz = strg_mhz[0] * 100
                freq_mhz = freq_mhz + (strg_mhz[1] * 10)
                freq_mhz = freq_mhz + strg_mhz[2]

                if (freq_mhz >= 51) and (freq_mhz <= 54) then
                   freq_mhz = 51
                endif

                if (freq_mhz >= 145) and (freq_mhz <= 148) then
                   freq_mhz = 145
                endif

                if (freq_mhz >= 420) and (freq_mhz <= 450) then
                   freq_mhz = 420
                endif


                band = 15
                lookdown freq_mhz, [1,3,7,10,14,18,21,24,28,29,50,51,144,145,420], band


                branchl band, [band_160, band_80, band_40, band_30, band_20,_
                 band_17, band_15, band_12, band_10low, band_10high,_
                 band_6low,band_6high, band_2low, band_2high, band_70cm, nonham_band]
                return

band_160:       if (cw_160 = 1) and (freq_khz < cw_ssb_160) then bands_exit
                if (ssb_160 = 1) and (freq_khz >= cw_ssb_160) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_80:        if (cw_80 = 1) and (freq_khz < cw_ssb_80) then bands_exit
                if (ssb_80 = 1) and (freq_khz >= cw_ssb_80) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_40:        if (cw_40 = 1) and (freq_khz < cw_ssb_40) then bands_exit
                if (ssb_40 = 1) and (freq_khz >= cw_ssb_40) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_30:        if (cw_30 = 1) and (freq_khz < cw_ssb_30) then bands_exit
                if (ssb_30 = 1) and (freq_khz >= cw_ssb_30) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_20:        if (cw_20 = 1) and (freq_khz < cw_ssb_20) then bands_exit
                if (ssb_20 = 1) and (freq_khz >= cw_ssb_20) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_17:        if (cw_17 = 1) and (freq_khz < cw_ssb_17) then bands_exit
                if (ssb_17 = 1) and (freq_khz >= cw_ssb_17) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_15:        if (cw_15 = 1) and (freq_khz < cw_ssb_15) then bands_exit
                if (ssb_15 = 1) and (freq_khz >= cw_ssb_15) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_12:        if (cw_12 = 1) and (freq_khz < cw_ssb_12) then bands_exit
                if (ssb_12 = 1) and (freq_khz >= cw_ssb_12) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_10low:     if (cw_10 = 1) and (freq_khz < cw_ssb_10) then bands_exit
                if (ssb_10 = 1) and (freq_khz >= cw_ssb_10) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_10high:    if (ssb_10 = 1) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_6low:      if (cw_6 = 1) and (freq_khz < cw_ssb_6) then bands_exit
                if (ssb_6 = 1) and (freq_khz >= cw_ssb_6) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_6high:     if (ssb_6 = 1) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_2low:      if (cw_2 = 1) and (freq_khz < cw_ssb_2) then bands_exit
                if (ssb_2 = 1) and (freq_khz >= cw_ssb_2) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_2high:     if (ssb_2 = 1) then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

band_70cm:      if all_70 = 1 then bands_exit
                lcd_msecs = lcd_msecs - 500
                goto spot_in

nonham_band:   
                lcd_msecs = lcd_msecs - 500
                goto spot_in

bands_exit:     return



targets_check:  if targets_on = 1 then

                 for index5 = 0 to 11
                  if dx_in[index5] <> target1[index5] then target2_check
                 next index5
                 return

target2_check:   for index5 = 0 to 11
                  if dx_in[index5] <> target2[index5] then target3_check
                 next index5
                 return

target3_check:   for index5 = 0 to 11

                  if dx_in[index5] <> target3[index5] then
                   lcd_msecs = lcd_msecs - 500
                   goto  spot_in
                  endif

                 next index5
                 return

                else

                 return

                endif



alarm_checks:   if preamble_on = 1 then                         'checks if preamble is selected
                 for index4 = 18 to 118 step 10
                  sound AF_out, [index4, 5]
                 next index4
                 pause 500
                endif

                if alarm_cw = 0 then                            'checks if alarm in cw is selected                                           
                 swap dx_in[0], dx_in_beep[0]                   'swap to keep dx_in[1+2] unchanged
                 swap dx_in[1], dx_in_beep[1]
                  for index3 = 1 to alarm_rpt                   'repeats alarm alarm_rpt times
                   gosub identify
                  next index3
                 swap dx_in[0], dx_in_beep[0]          
                 swap dx_in[1], dx_in_beep[1]
                else
                 for index3 = 1 to alarm_rpt                    'repeats alarm alarm_rpt times
                  gosub identify
                 next index3
                endif

                return



eeprom_write:   write 0, bands1
                write 1, bands2
                write 2, bands3
                write 3, options
                write 4, tone
                write 5, dit_length
                write 6, alarm_rpt
                write 7, lcd_pause           

                target_char = 0
                for EEaddr = 8 to 19
                 write EEaddr, target1[target_char]
                 target_char = target_char + 1
                next EEaddr
                target_char = 0
                for EEaddr = 20 to 31
                 write EEaddr, target2[target_char]
                 target_char = target_char + 1
                next EEaddr
                target_char = 0
                for EEaddr = 32 to 43
                 write EEaddr, target3[target_char]
                 target_char = target_char + 1
                next EEaddr

                write 44, cw_ssb_160
                write 45, cw_ssb_80
                write 46, cw_ssb_40
                write 47, cw_ssb_30
                write 48, cw_ssb_20
                write 49, cw_ssb_17
                write 50, cw_ssb_15           
                write 51, cw_ssb_12
                write 52, cw_ssb_10
                write 53, cw_ssb_6
                write 54, cw_ssb_2           

                return



eeprom_read:    read 0, bands1
                read 1, bands2
                read 2, bands3
                read 3, options
                read 4, tone
                read 5, dit_length
                read 6, alarm_rpt
                read 7, lcd_pause

                target_char = 0
                for EEaddr = 8 to 19
                 read EEaddr, target1[target_char]
                 target_char = target_char + 1
                next EEaddr
                target_char = 0
                for EEaddr = 20 to 31
                 read EEaddr, target2[target_char]
                 target_char = target_char + 1
                next EEaddr
                target_char = 0
                for EEaddr = 32 to 43
                 read EEaddr, target3[target_char]
                 target_char = target_char + 1
                next EEaddr

                read 44, cw_ssb_160
                read 45, cw_ssb_80
                read 46, cw_ssb_40
                read 47, cw_ssb_30
                read 48, cw_ssb_20
                read 49, cw_ssb_17
                read 50, cw_ssb_15           
                read 51, cw_ssb_12
                read 52, cw_ssb_10
                read 53, cw_ssb_6
                read 54, cw_ssb_2           

                return



answ_R:         tone        = 117
                dit_length  = 4
                dah_length  = 12
                char_spc    = 7
                word_space  = 42
                swap dx_in[0], dx_in_R[0]                       'swap to keep dx_in[1+2] unchanged
                swap dx_in[1], dx_in_R[1]
                gosub identify
                swap dx_in[0], dx_in_R[0]                       'swap to keep dx_in[1+2] unchanged
                swap dx_in[1], dx_in_R[1]
                read 4, tone
                read 5, dit_length
                dah_length  = dit_length * 3
                char_spc    = dah_length - 5
                word_space  = dah_length * 2
                return

      
identify:                
                for index1 = 0 to 11
                 character = dx_in[index1]
                 if character = " " then id_leave
                 gosub morse
                next
id_leave:       sound AF_out, [quiet, word_space]
                return


morse:          character = character - 47
                lookup character, [149, 253, 125, 61, 29, 13, 5, 133, 197,_
                229, 245, 54, 54, 54, 54, 54, 54, 54, 66, 132, 164, 131,_
                1, 36, 195, 4, 2, 116, 163, 68, 194, 130, 227, 100, 212,_
                67, 3, 129, 35, 20, 99, 148, 180, 196], character

                elements = character & %00000111
                if elements = 7 then adjust1
                if elements = 6 then adjust2

bang_key:       for index2 = 1 to elements
                 if character >= 128 then dah
                 goto dit
reenter:         character = character * 2
                next
                gosub char_space
                return

adjust1:        elements = 6
                goto bang_key
adjust2:        character = character & %11111011
                goto bang_key
                
dit:            sound AF_out, [tone, dit_length]
                sound AF_out, [quiet, dit_length]
                goto reenter

dah:            sound AF_out, [tone, dah_length]
                sound AF_out, [quiet, dit_length]
                goto reenter
           
char_space:     sound AF_out, [quiet, char_spc]
                return

                
