; 
; Setup D/A converter pins
LO_FREQ:
		bcf		PORTB,1	;CS pin=0
		bcf		PORTB,2	;Clock pin=0
		bcf		PORTB,3	;Data pin=0
;
; Four Bytes for two D/A Converter...
		movlw	0x08
		movwf	ROT_COUNT		
		bcf		INTCON,RBIE
		movf	FREQ_HI,W
		andlw	0x3f		;Clear A*/B and BUF
		iorlw	0x30		;set GA* and SHDN*
		call	D2A_Shift
		movlw	0x08
		movwf	ROT_COUNT		
		movf	FREQ_LO,W
		call	D2A_Shift
		bsf		PORTB,1	;CS pin=1
		bcf		PORTB,2	;Clock pin=0
		bcf		PORTB,3	;Data pin=0

		movf	FREQ_HI,W
		movwf	TEMP_HI
		movf	FREQ_LO,W
		addwf	FREQ_OST,W
		movwf	TEMP_LO
		btfsc	STATUS,C
		incf	TEMP_HI,F
		btfss	TEMP_HI,4
		goto	D2A2_MASK
		movlw	0xff
		movwf	TEMP_HI
		movwf	TEMP_LO
D2A2_MASK
		bsf		INTCON,RBIE
		bcf		PORTB,1	;CS pin=0
		movlw	0x08
		movwf	ROT_COUNT		
		movf	TEMP_HI,W
		andlw	0xbf		;clear BUF
		iorlw	0xb0		;set GA* and SHDN*
		call	D2A_Shift
		movlw	0x08
		movwf	ROT_COUNT		
		movf	TEMP_LO,W
		call	D2A_Shift

;
; Set D/A pins
		bsf		PORTB,1	;CS pin=1
		bcf		PORTB,2	;Clock pin=0
		bcf		PORTB,3	;Data pin=0
		movlw	.50
		movwf	FREQ_STORE
;
		return
;
; This routine shifts a byte out the D/A port
D2A_Shift:
		movwf	ROT_TEMP
D2A_nxt_bit:
		btfss	ROT_TEMP,7
		bcf		PORTB,3	;Set data line low
		btfsc	ROT_TEMP,7
		bsf		PORTB,3	;Set data line high

		bsf		PORTB,2	;Toggle clock high
		bcf		PORTB,2	;Toggle clock low

		rlf		ROT_TEMP,F
		decfsz	ROT_COUNT,F
		goto	D2A_nxt_bit
		return
