;
;
; EEPROM Read
EE_READ:
				bsf			STATUS,RP1
				bcf			STATUS,RP0		; Bank 2
				movf		EE_ADDR,W		; Put address in SFR
				movwf		EEADR
				bsf			STATUS,RP0		; Bank 3
				bcf			EECON1,EEPGD	; Point to data memory
				bsf			EECON1,RD		; Start read
				bcf			STATUS,RP0		; Bank 2
				movf		EEDATA,W		; Save data
				movwf		EE_DATA
				bcf			STATUS,RP1		; Bank 0
				return
;
;
; EEPROM Write
EE_WRITE:
				bsf 		STATUS,RP0
				bsf 		STATUS,RP1		; Bank 3
				btfsc		EECON1,WR
				goto		$-1				; Wait for last write to complete
				bcf			STATUS,RP0		; Bank 2
				movf		EE_ADDR,W		; Put address in SFR
				movwf		EEADR
				movf		EE_DATA,W		; Put data in SFR
				movwf		EEDATA
				bsf 		STATUS,RP0		; Bank 3
				bcf			EECON1,EEPGD	; Point to data memory
				bsf			EECON1,WREN		; Enable writes
				bcf			INTCON,GIE		; Disable interrupts
				movlw		0x55			; do timed access writes
				movwf		EECON2
				movlw		0xaa
				movwf		EECON2
				bsf			EECON1,WR		; begin writing to flash
				bsf			INTCON,GIE		; Enable interrupts
				bcf			EECON1,WREN		; Disable writes
				bcf 		STATUS,RP0
				bcf 		STATUS,RP1		; Bank 0
				return
