INT_CODE:
				movwf	W_TEMP
				swapf	STATUS,w
				clrf	STATUS
				movwf	STAT_TEMP
				bcf		INTCON,GIE			; Turn off all interrupts
				btfss	INTCON,T0IF			;
				goto	PB47_INT			; Jump if it's a line change interrupt
											; otherwise it's a T0 interupt
				movlw	0x18				; Turn off LO to counter
				iorwf	PORTC,f				; Turn off BFO to coounter	
				bsf		CNT_STAT,DONE_CTNG	; Stop counters and set 'done' flag

				bcf		INTCON,T0IE			; Turn off timer 0 interrupt
				bcf		INTCON,T0IF			; Clear flag
				bsf		CNT_STAT,ISR_RUN	; Set ISR Flag
				goto 	T0END
				
PB47_INT:
				movf	PORTB,W				; Read PORT B clearing the interrupt
				movwf	CURR_B				; Store Current State
				xorwf	PREV_B,W			; See which bit changed
				movwf	I_TEMP				; Store the result
ENCODER_A:		
				btfss	I_TEMP,4			; Test for ENCODER A
				goto	ENCODER_B
				btfsc	CURR_B,5			; IS A=0
				goto	ENCA_1
				btfsc	CURR_B,4			; IS B=0
				goto	F_DOWN				; IF A=0 and B=1 then dowm
				goto	F_UP				; IF A=0 and B=0 then up
ENCA_1:
				btfss	CURR_B,4			; IS B=1
				goto	F_DOWN				; IF A=1 and B=1 then up
				goto	F_UP				; IF A=1 and B=0 then down
;			
ENCODER_B:									; Must be ENCODER B
				btfss	I_TEMP,5			; Test for ENCODER A
				goto	DIT
				btfsc	CURR_B,5			; IS A=0
				goto	ENCA_1A
				btfsc	CURR_B,4			; IS B=0
				goto	F_UP				; IF A=0 and B=1 then up
				goto	F_DOWN				; IF A=0 and B=0 then down
ENCA_1A:
				btfss	CURR_B,4			; IS B=1
				goto	F_UP				; IF A=1 and B=1 then down
				goto	F_DOWN				; IF A=1 and B=0 then up
F_UP:
				movlw	0x13
				andwf	SET_FNC,W
				btfss	_Z
				goto	BF_UP
				btfsc	SSTAT,RATE
				goto	F_UP_FAST
				incf	FREQ_OST,F
				btfss	FREQ_OST,3
				goto	F_SEND
				clrf	FREQ_OST
F_UP_FAST:
				incf	FREQ_LO,F			; Frequency UP
				btfsc	STATUS,Z
				incf	FREQ_HI,F
				btfss	FREQ_HI,4			; 0x0FFF maximum value
				goto 	F_SEND	
				movlw	0x0f
				movwf	FREQ_HI
				movlw	0xff
				movwf	FREQ_LO
				goto 	F_SEND	
BF_UP:
				incf	WHEEL,F
				btfsc	_Z
				comf	WHEEL,F
				bsf		SSTAT,WHL
				goto	INTEND
BF_DN:
				decf	WHEEL,F
				bsf		SSTAT,WHL
				goto	INTEND
F_DOWN:
				movlw	0x13
				andwf	SET_FNC,W
				btfss	_Z
				goto	BF_DN
				btfsc	SSTAT,RATE
				goto	F_DOWN_FAST
				movf	FREQ_OST,F
				btfss	STATUS,Z
				goto	F_DWN1
				movlw	0x07
				movwf	FREQ_OST
F_DOWN_FAST:
				movf	FREQ_LO,F
				btfsc	STATUS,Z
				decf	FREQ_HI,F
				decf	FREQ_LO,F
				decf	FREQ_HI,W
				btfss	_Z
				goto 	F_SEND	
				movlw	0x02
				movwf	FREQ_HI
				clrf	FREQ_LO	
				goto	F_SEND
F_DWN1			decf	FREQ_OST,F

;
F_SEND:
				bsf		SSTAT,UPDATE_FR
				goto 	INTEND
DIT:
;
; 25 msec keybounce delay
				movlw	.200
				MOVWF	IXDELAY	
I_D100:
				MOVLW	.165
				MOVWF	IDELAY
I_D100_LOOP:
				DECFSZ	IDELAY, F
				GOTO	I_D100_LOOP
				DECFSZ	IXDELAY, F	
				GOTO	I_D100

				btfss	I_TEMP,6			; Test for DIT
				goto	PTT_DAH
				goto 	INTEND
PTT_DAH:		
;
; SET PTT CHANGE FLAG
				btfss	I_TEMP,7			; Test for DIT
				goto	INTEND
				bsf		DISP_FLAG,0
				btfss	PORTB,7
				goto	ISR_PTT_ON
				btfss	OPMODE,0			; Don't unkey if in CW ...
				bcf		PORTB,0
				goto	INTEND
ISR_PTT_ON:
				bsf		PORTB,0
;				btfss	OPMODE,0			; Check if CW
				goto	INTEND
;				movlw	0x20
;				movwf	TX_DELAY			; TX Hold Up
ISR_CW_KEY:
;				bsf		PORTC,5
;				movlw	.6
;				call	X_DELAY100
;				bcf		PORTC,5
;				movlw	.6
;				call	X_DELAY100
;				btfss	PORTB,7
;				goto	ISR_CW_KEY
;				bcf		DISP_FLAG,0
INTEND:
				bcf		INTCON,RBIF			; Clear current interrupt
				movf	CURR_B,W			; PREV State = CURR State
				movwf	PREV_B

T0END:
				swapf	STAT_TEMP,W
				movwf	STATUS
				swapf 	W_TEMP,F
				swapf	W_TEMP,W
				retfie

