
				#include <p16f871.inc>
				ERRORLEVEL -224        ;  suppress annoying message because of tris

;=============================================================================
;	Filename:	TAK40.asm
;=============================================================================
;	Author:		Jim Veatch
;	Callsign:	WA2EUJ
;	Revision:	1.00
;	Date:		11 Noveber 2006
;	Assembled using MPASM V7.20
;=============================================================================
;	Include Files:	p16f871.inc	
;=============================================================================
;	
;=============================================================================
BAUD_9600		equ	0x81					;ASYNC port baud rate 9600
BAUD_19200		equ	0x40					;ASYNC port baud rate 19200
BAUD_CONSTANT	EQU	BAUD_9600				;Constant for baud generator for 19200 baud
;     STATUS bit definitions
				#define	_C		STATUS,0
				#define	_Z		STATUS,2
;Fosc is 20MHz
;
;These Values are for the 24X1 Display
GetHexByte		equ	0x077f					; Rcvs two ASCII digits and converts into one HEX byte in W
LCD_CLEAR		equ	0x01					; Clear the display
LCD_HOME		equ	0x02					; Cursor Home
LCDPUTCHAR      equ	0x7CE					; Sends character in W to LCD for display					
LCDPUTCMD       equ	0x7DF					; Sends character in W to LCD command register
LCDSDDA         equ 0x7CB					; Takes DD Address in W and sets DD address in LCD display
SerialReceive	equ	0x0799					; Waits for an incoming byte, returns with the byte in W
SerialTransmit	equ	0x079f					; Waits for the serial TX buffer to empty and sends the byte in W
FP_READ			equ	0x07b5					; Reads the front panel switches and stores in FP_Switch
X_DELAY100		equ	0x07f1					; Generates a delay of W*100 uSec

W_TEMP			equ 0x70					; Bank Independant storage for W
EE_ADDR			equ	0x71					; EEPROM R/W Address storage
EE_DATA			equ	0x72					; EEPROM R/W Data storage
SELECT			equ	0x00					; Select pushbutton
;RATE			equ	0x01					; Rate pushbutton
MODE			equ	0x02					; Mode pushbutton
TUNE			equ	0x03					; Tune pushbutton
VFO_AB			equ	0x04					; VFO A/B pushbutton
V2M				equ 0x05					; VFO to MEMORY pushbutton
M2V				equ	0x06					; MEMORY to VFO pushbutton
SWAP			equ	0x07					; SWAP pushbutton
VA_HI			equ	0x00					; EEPROM Location for VFO A MSB
VB_HI			equ	0x01					; EEPROM Location for VFO B MSB
VA_LO			equ	0x02					; EEPROM Location for VFO A LSB
VB_LO			equ	0x03					; EEPROM Location for VFO B LSB
VA_OS			equ	0x04					; EEPROM Location for VFO A Offset
VB_OS			equ	0x05					; EEPROM Location for VFO B Offset
SC_HI			equ	0x06					; EEPROM Location for scratch MSB
SC_LO			equ	0x07					; EEPROM Location for scratch LSB
SC_OS			equ	0x08					; EEPROM Location for scratch Offset
CR_HI			equ	0x09					; EEPROM Location for current MSB
CR_LO			equ	0x0a					; EEPROM Location for current LSB
CR_OS			equ	0x0b					; EEPROM Location for current Offset
VFAB			equ	0x0c					; EEPROM Location for BAND
OPMD			equ	0x0d					; EEPROM Location for OPMODE
BFO_L			equ 0x0e					; EEPROM Location for LSB BFO PWM word
BFO_U			equ 0x0f					; EEPROM Location for USB BFO PWM word
BFO_USB			equ 0x10					; EEPROM Location for USB Counter LSB
BFO_LSB			equ 0x12					; EEPROM Location for LSB Counter LSB
NOT_CTNG		equ	0x00					; Not Counting BIT
CTNG_LO			equ	0x01					; Counting LO bit
CTNG_BF			equ	0x02					; Counting BFO bit
DONE_CTNG		equ	0x03					; Counting Finished
ISR_RUN			equ 0x04					; ISR messed up the count
MSB				equ	7
LSB				equ	0
UPDATE_FR		equ 0						; SSTAT: Update frequency flag
RATE			equ	1						; SSTAT: Tuning Rate Flag
BFO_SEEK		equ	2						; SSTAT: BFO Tuning Flag
SEL_KEY			equ 3						; SSTAT: Select Key Active
SEL_SET			equ 4						; SSTAT: Setup Key Active
S_CNT			equ	5						; SSTAT: Alternating Count Display Bit
WHL				equ	6						; SSTAT: Wheel Update Flag
SM				equ	7						; SSTAT: TX



;Variables in bank0

		CBLOCK	0x20
		LCD_TEMP:		1					; [20] LCD subroutines internal use
		TABLE_INDEX:	1					; [21] Index to table strings
		COUNT:			1					; [22] A counter
		DELAY:			1					; [23] Used in DELAYxxx routines
		X_DELAY:		1					; [24] Used in X_DELAYxxx routines
		FP_Switch:		1					; [25] Front Panel Switch State
		PREV_FP:		1					; [26] Previous state of FP switched
		STAT_TEMP:		1					; [27] Interrupt Storage for STATUS Register
		TEMP_LO:		1					; [28] 16 Bit LO Temp storage
		TEMP_HI:		1					; [29] 16 Bit HI Temp storage
		CURR_B:			1					; [2A] Current state of PORT B
		PREV_B:			1					; [2B] Previous state of PORT B
		FREQ_LO:		1					; [2C] LO Frequency LSB
		FREQ_HI:		1					; [2D] LO Frequency MSB
		FREQ_OST:		1					; [2E] LO Frequency Offset
		FREQ_STP:		1					; [2F] Frequency step
		ROT_TEMP:		1					; [30] Data Shifter
		ROT_COUNT:		1					; [31] Data Counter
		I_TEMP:			1					; [32] Temporary storage for Interrupt Routine
		FP_TEMP:		1					; [33] Temporary storage for FP switch routine
		TP_HI:			1					; [34] Temporary storage for frequency word H
		TP_LO:			1					; [35] Temporary storage for frequency word M
		TP_OS:			1					; [36] Temporary storage for frequency word L
		CNT_STAT:		1					; [37] Frequency Conter Status
		C_FREQL:		1					; [38] Results of frequency counter H
		C_FREQM:		1					; [39] Results of frequency counter M
		C_FREQH:		1					; [3A] Results of frequency counter L
		nratorH:		1					; [3B] Divide numerator H
		nratorM:		1					; [3C] Divide numerator M
		nratorL:		1					; [3D] Divide numerator L
		denomH:			1					; [3E] Divide denominator H
		denomM:			1					; [3F] Divide denominator M
		denomL:			1					; [40] Divide denominator L
		remainH:		1					; [41] Divide remainder H
		remainM:		1					; [42] Divide remainder M
		remainL:		1					; [43] Divide remainder L
		shiftH:			1					; [44] Divide shifter H
		shiftM:			1					; [45] Divide shifter M
		shiftL:			1					; [46] Divide shifter L
		BCount:			1					; [47] Divide Routine Counter
		LAST_F1:		1					; [48] LSB of last freq count
		LAST_F2:		1					; [49] LSB of next to the last count
		FREQ_STORE:		1					; [4A] Counter to store the dial freq
		SSTAT:			1					; [4B] Software status register
		DISP_DELAY:		1					; [4C] Pause to display status counter
		LAST_B1:		1					; [4D] LSB of last BFO freq count
		LAST_B2:		1					; [4E] LSB of next to the last BFO count
		L0CT1:			1					; [4F] LSB of BFO freq count
		LOCT2:			1					; [50] MSB of BFO freq count
		BFO_FRL:		1					; [51] LSB of Desired BFO Freq
		BFO_FRH:		1					; [52] MSB of Desired BFO Freq
		BFO_STL:		1					; [53] LSB of Desired BFO Freq
		BFO_STH:		1					; [54] MSB of Desired BFO Freq
		HIRES_TEMP:		1					; [55] Loop counter
		OPMODE:			1					; [56] Mode Bit0 = CW, Bit1 = USB Bit2 = LSB
		LAST_BF1:		1					; [57] LSB of last BFO freq count
		LAST_BF2:		1					; [58] LSB of next to the last BFO count
		SEL_FNC:		1					; [59] Select Function 0=RIT, 1=PBT
		SET_FNC:		1					; [5A] Setup Function
		WHEEL:			1					; [5B] BFO setting wheel
		ACount:			1					; [5C] A2D digit counter
		PREV_A2D:		1					; [5D] Previos A2D reading
		CCount:			1					; [5E] A2D digit counter
		L_ONE:			1					; [5F] S-METER Single Chararacter
		L_TWO:			1					; [60] S-METER Dual Chararacter
		DISP_FLAG:		1					; [61] Display Update Flag
		TX_DELAY:		1					; [62] CW Key Delay
		IDELAY:			1					; [63] Key Bounce Delay Counter
		IXDELAY:		1					; [64] Key Bounce Delay Counter
		TXM_STAT:		1					; [65] TX Meter Status
		TXM_DATA:		1					; [66] TX Meter Data
		TXM_CNTR:		1					; [67] TX Meter Digit Counter
		FORCE_D:		1					; [68] Forces frequency display
		ENDC
;
;Interrupt Service Vector
				org	0x04
				goto 	INT_CODE

				org	0x06
START										; POWER_ON Reset (Beginning of user program)
;
; Initialize I/O ports, A/D converter and Timers
				include 	"tak-ports.asm"


;*****************************************************************************
; Clear the display
;*****************************************************************************

				movlw	.250
				call	X_DELAY100
;
; Recall Mode Band and Frequency
;

MAIN:
				call	CG_DATA				; Setup Special Characters

				movlw	VFAB				; Restore VFO A/B setting
				movwf	EE_ADDR
				call	EE_READ
				bcf 	PORTC,1
				btfsc	EE_DATA,0
				bsf 	PORTC,1

				movlw	OPMD				; Restore OP Mode
				movwf	EE_ADDR
				call	EE_READ
				movf	EE_DATA,W
				andlw	0x07
				btfsc	_Z
				movlw	0x02
				movwf	OPMODE
				bcf		PORTB,0				; RX mode
				call	SET_OP_MODE
				call	LCD_MODE

				call	RECALL_CUR			; Recall Frequency
				bsf		SSTAT,UPDATE_FR

				movf	PORTB,W
				bcf		INTCON,RBIF
				bsf		INTCON,PEIE			; Enable Peripheral Interrupts

				btfss	FP_Switch,SWAP		; Look for SWAP (SETUP) button press
				goto	SETUP				; If not pressed START main code code

LOOP:
;
; Update Frequency?
				btfss	SSTAT,UPDATE_FR
				goto	F_UPDATE_END
				bcf		SSTAT,UPDATE_FR
				call	LO_FREQ
F_UPDATE_END:
;
				btfsc	OPMODE,0			; Skip this process if CW
				goto	DISP_END
				btfss	DISP_FLAG,0
				goto	DISP_END
				clrf	DISP_FLAG
				movlw	LCD_CLEAR
				call	LCDPUTCMD
				movlw	.50
				call	X_DELAY100
				clrf	TXM_STAT
				bsf		FORCE_D,0
				call	LCD_MODE
DISP_END:
;
; TX Watt meter
				btfsc	OPMODE,0			; Skip this process if CW
				goto	WMETER_END
				btfss	PORTB,0
				goto	WMETER_END			; Skip wattmeter if receiving
				movlw	0x09
				movwf	TXM_CNTR
WMETER_LP:
				call	TX_METER
				decfsz	TXM_CNTR,F
				goto	WMETER_LP
WMETER_END:
;
; CW Transmit Processor
				btfss	OPMODE,0
				goto	CW_END
				btfss	DISP_FLAG,0			; Check for state change
				goto	CW_END
				clrf	TXM_STAT

CW_KEY_LP:
				bsf		PORTC,5
				movlw	.5
				call	X_DELAY100
				bcf		PORTC,5
				call	TX_METER
;				movlw	.1
;				call	X_DELAY100
				btfss	CURR_B,7
				goto	CW_KEY_LP
				bcf		DISP_FLAG,0
				movlw	.250
				movwf	TX_DELAY			; TX Hold Up
CW_DECAY:
				movlw	.28
				call	X_DELAY100
				call	TX_METER
				btfss	CURR_B,7
				goto	CW_KEY_LP
				decfsz	TX_DELAY,F
				goto	CW_DECAY
CWU_UNK:
				movlw	LCD_CLEAR
				call	LCDPUTCMD
				movlw	.50
				call	X_DELAY100
				bsf		FORCE_D,0
				bcf		PORTB,0
				call	LCD_MODE
CW_END:
;
; Front Panel Switch Processor
FP_ROUTINE:
				btfsc	PORTB,0
				goto	END_FP_SW
				movf	FP_Switch,W			; Save last state
				movwf	PREV_FP
				call	FP_READ				; read current state
				movf	FP_Switch,W			; Get current state
				xorwf	PREV_FP,W			; Look For Changes
				movwf	FP_TEMP				; Save Result

				movlw	.200
				call	X_DELAY100			; Wait 20 msec for switch bounce				
				btfss	FP_TEMP,VFO_AB		; VFO A/B Switch
				goto	NOT_VFO_AB	
				btfss	FP_Switch,VFO_AB	; Process on button up
				goto	END_FP_SW
				call 	SWAP_SC
				bsf		SSTAT,UPDATE_FR
				movlw	0x02				; Invert BIT 1
				xorwf	PORTC,F				; Toggle VCO range
				movlw	VFAB
				movwf	EE_ADDR
				movlw	0x01
				btfsc	PORTC,1
				movlw	0x00
				movwf	EE_DATA
				call	EE_WRITE
				call	LCD_VFO				
				goto	END_FP_SW
NOT_VFO_AB:
				btfss	FP_TEMP,V2M			; VFO to MEMORY Switch
				goto	NOT_V2M
				btfss	FP_Switch,V2M		; Process on button up
				goto	END_FP_SW
				call	STORE_VFO
				call 	LCD_STORE
				goto	END_FP_SW
NOT_V2M:
				btfss	FP_TEMP,SWAP		; SWAP Switch
				goto	NOT_SWAP
				btfss	FP_Switch,SWAP		; Process on button up
				goto	END_FP_SW

				movf	FREQ_HI,W			; VFO to TEMP
				movwf	TP_HI				
				movf	FREQ_LO,W
				movwf	TP_LO				
				movf	FREQ_OST,W
				movwf	TP_OS				

				call	RECALL_VFO			; Memory to VFO

				call	TEMP2MEM			; TEMP to Memory
				bsf		SSTAT,UPDATE_FR
				call	LCD_SWAP
				goto	END_FP_SW
NOT_SWAP:
				btfss	FP_TEMP,RATE		; RATE Switch
				goto	NOT_RATE
				btfss	FP_Switch,RATE		; Process on button up
				goto	END_FP_SW
				movlw	0x02				; Invert BIT 1
				xorwf	SSTAT,F				; Toggle RATE
				call	LCD_RATE
				goto	END_FP_SW
NOT_RATE:
				btfss	FP_TEMP,MODE		; Mode SW
				goto	NOT_MODE
				btfss	FP_Switch,MODE		; Process on button up
				goto	END_FP_SW
				bcf		_C					; Clear carry bit
				rlf		OPMODE,F			; Change Mode
				btfss	OPMODE,3			; if LSB roll around to CW
				goto	MODESW1
				movlw	0x01
				movwf	OPMODE
MODESW1:
				call	SET_OP_MODE
				call	LCD_MODE
				movlw	OPMD
				movwf	EE_ADDR
				movf	OPMODE,W
				movwf	EE_DATA
				call	EE_WRITE
				goto	END_FP_SW
NOT_MODE:
END_FP_SW:
;
; Meter Routine
				btfsc	PORTB,0
				goto	A2D_DONE			; Don't do the S Meter while transmitting
				movlw	0x95				; Start Conversion
				movwf	ADCON0
A2D_LOOP:
				btfsc	ADCON0,GO_DONE
				goto	A2D_LOOP			; Wait until Conversion is complete
				bcf		_C
				RRF		ADRESH,F			; Divide by 2
				movlw	0x44				; Subtract no-sig voltage (2.5 Volts)
				subwf	ADRESH,F
				btfss	_C					; if it's less than 0 then make it 0
				clrf	ADRESH
				call	CHECK_KEY
				iorlw	0x00
				btfss	_Z
				goto	A2D_DONE

				movlw	0x14
				call	LCDSDDA				; Position Cursor

				movlw	0x02
				movwf	L_ONE				; Single short bar
				movlw	0x03
				movwf	L_TWO				; Dual short bar
				movlw	0x07
				movwf	CCount				; CCount = 8
				movlw	0x02
				subwf	ADRESH,W			; is ADRESH >= 2
				btfss	_C					; Yes: Skip
				goto	A2D_SDASH			; No: Update display
				movf	L_TWO,W
				call	LCDPUTCHAR			; Print a double bar
				decf	ADRESH,F
A2D_NEXT:
				decfsz	ADRESH,F			; Dec result and print spaces if 0
				goto	A2D_1
				goto	A2D_SPACE
A2D_1:
				decfsz	ADRESH,F			; Dec result and print single dash if 0
				goto	A2D_2
				goto	A2D_SDASH
A2D_2:
				movf	L_TWO,W
				call	LCDPUTCHAR
				decfsz	CCount,F
				goto	A2D_SKIP
				goto	A2D_DONE
A2D_SKIP:
				movlw	0x05
				subwf	CCount,W
				btfss	_Z
				goto	A2D_NEXT
				movlw	0x01
				movwf	L_ONE				; Single long bar
				movlw	0xa0
				movwf	L_TWO				; Dual long bar
				goto	A2D_NEXT

A2D_SDASH:
				movf	L_ONE,W
				call	LCDPUTCHAR			; Print a single bar
				decf	CCount,F
				btfsc	_Z
				goto	A2D_DONE
A2D_SPACE:
				movlw	" "
				call	LCDPUTCHAR
				decfsz	CCount,F
				goto	A2D_SPACE

								
A2D_DONE:
;
; Frequency Counter
				btfss	CNT_STAT,NOT_CTNG
				goto	CNTING				; If not counting start a count

				clrf	TMR1L				; Clear Timer1
				clrf	TMR1H				

				bcf		PORTC,4				; Apply LO to Counter				
				movlw	0x02
				movwf	CNT_STAT			; Clear not ocunting flag, set LO counting flag
				movlw	.20
				movwf	BCount
				decfsz	BCount,F
				goto	$-1
				movlw	0x3d				; Timer0 Value
				movwf	TMR0

				bcf		INTCON,T0IF			; Clear and old interrupt flags
				bsf		INTCON,T0IE			; Enable the T0 interrupt
				goto	COUNTER_DONE
CNTING:				
				btfss	CNT_STAT,DONE_CTNG	; Check if count is complete
				goto	COUNTER_DONE
				btfss	CNT_STAT,CTNG_LO	; Check if counting LO ro BFO
				goto 	DISPLAY_FQ

				movf	TMR1L,W				; Get and save LO count
				movwf	C_FREQL
				movf	TMR1H,W				; Get and save LO count
				movwf	C_FREQM
				clrf	C_FREQH				
				clrf	TMR1L				; Clear Timer1 
				clrf	TMR1H				
				bcf		PORTC,3				; Apply BFO to Counter				
				movlw	0x04
				movwf	CNT_STAT			; Clear not ocunting flag, set BFO counting flag
				movlw	.20
				movwf	BCount
				decfsz	BCount,F
				goto	$-1
				movlw	0x3d				; Timer0 Value
				movwf	TMR0

				bcf		INTCON,T0IF			; Clear and old interrupt flags
				bsf		INTCON,T0IE			; Enable the T0 interrupt
				goto	COUNTER_DONE
DISPLAY_FQ:
				movlw	0x01
				movwf	CNT_STAT			; Count Done

				movf	TMR1L,W				; Anti-jitter routine
				subwf	LAST_B1,W
				btfsc	_Z
				goto	ADD_BFO				; Same as last count
				movf	TMR1L,W				; Anti-jitter routine
				subwf	LAST_B2,W
				btfsc	_Z
				goto	ADD_BFO				; Same as next to last count
				movf	LAST_B1,W
				movwf	LAST_B2
				movf	TMR1L,W
				movwf	LAST_B1				; Save previous states				
				movf	TMR1L,W				; Get and save BFO count
				movwf	L0CT1
				movf	TMR1H,W				; Get and save BFO count
				movwf	LOCT2
ADD_BFO:
				movf	L0CT1,W				; Get BFO and add to LO count
				btfsc	_Z					; No need to add if it's zero
				goto	NOADD
				addwf	C_FREQL,F
				btfsc	_C
				incf	C_FREQM,F
				btfsc	_Z
				incf	C_FREQH,F
NOADD:
				movf	LOCT2,W
				addwf	C_FREQM,F
				btfsc	_C
				incf	C_FREQH,F
				movf	FREQ_STORE,F
				btfsc	_Z
				goto	ANTI_JITTER
				decfsz	FREQ_STORE,F
				goto	ANTI_JITTER
				call	STORE_CUR

ANTI_JITTER:
				movf	DISP_DELAY,F		; Check of counter=0
				btfsc	_Z
				goto 	DISP_FREQ
				decfsz	DISP_DELAY,F
				goto	COUNTER_DONE		; Don't display the freq until counter reaches 0
				goto	DISP_ANYWAY
DISP_FREQ:
				btfsc	FORCE_D,0
				goto	DISP_ANYWAY
				movf	C_FREQL,W			; Anti-jitter routine
				subwf	LAST_F1,W
				btfsc	_Z
				goto	COUNTER_DONE		; Same as last count
				movf	C_FREQL,W			; Anti-jitter routine
				subwf	LAST_F2,W
				btfsc	_Z
				goto	COUNTER_DONE		; Same as next to last count
				movf	LAST_F1,W
				movwf	LAST_F2
				movf	C_FREQL,W
				movwf	LAST_F1				; Save previous states				
DISP_ANYWAY:
				bcf		FORCE_D,0
				call	CHECK_KEY
				iorlw	0x00
				btfss	_Z
				goto	COUNTER_DONE
				call	DISP_C_FREQ
COUNTER_DONE:
;
; High resolution BFO tracking system
				call	BFO_HIRES
				GOTO	LOOP				; Stay here forever
;
; Interrupt Service Routine
				include		"TAK-ISR.asm"
;
;
; Set LO Frequency
				include 	"MCP4922.asm"
;
; EEPROM Read and Write Routines
				include		"TAK-EEPROM.asm"
;
; Memory functions
				include		"TAK-VFOMEM.asm"
;
; Display Messages
				include		"TAK_MSG.asm"
;
; Display Frequency
				include		"TAK_FREQ.asm"
;
; Setup Routines
				include		"TAK_SETUP.asm"
;
; BFO Stabalizer
				include		"TAK_BFO.asm"
;
; TX Meter
				include 	"TAK_TXM.asm"

;
; Check For Key Press
CHECK_KEY:
				bsf		STATUS, RP0			; Switch to bank1
				MOVLW	0x0FF				; Set PORTD for input
				MOVWF	TRISD
				BCF		STATUS, RP0			; Select Register page 0

				comf	PORTD,W

				BSF		STATUS, RP0			; Select Register page 1
				CLRF	TRISD				; Set PORTD for output
				BCF		STATUS, RP0			; Select Register page 0
				return
;
; Sets the operating mode CW, USB or LSB
SET_OP_MODE
				bsf		SSTAT,BFO_SEEK
				btfss	OPMODE,2				; Test for LSB
				goto	MODENOTLSB
; Set BFO to Stored LSB setting (3999.70 to 4002.25 kHz)
				movlw	0x24
				movwf	BFO_FRH
				movlw	BFO_LSB
				movwf	EE_ADDR
				call	EE_READ
				movf	EE_DATA,W
				movwf	BFO_FRL
; current BFO setting
				movlw	BFO_L
				goto	RECALL_BFO
MODENOTLSB:
; Set BFO to Stored USB setting (3997.14 to 3999.69 kHz)
				movlw	0x23
				movwf	BFO_FRH
				movlw	BFO_USB
				movwf	EE_ADDR
				call	EE_READ
				movf	EE_DATA,W
				movwf	BFO_FRL
; current BFO setting
				movlw	BFO_U
RECALL_BFO:
				movwf	EE_ADDR
				call	EE_READ
				movf	EE_DATA,W
				movwf	BFO_STH
				movwf	CCPR1L
				movf	BFO_FRL,W			; Setup mode only
				movwf	WHEEL				; Set BFO wheel to current value
				bsf		SSTAT,WHL			; Clear status flag
				return
;
; LCD Special Character data
CG_DATA:
				movlw	0xa0
				call	LCDPUTCMD
				movlw	0x00
				call	LCDPUTCHAR
				movlw	0x0e
				call	LCDPUTCHAR
				movlw	0x1f
				call	LCDPUTCHAR
				movlw	0x1f
				call	LCDPUTCHAR
				movlw	0x1f
				call	LCDPUTCHAR
				movlw	0x1f
				call	LCDPUTCHAR
				movlw	0x0e
				call	LCDPUTCHAR
				movlw	0x00
				call	LCDPUTCHAR

				movlw	0x00
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR

				movlw	0x00
				call	LCDPUTCHAR
				movlw	0x00
				call	LCDPUTCHAR
				movlw	0x00
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR
				movlw	0x18
				call	LCDPUTCHAR

				movlw	0x00
				call	LCDPUTCHAR
				movlw	0x00
				call	LCDPUTCHAR
				movlw	0x00
				call	LCDPUTCHAR
				movlw	0x1b
				call	LCDPUTCHAR
				movlw	0x1b
				call	LCDPUTCHAR
				movlw	0x1b
				call	LCDPUTCHAR
				movlw	0x1b
				call	LCDPUTCHAR
				movlw	0x1b
				call	LCDPUTCHAR
				movlw	0xe0
				call	LCDPUTCMD
				return
				END
