;
; High resolution BFO tracking system
BFO_HIRES:
				btfss	CNT_STAT,NOT_CTNG
				goto	BFO_DONE			; If already counting, don't adjust BFO

				bcf		CNT_STAT,ISR_RUN	; Clear ISR Flag
				movlw	0x18				; Turn off LO to counter
				iorwf	PORTC,f				; Turn off BFO to coounter	
				CLRF	TMR1L
				CLRF	TMR1H				; Clear the counter
				movlw	.10
				movwf	HIRES_TEMP
				bcf		PORTC,3				; Apply BFO to Counter				
HI_RES_LOOP:
				movlw	.100
				call	X_DELAY100			; Wait 10 msec				
				decfsz	HIRES_TEMP,F		; repeat 10 times
				goto	HI_RES_LOOP
				bsf		PORTC,3				; Turn off BFO to Counter				

				btfsc	CNT_STAT,ISR_RUN	; If INT occured data is invalid												
				goto	BFO_DONE

				movf	TMR1L,W				; Anti-jitter routine
				subwf	LAST_BF1,W
				btfsc	_Z
				goto	BFO_DONE			; Same as last count
				movf	TMR1L,W				; Anti-jitter routine
				subwf	LAST_BF2,W
				btfsc	_Z
				goto	BFO_DONE			; Same as next to last count
				movf	LAST_BF1,W
				movwf	LAST_BF2
				movf	TMR1L,W
				movwf	LAST_BF1			; Save previous states				

				movf	BFO_FRH,W			; Get MSB of desired freq
				subwf	TMR1H,W				; Compare with count
				btfsc	_Z					; If they are equal, check low byte
				goto	COMP_LSB
				btfsc	_C					; Carry clear if BFO_FRH > TMR1H (freq too low)
				goto	BFO_DOWN
				goto	BFO_UP
COMP_LSB:
				movf	BFO_FRL,W			; Get LSB of desired freq
				subwf	TMR1L,W				; Compare with count
				btfsc	_Z					; If they are equal, don't adjust the BFO
				goto	BFO_DONE
				btfsc	_C					; Carry clear if BFO_FRL > TMR1L (freq too low)
				goto	BFO_DN1
				decf	BFO_FRL,W			; dec BFO_FRL could be one count low
				subwf	TMR1L,W				; Compare with count
				btfsc	_Z					; If they are equal, don't adjust the BFO
				goto	BFO_DONE
BFO_UP:
				movlw	0x40
				addwf	BFO_STL,F
				btfsc	_C
				incf	BFO_STH,F
				goto	BFO_UPDATE
BFO_DN1:
				incf	BFO_FRL,W			; inc BFO_FRL could be one count low
				subwf	TMR1L,W				; Compare with count
				btfsc	_Z					; If they are equal, don't adjust the BFO
				goto	BFO_STAY
BFO_DOWN:
				movlw	0x40
				subwf	BFO_STL,F
				btfss	_C
				decf	BFO_STH,F
BFO_UPDATE:
				movf	BFO_STL,W
				movwf	HIRES_TEMP
				rrf		HIRES_TEMP,F
				rrf		HIRES_TEMP,F
				movlw	0x0c
				iorwf	HIRES_TEMP,W
				movwf	CCP1CON
				movf	BFO_STH,W
				movwf	CCPR1L
				goto	BFO_DONE
BFO_STAY
				btfss	SSTAT,BFO_SEEK
				goto	BFO_DONE			; If the BFo isn't seeking then we're done
				bcf		SSTAT,BFO_SEEK
				btfss	OPMODE,2				; Test for LSB
				goto	BFONOTLSB
				movlw	BFO_L
				goto	BFO_EPW
BFONOTLSB:
				movlw	BFO_U
BFO_EPW:
				movwf	EE_ADDR
				movf	BFO_STH,W
				movwf	EE_DATA
				call	EE_WRITE

BFO_DONE:
				return
